#include <Venviron.h>
#include <Vio.h>
#include <Vdirectory.h>
#include <Vteams.h>

extern SystemCode GetContextId();

/*
 * MapRemoteHost:     (Stolen from servers/exec/mi/remote.c)
 * Maps a string name for a host into its corresponding team server 
 * process-id.  0 is returned if no mapping can be performed.
 */
ProcessId MapRemoteHost(host)
    char *host;
  {
    char namebuf[100];
    ContextPair ctx;

    strcpy(namebuf, "[team/");
    strcat(namebuf, host);
    if (GetContextId(namebuf, &ctx) != OK) return 0;

    return(ctx.pid);
  }


HostStatusRecord hoststat;


int GetHostName(teamServerPid, hostName)
    ProcessId teamServerPid;
    char *hostName;
    /* Queries the team server "teamServerPid", to find the name of the host 
     * on which it executes.  The name is returned in "hostName".
     * This routine returns 0 iff the query fails.
     */
  {
    Message msg;
    register UpdateHostStatusRequest *updaterequest
    				 = (UpdateHostStatusRequest *) msg;

    updaterequest->requestcode = UpdateRequest;
    updaterequest->bufferptr = (char *) &hoststat;
    updaterequest->bytecount = sizeof (HostStatusRecord);
    updaterequest->requesttype = 3;		/* must be defined */
    if (Send(msg, teamServerPid) == 0)
        return(0);
    if (updaterequest->requestcode != OK)
        return(0);
    strcpy(hostName, hoststat.hostName);
    return(1);
  }

 /*
  * Gethoststatus:     (This I wrote myself - It wasn't hard)
  *
  * will get you the entire hoststatus as defined by struct hoststattype
  * (which I believe should be defined in Vteams.h), instead of just
  * one item. The name is written in a strange style, since GetHostStatus
  * is already defined in Vteams.h
  */
int Gethoststatus( pid, hoststatus )
    ProcessId pid ;
    struct hoststattype *hoststatus ;
  {
    Message msg ;
    UpdateHostStatusRequest * updaterequest = (UpdateHostStatusRequest *) msg;

    updaterequest->requestcode = UpdateRequest ;
    updaterequest->requesttype = GetHostStatus ;
    updaterequest->bufferptr = (char *) hoststatus ;
    updaterequest->bytecount = sizeof (HostStatusRecord) ;
    Send (updaterequest, pid);
    return( updaterequest->requestcode ) ;
  }
