/* Due to posible timeouts, a group messages should contain a seq.nr.
 * This could be equal to lhn++. If a teamserver receives several
 * requests with the same seq.nr, it only replies once.
 *
 * The teamserver should reply to a group send according to the following 
 * criteria:
 *     - availability
 *     - no of free team-descriptors
 *     - no of free process-descriptors
 *     - idle time (This means that the teamserver should periodicaly
 *       compute the average idle time as e.g., ticks/sec.
 *     - free memory
 *     - periferal equipment  ????
 */



#define HOST_STATUS 1
#define HOST_NAME 2
#define AVAIL_RELEVANT (char) 0x1
#define AVAILABLE (char) 0x2

#define	PROC_FAMILY_FIELD	0xF
#define	PROC_FAMILY_IRRELEVANT	0xF
#define MACH_TYPE_FIELD		0xF0
#define MACH_TYPE_IRRELEVANT	0xF
#define MACH_TYPE_SHIFT		4
#define PROC_TYPE_FIELD		0xFF00
#define PROC_TYPE_IRRELEVANT	0xFF
#define PROC_TYPE_SHIFT		8

#define DELAY_FACTOR 10
#define YOUR_LOOKING_FOR_ME OK


struct hostStatMsg {

#ifndef LITTLE_ENDIAN
    SystemCode  	requestcode ;
    short       	kernelVersionNo ; /* will be added later */
    char		avail ;
    unsigned char	freeTeams ;
    unsigned short	freeProcs ;
#else
    short       	kernelVersionNo ; /* will be added later */
    SystemCode  	requestcode ;
    unsigned short	freeProcs ;
    unsigned char	freeTeams ;
    char		avail ;
#endif
    int			minFreeMem ;
    int 		maxFreeMem ;
    int			minIdleTime ;
    int			maxIdleTime ;
#ifndef LITTLE_ENDIAN
    unsigned short	procMachType ;
    unsigned short	conf1; 
#else
    unsigned short	conf1; 
    unsigned short	procMachType ;
#endif
    unsigned		conf2 ;
    ProcessId		pid ;
} ;


struct nameMsg {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode ;
    short	filler1 ;
#else
    short	filler1 ;
    SystemCode	requestcode ;
#endif
    ProcessId	serverId ;
    long	filler[4] ;
    unsigned	firstEight ;
    unsigned	secondEight ;
} ;
