#include <Venviron.h>
#include <Vteams.h>
#include <Vgroupids.h>
#include <Vdirectory.h>
#include <Vquerykernel.h>


resetStatusMsg( msg )
    struct hostStatMsg *msg ;
  {
    msg->requestcode = HOST_STATUS ;
    msg->avail = 0 ;
    msg->freeTeams = 0 ;
    msg->freeProcs = 0 ;
    msg->minFreeMem = 0 ;
    msg->maxFreeMem = 0 ;
    msg->minIdleTime = 0 ;
    msg->maxIdleTime = 0 ;
    msg->procMachType = ((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
			| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
			| (PROC_FAMILY_IRRELEVANT)) ;
  }


/* getHostDescriptors will send the requestdescriptor to the group of
 * teamservers on the network, and will receive up to max replies.
 * Each reply message  is stored in the descriptor array. This array 
 * must be large enough for max descriptors, with each descriptor
 * having the size of a message. The number of actual replies recieved
 * is returned. NextReply will timeout after one second.
 */


getHostDescriptors (max, descriptorArrayPtr, requestDescriptorPtr)
    int max ;
    struct hostStatMsg descriptorArrayPtr[], *requestDescriptorPtr ;
  {
    int count = 0 ;
    ProcessId pidd ;

    (*requestDescriptorPtr).requestcode = HOST_STATUS ;
    pidd = Send(requestDescriptorPtr, VTEAM_SERVER_GROUP) ;
    if ((pidd != 0) && ((*requestDescriptorPtr).requestcode == OK))
      {
        /* we have to copy the contents of the reply in the requestDescriptor
         * into the first record of the descriptorarray */
        descriptorArrayPtr[0].maxIdleTime = pidd ;	/* take out later */
	descriptorArrayPtr[0].pid = pidd ;
        descriptorArrayPtr[0].avail = (*requestDescriptorPtr).avail ;
        descriptorArrayPtr[0].freeTeams = (*requestDescriptorPtr).freeTeams ;
        descriptorArrayPtr[0].freeProcs = (*requestDescriptorPtr).freeProcs ;
        descriptorArrayPtr[0].minFreeMem = 
			(*requestDescriptorPtr).minFreeMem ;
        descriptorArrayPtr[0].maxFreeMem = 0 ;
        descriptorArrayPtr[0].minIdleTime=
			(*requestDescriptorPtr).minIdleTime;
        descriptorArrayPtr[0].procMachType = 
			(*requestDescriptorPtr).procMachType  ;
        ++count ;
      }
    while ((pidd != 0) && (count < max))
      {
        pidd =  GetReply(&descriptorArrayPtr[count], 100) ;
	if ((pidd != 0) && (descriptorArrayPtr[count].requestcode == OK))
	  {
	    descriptorArrayPtr[count].maxIdleTime = pidd ; /* take out later */
	    descriptorArrayPtr[count].pid = pidd ;
	    count++ ;
	  }
      }
    return (count) ;
  }


/* getReadyHostDescriptors sends a HOST_STATUS request to the group of
 * teamservers on the network, and will receive up to max replies.
 * Only available hosts with at least 1 free team, 3 free processes,
 * 100000 bytes of memory and having a processor of type procFamily
 * will be sollicited.
 * Each reply message  is stored in the descriptor array. This array 
 * must be large enough for max descriptors, with each descriptor
 * having the size of a message. The number of actual replies recieved
 * is returned. NextReply will timeout after one second.
 */


getReadyHostDescriptors (max, procFamily, descriptorArrayPtr )
    int max, procFamily ;
    struct hostStatMsg descriptorArrayPtr[] ;
  {
    int count = 0 ;
    struct hostStatMsg descriptor  ;

    descriptor.requestcode = HOST_STATUS ;
    descriptor.avail = AVAIL_RELEVANT | AVAILABLE ;
    descriptor.freeTeams = 1 ;
    descriptor.freeProcs = 3 ;
    descriptor.minFreeMem = 0 ;
    descriptor.maxFreeMem = 0 ;
    descriptor.minIdleTime = 0 ;
    descriptor.maxIdleTime = 0 ;
    descriptor.procMachType =  ((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
			| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
			| (procFamily)) ;

    return (getHostDescriptors( max, descriptorArrayPtr, &descriptor )) ;
  }


/* get ReadyHosts tries to locate at most max remote hosts with processors
 * of the family procFamily to start remote teams on.
 * The function returns the number of hosts it could locate, with
 * the pids of the teamservers on those hosts in teamPIDs[].
 * That array had better be large enough to accomodate max Pids.
 * The Pids are sorted according to the formula described below.
 */

getReadyHosts ( max, arrayOfPIDs, procFamily)
    int max ;
    ProcessId arrayOfPIDs[] ;
    int procFamily  ;
  {
  
    int  count = 0 ;
    struct hostStatMsg *hostDescriptorArray, descriptor,tmpDescriptor ;
    int high, tmphigh, highindex, i, j ;


    if ((hostDescriptorArray = (struct hostStatMsg *) 
    		malloc (max * sizeof(struct hostStatMsg))) == 0)
      {
        fprintf (stderr, "getHosts could not allocate enough memory\n") ;
	return (0) ;
      }

    descriptor.requestcode = HOST_STATUS ;
    descriptor.avail = AVAIL_RELEVANT | AVAILABLE ;
    descriptor.freeTeams = 2 ;
    descriptor.freeProcs = 3 ;
    descriptor.minFreeMem = 100000 ;
    descriptor.maxFreeMem = 0 ;
    descriptor.minIdleTime = 60 ;
    descriptor.maxIdleTime = 0 ;
    descriptor.procMachType =  ((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
			| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
			| (procFamily)) ;


    if ((hostDescriptorArray = (struct hostStatMsg *) 
    		malloc (max * sizeof(struct hostStatMsg))) == 0)
      {
        fprintf (stderr, "getHosts could not allocate enough memory\n") ;
	return (0) ;
      }
    max = getHostDescriptors (max, hostDescriptorArray, &descriptor ) ;
  
    /* now the hostDescriptors should be sorted
     * This will be done according to the following formula
     *         freeTeams * 10 + minIdleTime
     */

    for (i=0; i<max-1; i++)
      {
        high = 0 ;
        for (j=i; j<max; j++)
	    if ((tmphigh = hostDescriptorArray[j].freeTeams * 10 +
	         hostDescriptorArray[j].minIdleTime) > high)
	      {
	        high = tmphigh ;
		highindex = j ;
	      }
	tmpDescriptor = hostDescriptorArray[i] ;
	hostDescriptorArray[i] = hostDescriptorArray[highindex] ;
        hostDescriptorArray[highindex] = tmpDescriptor ;
      }
      
 /*     for (i=0; i<max; i++)
  *      {
  *	    printf("Host nr %d:    %d\n", 
  *	    	i, hostDescriptorArray[i].maxIdleTime) ;
  *	    printf("    avail: %d\n", hostDescriptorArray[i].avail) ;
  * 	    printf("    freeTeams %d\n", hostDescriptorArray[i].freeTeams ) ;
  *	    printf("    freeProcs %d\n",hostDescriptorArray[i].freeProcs ) ;
  *	    printf("    freeMem %d\n", hostDescriptorArray[i].minFreeMem ) ;
  *	    printf("    Idletime %d\n", hostDescriptorArray[i].minIdleTime ) ;
  *    	    printf("\n") ;
  *        }
  */
    for (i=0; i<max; i++)
        arrayOfPIDs[i] = hostDescriptorArray[i].maxIdleTime ;
    free (hostDescriptorArray) ;
    return (max) ;
	    
  }
