/*	selact.c: special key actions when a selection exists		*/

#include "vedit.h"
#include "chardef.h"

/* SelectionKeyAction: the separate set of key actions available when a
   selection exists.  Important simplifying assumption: the curmark cannot
   be moved and the screen cannot be scrolled while there is a selection.
   Printing charcters not used as special selection-mode commands snap out
   of selection.  Non-printing command characters snap out of selection mode
   and then perform their normal function, acting as if the cursor was at
   the beginning of the selection.
 */
int SelectionKeyAction(ch)  int ch;
{ Chunk chunk;
  int n;
  int quit = 0;

  switch (ch) {

    case 'd':	KillSelection();	/* like button 2 */
		break;

    case 'e':	ExchangeSelection();	/* like button 3 */
		break;

    case 'g':	FreeText(killbuffer);	/* save selection into killbuffer */
		killbuffer = CopySection(curmark, mousemark);
		NewMsg("stored");
		break;

    case 'c':	   /* copy current selection in place */
		chunk = CopySection(curmark, mousemark);
		Deselect();
		InsertSelected(chunk);
		break;

/* RJN -- 4/22/83 -- Added TagSearch  */
    case 't':
    		/* take selection as a tag to search for */
		searchlen = TextString(curmark, mousemark, searchstring, 80);
		searchstring[searchlen] = NULL; /* not ved convention */
	        TagSearch( searchstring );
		break;
		    	    
    case 's':	   /* search for next instance of selected string */
		searchlen = TextString(curmark, mousemark, searchstring, 80);
		/*FALLTHRU*/
    case 'n':	   /* search for stored search string */
		SelFind(Search(searchstring, searchlen));
		break;

    case 'r':      /* reverse 's' */
		searchlen = TextString(curmark, mousemark, searchstring, 80);
		SelFind(ReverseSearch(searchstring, searchlen));
		break;

    case 'S':	   /* search for next instance of replacement string */
		SelFind(Search(repstring, replen));
		break;

    case 'R':	   /* reverse 'S' */
		SelFind(ReverseSearch(repstring, replen));
		break;

    case 'q':	   /* Query Replace selected string */
		NewMsg("Replace with:");
		replen = Getline(repstring, 80);
		if (replen < 0) { replen = 0; break; }
		/*FALLTHRU*/

    case 'y':	   /* "Yes" to Query Replace */
		searchlen = TextString(curmark, mousemark, searchstring, 80);
		chunk = ReplaceSelection(StringText(repstring, replen), 0);
		FreeText(chunk);
		n = Search(searchstring, searchlen);
		if (n) {
		    DispSetcursor(curmark);
		    Select(curmark, mousemark);
		    }
		break;

    case 'Y':	   /* Yes but don't move on */
		searchlen = TextString(curmark, mousemark, searchstring, 80);
		chunk = ReplaceSelection(StringText(repstring, replen), 1);
		FreeText(chunk);
		break;

    case '\b':	   /* back up and undo last replace */
		SelFind(ReverseSearch(repstring, replen));
		 /*FALLTHRU*/
    case 'u':	   /* undo a replace */
		chunk = ReplaceSelection(
			  StringText(searchstring, searchlen),
			  1 );
		FreeText(chunk);
		break;

    case 'Q':	   /* copy selection into replacement string */
		replen = TextString(curmark, mousemark, repstring, 80);
		NewMsg("Replacement string set");
		break;

    case 'i':
		IndentSelection(ch);
		break;

    case CONTROL('L'):  /* redisplay with selection near top of screen */
		Display(Backrows(curmark, Nrows/4));
		curpos = Markpos(curmark);
		Select(curmark, mousemark);
		break;

    case CONTROL('U'):
    		ProvidePrefixArgument(ch);
		break;

    case CONTROL('Z'):	/* scroll - without deselecting */
    case PF1:
    case SMI_PF1:
		Scroll();
		break;

    case ESCAPE('z'):	/* backscroll without deselecting */
    case PF2:
    case SMI_PF2:
		Backscroll();
		break;

    case '\t':	/* deselect and cursor to end of selection */
		Deselect();
		DispSetcursor(mousemark);
		break;

    default:	/* deselect and cursor to beginning of selection */
		Deselect();
		MarkSetcursor(curmark);
		if ((ch < ' ' || ch >= '\177') && ch != '\r')
		  {
		    quit = KeyAction(ch);
				/* now do the command specified */
		  }
    }  /* end switch */
  return(quit);
  }


/*
 * IndentSelection:
 * Indents selected region according to the value of PrefixArgument.
 * Deselects the region and sets the regionmark to the mousemark during
 * its processing.
 */

IndentSelection(ch)
    int ch;
  {
    Deselect();
    regionmark = mousemark;
    IndentRegion(ch);		/* Argument currently unused. */
  }
