/*
 * This file describes the fixed menu and its commands 
 */
#define TEST_FOR_SELECTION	0x80000000

#define MENU_NAME_SEPERATOR	'|'

/* Logical to physical translation of commands */
#define SCROLL_UP_LINE		(CONTROL('Z'))
#define SCROLL_DOWN_LINE	(ESCAPE('z'))
#define NEXT_FULL_PAGE		(CONTROL('V'))
#define PREV_FULL_PAGE		(ESCAPE('v'))
#define NEXT_HALF_PAGE		(ESCAPE(ANSI('B')))
#define PREV_HALF_PAGE		(ESCAPE(ANSI('A')))
#define GOTO_END_OF_FILE	(ESCAPE('>'))
#define GOTO_START_OF_FILE	(ESCAPE('<'))
#define FORWARD_SEARCH		( ((unsigned)'s') | TEST_FOR_SELECTION )
#define REVERSE_SEARCH		( ((unsigned)'r') | TEST_FOR_SELECTION )
#define TAG_SEARCH		( ((unsigned)'t') | TEST_FOR_SELECTION )
#define SET_THE_MARK		(CONTROL('@'))
#define GOTO_THE_MARK		(CONTROLX(CONTROL('X')))

#define INVALID_COMMAND		(-1)

char FixedMenu[ Ncols + 10 ];		/* plus some slop */
unsigned long FixedMenuHits[ Ncols + 10 ][ 2 ];
extern short selectionexists;

/* Produce a command which make sense dependent upon the action */
#define FixedMenuSelection( target, command )			\
	( (FixedMenuHits[target][command]&TEST_FOR_SELECTION) 	\
	   ? ( selectionexists  ? ((unsigned short)(FixedMenuHits \
	                         	[target][command]))  \
	    	                : INVALID_COMMAND )    \
           : FixedMenuHits[target][command] )		



