/*
 * Functions dealing with edit buffers.
 */


#include <Vgts.h>
#include "vedit.h"
#include "chardef.h"


/*
 * VisitFileNewBuffer:
 */

VisitFileNewBuffer(ch)
    int ch;
  {
    int flag;			/* Signals if the user should be queried
				   for the row size of the new buffer 
				   window. */
    int n, n1, nRows;
    char smallLineBuf[10];
    Chunk nchunk;

    if (ch == CONTROLX('g'))
      {
	flag = 0;
      }
    else
      {
	flag = 1;
      }
    Flush(pad);
    RedrawPad(pad);
    StoreBuffer(thisbuffer);
    NewMsg("get file: ");
    n = Getline(linebuf, 72);
    if (n < 0)
      {
	return;		/* User abort. */
      }
    if (flag)
      {
	NewMsg("window size: (36) ");
	n1 = Getline(smallLineBuf, 10);
	if (n1 < 0)
	  {
	    return;		/* User abort. */
	  }
      }
    if (n > 0)
	nchunk = ReadFile(OpenName(filename, linebuf));
    else
      {				/* Blank file name */
	nchunk = NULL;
	filename[0] = '\0';
      }
    if (flag)
      {
	if (n1 > 0)
	    nRows = atoi(smallLineBuf);
	else
	    nRows = NrowsBigDefault;
      }
    else
      {
	nRows = NrowsDefault;
      }
    n = NewBuffer(nchunk, nRows);
    if (n == 0)
	FreeText(nchunk);
    wishcol = 0;
  }


/* NewBuffer: given a Chunk pointer, which may be NULL, creates a buffer with
   the first available buffer id number, and displays it in a window in the
   appropriate place.  The new buffer will be the current one, so the previous
   current buffer should be stored before NewBuffer is called.  The new
   window is selected for input.  If pad creation fails, or there is not
   enough memory, returns 0, else 1.
   nRows specifies how many rows the buffer is to have.
 */
int NewBuffer(contents, nRows)
    Chunk contents;
    short nRows;
{ register int bufid;
  register BufferRec *buf;
  static char *PadNameFormat = "Ved %d";
  char PadName[ 10 ];
  Message msg;

  /* find an unused buffer i.d. */
  for (bufid = 0;  bufid < Maxbufs && buffers[bufid].pad != 0;  bufid++) ;
  if (bufid == Maxbufs) {
    NewMsg("No more buffers!");  Beep();
    return(0);
    }

  /* create a place to store its variables */
  buf = (BufferRec *) calloc(1, sizeof(BufferRec));
  buf->fileRec = (FileRec *) calloc(1, sizeof(FileRec));
  buffers[bufid].ptr = buf;
  /* create the row descriptor array */
  buf->nRows = nRows;
  rows = (Rowrec *) calloc(nRows+1,sizeof(struct Rowrec));
  Nrows = nRows;
  
  /* create the Marklist for this buffer's Marks */
  Marklist = NULL;
  Addmark(&curmark);
  Addmark(&endmark);
  Addmark(&regionmark);
  Addmark(&mousemark);
  Addmark(&eolmark);
  Addmark(&tempmark);
  
  /* see if we're out of memory */
  if (buf == NULL || rows == NULL || addmarkfail) {
    NewMsg("Out of memory!  Buffer not created!");
    if (buf != NULL)
      {
        free(buf->fileRec);
        free(buf);
      }
    if (rows != NULL) free(rows);
    goto Bailout;
    }

  /* establish the buffer start and end marks */
  if (contents)  InitBuffer(contents, Findend(contents));
   else  ClearBuffer();

  /* create a window and keyboard watcher process for it */

  sprintf( PadName, PadNameFormat, bufid + 1 );	/* gotta get the # right */
  pad = OpenPad(PadName, nRows+1, Ncols, &paderr);
  if (pad == NULL || paderr != OK) {
    Msg("   Aborted");
    free(rows);
    free(buf->fileRec);
    free(buf);
Bailout:
    if (thisbuffer >= 0)  SelectBuffer(thisbuffer);
    addmarkfail = 0;
    return(0);
    }
  ModifyPad(pad,ReportTransition);  /* Totally raw input with mouse */

  infile = OpenFile(pad->fileserver,pad->fileid,FREAD,&paderr);
  if (infile == NULL || paderr != OK) {
    PrintError(paderr,"can't open input: ");
    free(rows);
    free(buf->fileRec);
    free(buf);
    goto Bailout;
    }
  else {
    if (mainproc == 0) {	/* initial buffer 1st time */
	keyproc = Create(9, ReaderProcess, Keyprocstack);
	Ready(keyproc,2,bufid,infile);
	}
    else {
	msg[0] = CREATE_KEYPROC;
	msg[1] = bufid;
	Send(msg, rootproc);
	}
    }

  /* display and establish page and cursor marks */
  Display(headmark);
  Setcursor(headmark, zeropos);
  ckpmodified = modified = selectionexists = 0;
  thisbuffer = bufid;

  SelectPad(pad);
  incommandwindow = 0;
/*^*/ myprint(0x800)("New buffer %d chunk %x keyproc %x\n",
	bufid,headmark.chunk,keyproc);
  return(1);
  }



/* DeleteBuffer: delete the current buffer and all it entails.  Leaves the
   next-lower-numbered buffer selected and returns its number.  Returns -1
   if the last buffer was deleted.  */
/*
 * CRZ 5/20/85 Moved around the lines so that we either SelectBuffer a new
 *	       buffer (i.e. if there is another one) or SelectPad the output
 *	       pad (i.e. the main window) (when there are no windows left)
 *	       BEFORE the call to Close(), otherwise the vgt selects Vgt 1,
 *	       which may not be the desired window.
 */
int DeleteBuffer()
{ register int n;
  Message msg;
  int buftokill;
  File *padtokill;

  FreeText(headmark.chunk);		/* free the chunks */
  free(rows);				/* free the row descriptor array */
  buftokill = thisbuffer;
  padtokill = pad;
  msg[0] = DESTROY_KEYPROC;
  Send(msg, rootproc);			/* get the global keyproc destroyed */
  buffers[buftokill].pad = 0;
  n = PrevBuffer(thisbuffer);
/*^*/ myprint(0x800)("\nPrevBuffer returned %d for buffer #%d", n, thisbuffer );
  if (n >= 0)
      SelectBuffer(n);			/* select if one exists (sets keyproc)*/
  else
      SelectPad(stdout);		/* if last, select main window */
  Close(padtokill);
  if (buffers[buftokill].ptr != NULL)
    {
      free(buffers[buftokill].ptr->fileRec);
					/* free the file record */
      free(buffers[buftokill].ptr);	/* free the buffer record */
    }
  if (n < 0)  return(-1);  
  return(n);
  }

/* StoreBuffer: save the current buffer into an inactive buffer record. */
StoreBuffer(bufid)  int bufid;
{ register BufferRec *buf;
  buf = buffers[bufid].ptr;
  strcpy(buf->fileRec->filename, filename);
  buf->rows = rows;
  buf->Marklist = Marklist;
  buf->headmark = headmark;  buf->endmark = endmark;
  buf->regionmark = regionmark;  buf->curmark = curmark;
  buf->mousemark = mousemark;
  buf->curpos = curpos;
  buf->fileRec->modified = modified;  
  buf->fileRec->ckpmodified = ckpmodified;  
  buf->selectionexists = selectionexists;
  buf->pad = pad;  buf->infile = infile;
  buf->keyproc = keyproc;

  buffers[bufid].pad = pad;
/*^*/ myprint(0x800)("stored filename '%s'\n",buf->fileRec->filename);
  }

/* SelectBuffer: make an inactive window into the current editing window.
   Fetches its buffer and selects it for input. */
SelectBuffer(bufid)  int bufid;
{
  FetchBuffer(bufid);
  thisbuffer = bufid;
  Nrows = (buffers[bufid].ptr)->nRows;
  wishcol = curcol;
  SelectPad(pad);
  incommandwindow = 0;
  }

/* RJN -- 4/22/83 -- created FindBuffer */
/* Find the Buffer which has the associated file name associated with it. 
 * It returns the Buffer index or -1 on failure.
 * filename must be null terminated.
 */
int FindBuffer(filename) 
    char *filename;
  {
    register char *fnp, *bnp;
    register int i;
    register struct BUFTABLE *bp;
    extern struct BUFTABLE buffers[];
    
    /* search all valid buffers for a match */
    for( i = 0, bp = buffers; i < Maxbufs; i++,bp++ )
      {
        if ( bp->pad != 0 )
	  {
	    fnp = filename;
	    bnp = bp->ptr->fileRec->filename;
	    while (*bnp == *fnp && *fnp) fnp++,bnp++;
	    if (*bnp == *fnp) break;
	  }
      }
    return( i < Maxbufs ? i : -1 );
  } /* FindBuffer */
	      
    
/* FetchBuffer: make an inactive buffer into the current one.  Does not
   actually select it for input, this may be transient. */
FetchBuffer(bufid)  int bufid;
{ register BufferRec *buf;

  if (buffers[bufid].ptr)  buf = buffers[bufid].ptr;
  else {
    ErrorMsg("FetchBuffer: nonexistent buffer");
    return;
    }

  strcpy(filename, buf->fileRec->filename);
  rows = buf->rows;
  Marklist = buf->Marklist;
  headmark = buf->headmark;  endmark = buf->endmark;
  regionmark = buf->regionmark;  curmark = buf->curmark;
  mousemark = buf->mousemark;
  curpos = buf->curpos;
  modified = buf->fileRec->modified;  
  ckpmodified = buf->fileRec->ckpmodified;  
  selectionexists = buf->selectionexists;
  pad = buf->pad;  infile = buf->infile;
  keyproc = buf->keyproc;

/*^*/ myprint(0x800)("fetched buffer %d stored with name '%s' to name '%s'\n",
		bufid, buf->fileRec->filename, filename);
  }


/* PrevBuffer: given a buffer i.d. find the next-lower-numbered buffer.
   Will find the same old buffer if it is valid and if no others exist.
   Returns -1 if no buffers exist.  */
int PrevBuffer(n)  int n;
{ register int b;

  for (b = n-1; b >= 0; b--)
    if (buffers[b].pad != 0) return(b);
  for (b = 8; b >= n; b--)
    if (buffers[b].pad != 0) return(b);
  return(-1);
  }

/* PickBuffer: the command routine for the keypad keys 1-9.  Selects that
   buffer if there is such a buffer, otherwise beeps.  */
PickBuffer(b)  
    int b;
  {
  if (buffers[b].pad == 0)  {
    Beep();  /* macro, must be enclosed in braces here */
    }
  else {
    Flush(pad);  RedrawPad(pad);
    StoreBuffer(thisbuffer);
    SelectBuffer(b);
    wishcol = curcol;
    }
  }
