/*	action.c:	Keyboard Command Actions 			*/

#include "vedit.h"
#include "chardef.h"
#include "ansipad.h"
#include "key.h"

extern File *OpenName();
File *FileDesc;

/* The compound command system:  the following sequences are recognized	*/
/* as command prefixes, not as command prefixes in themselves.  This	*/
/* recognition is handled in StateMachine, which returns -1 until it 	*/
/* has recognized a complete command, then adds high order bits to the	*/
/* final character to indicate the prefix.				*/
/* Escape		like the "meta" key in the original emacs	*/
/* Control-X		precedes "large" file, buffer, region commands	*/
/* Escape Escape	prefix to "escape arrow" sequences on SMI's	*/
/* Escape [		prefix to ANSI standard arrow key codes		*/
/* Escape [ O		prefix to SMI PF1-PF4 keys			*/
/* Escape Escape [	"escape-arrow"					*/
/* Escape Escape [ O	"escape-PFn"					*/
/* The macros by which I express these compound commands, CONTROL,	*/
/* ESCAPE, and ANSI, are defined in chardef.h .				*/

int	quoted = 0, hiquote = 0, keystate = 0, escmodifier = 0;

unsigned int PreviousUserCmd = 0;
				/* Previous command invoked by user. */
int PrefixArgument = 1;		/* Numeric prefix argument for command
				   functions. */
int ProvidePrefixArgumentKey;	/* Key which is bound to 
				   ProvidePrefixArgument(). */

int QuitEditor;			/* Signals whether the editor should be
				   exitted. */

extern KeyTableRec KeyTable[];

/* Setstate and Clearstate are local macros to StateMachine */
#define Setstate(s)	{keystate = s;  return(-1);}
#define Clearstate(b)	{n = ch | b | escmodifier;  \
			 keystate = escmodifier = 0;  \
			 return(n);}


int StateMachine(ch)  char ch;
{
  int n;
  switch(keystate) {
    case 0:	if (ch == ESC)  {Setstate(1);}
		else if (ch == CONTROL('X'))  {Setstate(2);}
		else return(ch);
	/* esc */
    case 1:	if (ch == ESC) {
		    escmodifier = 0x100;
		    return(-1);  /* stay in state 1 */
		    }
		else if (ch == '[') {Setstate(3);}
		else if (ch == 'O') {Setstate(4);}
		else {Clearstate(0x100);}
	/* ^X */
    case 2:	Clearstate(0x200);
	/* esc [ */
    case 3:	Clearstate(0x400);
	/* esc O */
    case 4:	Clearstate(0x800);
    }
  }


KeyAction(ch)  
  int ch;
{ 
  unsigned int cmd;

  int i, n, n1;
  char *cp, c;
  Chunk chunk,nchunk;
  Pos p;
  Mark m;
  Marklink marklp;

  QuitEditor = 0;
  cmd = ch;
  if (PreviousUserCmd != ProvidePrefixArgumentKey)
    {
      PrefixArgument = 1;
    }
  if (hiquote) 
    {
      SelfInsert(ch|0x80);
      hiquote = 0;
    }
  else if (quoted) 
    {
      SelfInsert(ch);
      quoted = 0;
    }
  else if (cmd >= ' ' && cmd < '\177')
    {
      KeyTable[MapKey(ch)].fcn(ch);
    }
  else switch(cmd) {

    case CONTROL('Q'):	/* quote following character */
	quoted = 1;
	break;

    case CONTROL('\\'):	/* insert following character with high bit set */
	hiquote = 1;
	break;

    case K1:	PickBuffer(0);  break;
    case K2:	PickBuffer(1);  break;
    case K3:	PickBuffer(2);  break;
    case K4:	PickBuffer(3);  break;
    case K5:	PickBuffer(4);  break;
    case K6:	PickBuffer(5);  break;
    case K7:	PickBuffer(6);  break;
    case K8:	PickBuffer(7);  break;
    case K9:	PickBuffer(8);  break;

/************************  Debugging Keys  *************************/

    case CONTROLX('s'):	/* manually run the scavenger */
	Scavenge(curmark.chunk);
	break;

    case ESCAPE('\n'): /* force a CR and flush of stdout */
	putchar('\n');
	Flush(stdout);
	break;

    case ESCAPE('0'):	/* dynamic control of debug */
	NewMsg("debug> ");  n = Getline(linebuf,72);
	sscanf(linebuf,"%x",&debug);
	printf("debug is %x\n",debug);
	Flush(stdout);
	break;

    case ESCAPE('1'):	/* dump cursor data */
	printf("cursor: chunk=%x  cp=%x  row=%d  col=%d  ch=%c,  wishcol=%d\n",
		curmark.chunk,curmark.cp,currow,curcol,*curmark.cp,wishcol);
	Flush(stdout);
	break;

    case ESCAPE('2'):	/* contents of the current chunk */
	putchar('\n');
	for (cp = curmark.chunk->text; cp < Chunkend(curmark.chunk); cp++)
		putchar(*cp);
	putchar(11);	/* control-K, a vertical bar */
	putchar('\n');
	Flush(stdout);
	break;

    case ESCAPE('3'):	/* dump the Marklist */
	putchar('\n');
	for (marklp = Marklist; marklp; marklp = marklp->next)
	    printf("<chunk %x, cp %x>  ",marklp->pmark->chunk,
		marklp->pmark->cp);
	putchar('\n');  Flush(stdout);
	break;

    case ESCAPE('4'):
	printf("\n");
	DumpChunks(headmark.chunk);
	break;

    case ESCAPE('5'):
	SixRows();
	break;

    case ESCAPE('6'):
	LastRows();
	break;

    case ESCAPE('7'):    /* chunks and contents of killbuffer */
	printf("killbuffer:\n");
	DumpChunks(killbuffer);
	for (chunk = killbuffer; chunk; chunk = chunk->next)
	  for (cp = chunk->text; cp < Chunkend(chunk); cp++)
		putchar(*cp);
	Flush(stdout);
	break;

    case ESCAPE('8'):	/* cause a SplitChunk at cursor */
	if (curmark.cp == curmark.chunk->text)
		NewMsg("At chunk start, can't split.");
	else if (curmark.cp == Chunkend(curmark.chunk))
		NewMsg("At chunk end, can't split.");
	else {
	    SplitChunk(curmark.chunk,curmark.cp);
	    NewMsg("chunk split");}
	break;

    case ESCAPE('9'):		/* cause an exception on purpose */
	chunk = NULL;
	chunk = chunk->prev;  /* BOOM! */
	break;

    case ESCAPE('-'):		/* display major Marks */
	printf("headmark = (%x, %x)  endmark = (%x, %x)  regionmark = (%x, %x)\n",
		headmark.chunk, headmark.cp, endmark.chunk, endmark.cp,
		regionmark.chunk, regionmark.cp);
	Flush(stdout);
	break;

    default:
	KeyTable[MapKey(ch)].fcn(ch);
	break;
    }  /* end switch(cmd) */

  PreviousUserCmd = cmd;
  return(QuitEditor);
  } /* end KeyAction() */
