/* Machine dependent routines for unexec */

#include <Vio.h>
#include <Vprocess.h>
#include <b.out.h>

/* return the offset of the start of the symbol table */

long StartOfSymbolTable(header)
struct bhdr *header;
  {
    return (sizeof(*header) + header->tsize + header->dsize);
  }


/* return the offset of the start of program text */

long StartOfText(header)
struct bhdr *header;
  {
    return(sizeof(*header));
  }

/* return the offset of the given C symbol */

long OffsetOfSymbol(symbol, objFile, objHeader)
char *symbol;
File *objFile;
struct bhdr *objHeader;
  {
    long symbolAddress = AddressOfSymbol(symbol, objFile, objHeader);
    
    return(sizeof(*objHeader) + symbolAddress - TEAM_ORIGIN);
  }

long AddressOfSymbol(symbol, objFile, objHeader)
char *symbol;
File *objFile;
struct bhdr *objHeader;
  {
    struct sym sym;
    char symname[SYMLENGTH+2];	/* not sure if I need one or two */

    fseek(objFile, sizeof(*objHeader) + objHeader->tsize + objHeader->dsize,
    	  ABS_BYTE);
    
    while (ftell(objFile) < sizeof(*objHeader) + objHeader->tsize +
    		objHeader->dsize + objHeader->ssize)
      {
        fread(&sym, sizeof(sym), 1, objFile);
	/* even alignment - read either 1 or 2 nulls */
	fread(symname, 1, (sym.slength + 2) & ~1, objFile);
	if (strcmp(symbol, symname) == 0)
	    return(sym.svalue);
      }
    fprintf(stderr, "Couldn't find %s in symbol table\n", symbol);
  }
