/*
 * type.c - a program to type files for V
 *
 * Fixed up by Bill Nowicki December 1982
 *
 * Fixed up again -- RJN -- 9/8/83
 *
 * RJN -- 2/14/83
 * 	- Removed the "f->state == OK" condition from the while
 *	  loop with fgets(), since fgets will always tell you
 *	  when EOF is reached.  This fix allows files that don't
 *	  end with '\n' to be completely displayed by type.
 *
 */

# include <Vio.h>
# include <Vtermagent.h>

# define BUFSIZE 2000		/* max chars per line */

# define INVERT_MODE	"\033[1m"
# define NORMAL_MODE	"\033[0m"
# define ERASE_TO_EOL	"\033K"

int LinesPerPage;

main(argc,argv)
int argc;
char **argv;
  {
    Message Msg;
    char fileName[128];
    SystemCode error;
    static char charBuffer[BUFSIZE];
    File *f;
    char ch;
    int line;
    int MoreThanOne;
    int Quit;
    int VgtsPresent;

    if (--argc < 1) 
      {
        printf("Filename: ");
	Flush(stdout);
        gets(fileName);
	if (strlen(fileName)) argc++;
      }
    else
      {
	strcpy(fileName,*++argv);
      }
   
    VgtsPresent = (GetPid( VGT_SERVER, LOCAL_PID) == FileServer( stdin ) );
    ModifyPad( stdin, LF_Output + CR_Input );
    Quit = 0;
	  
    /* Find the size of the output pad (in lines). */
      {
	Message msg;
	struct ModifyMsg *req = (struct ModifyMsg *)msg;
	RawIOReply *rep = (RawIOReply *)msg;
	int padsize;
	
	req->requestcode = QueryPadRequest;
	req->fileid = stdout->fileid;
	req->lines = 28; /* default */
	Send(req, stdout->fileserver);
	
	if (rep->replycode != OK)
	  {
	    PrintError(rep->replycode, "Failed to determine pad size");
	    exit (-1);
	  }
	padsize = req->lines;
	if (padsize < 3) padsize = 3;
	LinesPerPage = padsize - 2;
      }

    MoreThanOne = argc > 1;

    line = 0;
    for(;;)
      {
	if ( MoreThanOne ) 
	  {
	    if ( VgtsPresent ) 
		printf("\n%sFile: %s%s\n", INVERT_MODE, fileName, NORMAL_MODE );
	    else
		printf("\nFile: %s\n", fileName );
	    Flush(stdout);
	    line++;
	  }
	f = Open( fileName, FREAD, &error);
	if (error || (f == NULL)) 
	    printf("Open error: %s\n",ErrorString(error));
	else 
	  {
	    while ( !Quit && fgets(charBuffer,BUFSIZE,f) != 0 ) 
	      {
		fputs(charBuffer,stdout);
		if (line++ >= LinesPerPage)
		  {
	  	    Quit = Next( VgtsPresent, "Page", "", &line );
		  }
	      }
	    Close(f);
	  }
       if (--argc < 1 || Quit)
	   break;
       if ( Next( VgtsPresent, "File: ", *++argv, &line ) == 1 )
	   break;
       strcpy(fileName ,*argv);
     }
  }


Next( VgtsPresent, Word, Name, Line )
    int VgtsPresent;
    char *Word;
    char *Name;
    int *Line;
  {
    int Answer = 0;

    if ( VgtsPresent )
	printf( "%sNext %s%s%s", INVERT_MODE, Word, Name, NORMAL_MODE );
    else
	printf( "--Next %s%s--", Word, Name );
    Flush(stdout);
    switch (getchar())
      {
	case 'q':
	case 'Q':
	case 3:	/* '^c' */
	     Answer = 1;
	     break;
	case '\n':
	     *Line = LinesPerPage;
	     break;
	default:
	     *Line = 0;
	     break;
      }
     if ( VgtsPresent )
	 printf( "\r%s", ERASE_TO_EOL );
     else
	 printf( "\r                                                                           \r" );
    return( Answer );
  }
