#include <Venviron.h>
#include <Vio.h>
#include <Vteams.h>
#include <Vdirectory.h>

/* process priorities, stack sizes */

#define SENDER_PRIO	1
#define HIGHER_PRIO	(SENDER_PRIO - 1)
#define SAME_PRIO	(SENDER_PRIO)
#define LOWER_PRIO	(SENDER_PRIO + 1)
#define SENDER_STACK	1000
#define RECEIVER_STACK	1000

/* misc constants */

#define TRUE		1
#define FALSE		0
#define MAX_NAME_LEN	100
#define OVERHEAD_LOOPS	50000

/* timing test codes -- used in timingCode and typeOfTest fields of message */

#define RESYNCH		  1
#define START_TRIAL	  2
#define REPORT_TIMES	  3
#define MSG_TEST	  4
#define SHORT_READ_TEST	 (5 | WRITE_BIT)  /* to conform to SystemCode rules */
#define SHORT_WRITE_TEST (6 | READ_BIT)   /* (a file "write" requires READ  */
#define LONG_READ_TEST	 (7 | WRITE_BIT)  /* access to the senders segment, */
#define LONG_WRITE_TEST	 (8 | READ_BIT)   /* and vice versa)                */
#define SET_TEAM_PRIO	  9
#define SET_PROC_PRIO	 10

/* structure of all messages exchanged between timing processes */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		timingCode;	/* any one of the above codes */
    SystemCode		typeOfTest;	/* any of the TEST codes */
#else !LITTLE_ENDIAN
    SystemCode		typeOfTest;
    SystemCode		timingCode;
#endif LITTLE_ENDIAN
    unsigned		interHost;	/* TRUE if testing between hosts */
    unsigned		msgsPerTrial;
    unsigned		overheadPerMsg;	/* from Receiver, in microseconds */
    unsigned		idlePerMsg;	/* from Receiver, in microseconds */
    unsigned		delivery;
    char		*segmentPtr;	/* non-NULL for READ or WRITE test */
    unsigned		segmentSize;	/* non-zero for READ or WRITE test */
  }
    TimingMsg;
