/*
 *  This is the Sender process which performs the tests and prints the results
 */

#include "timeipc.h"


/* external variables imported from root process */

extern char		SenderHost[];
extern char		ReceiverHost[];

extern ProcessId	RootPid;
extern ProcessId	SenderPid;
extern ProcessId	ReceiverPid;

extern SystemCode	TypeOfTest;
extern unsigned		InterHost;
extern unsigned		ReceiverPrio;
extern unsigned		MsgsPerTrial;
extern unsigned		NumberOfTrials;
extern char		*SegmentPtr;
extern unsigned		SegmentSize;


Sender()
  {
    Message		message;
    register TimingMsg	*msg = (TimingMsg *) message;
    register unsigned	msgCounter;
    register ProcessId	receiverPid;
    register SystemCode	typeOfTest;

    unsigned		elapsedPerMsg, overheadPerMsg, idlePerMsg;
    unsigned		segmentDataRate;
    double		elapsedSeconds, overheadSeconds, idleSeconds;
    double		totalElapsedSeconds, totalElapsedPerMsg;
    double		totalSenderOverheadPerMsg, totalSenderIdlePerMsg;
    double		totalReceiverOverheadPerMsg, totalReceiverIdlePerMsg;
    double		totalSegmentDataRate;
    unsigned		trial, now;

    extern char		*ctime();

    for(;;)
      {
	receiverPid = ReceiverPid;   /* move these two into register vars */
	typeOfTest  = TypeOfTest;

	msg->typeOfTest   = TypeOfTest;	   /* initialize the test message */
	msg->interHost    = InterHost;
	msg->msgsPerTrial = MsgsPerTrial;
	msg->segmentPtr   = SegmentPtr;
	msg->segmentSize  = SegmentSize;

	totalElapsedSeconds         = 0.0;	/* initialize statistics */
	totalElapsedPerMsg          = 0.0;
	totalSenderOverheadPerMsg   = 0.0;
	totalReceiverOverheadPerMsg = 0.0;
	totalSenderIdlePerMsg       = 0.0;
	totalReceiverIdlePerMsg     = 0.0;
	totalSegmentDataRate        = 0.0;

	printf( "\n  %s test",
	    typeOfTest == MSG_TEST         ? "Send-Receive-Reply"            :
	    typeOfTest == SHORT_READ_TEST  ? "Send-Receive-ReplyWithSegment" :
	    typeOfTest == SHORT_WRITE_TEST ? "Send-ReceiveWithSegment-Reply" :
	    typeOfTest == LONG_READ_TEST   ? "Send-Receive-MoveTo-Reply"     :
	    typeOfTest == LONG_WRITE_TEST  ? "Send-Receive-MoveFrom-Reply"   :
					     "Mystery" );
	if( SegmentSize != 0 )
	    printf( " with %u byte segments", SegmentSize );

	if( InterHost )
	    printf( "\n  between sender host '%s' and receiver host '%s'",
						SenderHost, ReceiverHost );
	else
	  {
	    if( Equal( ReceiverHost, "sameteam" ) )
		printf( "\n  within one team on host '%s'", SenderHost );
	    else
		printf( "\n  between two teams on host '%s'", SenderHost );

	    printf( " (sender prio %u, receiver prio %u)",
			SENDER_PRIO, ReceiverPrio );
	  }

	printf( "\n  %u message%s per trial, %u trial%s",
		MsgsPerTrial,   (MsgsPerTrial == 1)   ? "" : "s",
		NumberOfTrials, (NumberOfTrials == 1) ? "" : "s" );

	now = GetTime( NULL );
	printf( "   %s", ctime( &now ) );  /* ctime includes a "\n" */

        printf( "\n                            sender   receiver" );
	if( InterHost )
	    printf( "   sender   receiver" );

	printf( "\ntrial   elapsed  elapsed   overhead  overhead" );
	if( InterHost )
	    printf( "  idle CPU  idle CPU" );
	if( SegmentSize != 0 )
	    printf( "  seg rate" );

	printf( "\nnumber  seconds  usec/msg  usec/msg  usec/msg" );
	if( InterHost )
	    printf( "  usec/msg  usec/msg" );
	if( SegmentSize != 0 )
	    printf( "  bits/sec" );

	printf( "\n" );

	for( trial = 1; trial <= NumberOfTrials; ++trial )
	  {
	    printf( "\n%4u ", trial );
	    fflush( stdout );
	    Delay( 1, 0 );	/* wait a sec for output to be flushed */
	    msgCounter = MsgsPerTrial;

	    /***************************************************************/
	    /* BEWARE: Time- and priority-critical stuff starts here.  For */
	    /* InterHost tests, the Looper process sucks up all unused CPU */
	    /* cycles, preventing all I/O.  Be careful if making changes!  */
	    /***************************************************************/

	    if( InterHost ) CreateLooper();

	    msg->timingCode = START_TRIAL;	/* initialize the Receiver */
	    Send( msg, receiverPid );
	    if( msg->timingCode != OK )
	      {
		if( InterHost) DestroyLooper();
		goto next_test;
	      }

	    StartTiming();

	    do					 /* here's the inner loop */
	      {
		msg->timingCode = typeOfTest;
		Send( msg, receiverPid );
		if( msg->timingCode != OK )
		  {
		    if( InterHost ) DestroyLooper();
		    goto next_test;
		  }
	      }
	    while( --msgCounter );

	    StopTiming( &elapsedSeconds, &idleSeconds );

	    if( InterHost ) DestroyLooper();

	    /*******************************************************/
	    /* RELAX: Time- and priority-critical stuff ends here. */
	    /*******************************************************/

	    msg->timingCode = REPORT_TIMES;   /* get results from Receiver */
	    Send( msg, receiverPid );
	    if( msg->timingCode != OK )
	      {
		goto next_test;
	      }

	    /* measure overhead */

	    typeOfTest = OK;
	    msgCounter = OVERHEAD_LOOPS;
	    StartTiming();
	    do
	      {
		msg->timingCode = typeOfTest;
		if( msg->timingCode != OK )
			abort( "I don't believe it!" );
	      }
	    while( --msgCounter );
	    StopTiming( &overheadSeconds, NULL );
	    typeOfTest = TypeOfTest;

	    /* convert to microseconds per message */

	    elapsedPerMsg  = ( ( elapsedSeconds / MsgsPerTrial )
							* 1000000.0 ) + 0.5;
	    overheadPerMsg = ( ( overheadSeconds / OVERHEAD_LOOPS )
							* 1000000.0 ) + 0.5;
	    idlePerMsg     = ( ( idleSeconds / MsgsPerTrial )
							* 1000000.0 ) + 0.5;

	    segmentDataRate = ( elapsedSeconds == 0.0 ) ? 0 :
			      ( ( (double) MsgsPerTrial * (double) SegmentSize
					   * 8.0 ) / elapsedSeconds ) + 0.5;

	    printf( "%10.3f %9u %9u %9u", elapsedSeconds,
					  elapsedPerMsg,
					  overheadPerMsg,
					  msg->overheadPerMsg );

	    if( InterHost ) printf( " %9u %9u",
					  idlePerMsg,
					  msg->idlePerMsg );

	    if( SegmentSize != 0 ) printf( " %9u",
					  segmentDataRate );

	    totalElapsedSeconds         += elapsedSeconds;
	    totalElapsedPerMsg          += elapsedPerMsg;
	    totalSenderOverheadPerMsg   += overheadPerMsg;
	    totalReceiverOverheadPerMsg += msg->overheadPerMsg;
	    totalSenderIdlePerMsg       += idlePerMsg;
	    totalReceiverIdlePerMsg     += msg->idlePerMsg;
	    totalSegmentDataRate        += segmentDataRate;

	  }  /* loop back for next trial */

	if( NumberOfTrials > 1 )
	  {
	    printf( "\n\navg. %10.3f %9.0f %9.0f %9.0f",
				totalElapsedSeconds / NumberOfTrials,
				totalElapsedPerMsg / NumberOfTrials,
				totalSenderOverheadPerMsg / NumberOfTrials,
				totalReceiverOverheadPerMsg / NumberOfTrials );

	    if( InterHost ) printf( " %9.0f %9.0f",
				totalSenderIdlePerMsg / NumberOfTrials,
				totalReceiverIdlePerMsg / NumberOfTrials );

	    if( SegmentSize != 0 ) printf( " %9.0f",
				totalSegmentDataRate / NumberOfTrials );
	  }

	printf( "\n" );
	fflush( stdout );

next_test:
	msg->timingCode &= REPLY_RETURN_CODE;	/* strip off high bits */
	Send( msg, RootPid ); /* send last reply code back to root process */
      }			      /* and await the next set of test parameters */
  }
