/*
 *   Program to test exception server.
 *   Copyright 1982 (c) David R. Cheriton
 *
 * Fixed by Bill Nowicki and Tim Mann January 1983
 * 8/18/83 (TPM) Fixed some more.
 */

#include <Vio.h>
#include <Vprocess.h>

static  Processor_state pstate;
static  Message msg;

extern PrivilegedOp(), IllegalOp(), TraceTrap(), BusError(), AddrError(),
    PokeKernel(), DivideZero(), CheckInstruction(), TrapV(), abort(), Trap();

main()
  {
    ProcessId pid;
    char c;
    int (*func)();
    SystemCode err;
    char s[80];

    pid = GetPid(EXCEPTION_SERVER,LOCAL_PID);
    if ( pid == 0 ) 
      {
	if ( pid = InitExceptionServer() )
		printf( "Initalized exception server, pid 0x%x\n", pid);
	else printf("Error starting exception server\n");
      }
     else printf("Exception server is pid 0x%x\n", pid );
     c = ~ 'q';

     while( c != 'q' )
      {
	printf( "Pick an exception: " );
	Flush(stdout);
	gets(s);
	c = (s[0] & 0x007F);
	switch( c )
	 {
	    case 'p': func = PrivilegedOp; break;

	    case 'i': func = IllegalOp; break;

	    case 'b': func = BusError; break;

	    case 'a': func = AddrError; break;

	    case 't': func = TraceTrap; break;

	    case 'v': func = TrapV; break;

	    case 'z': func = DivideZero; break;

            case 'c': func = CheckInstruction; break;

	    case '\r': func = 0; break;

	    case 'k': func = PokeKernel; break;
	    
	    case 'x': func = abort; break;

	    case 'y': func = Trap; break;

	    case 'q': continue;

	    case '?':
		printf("p (priveleged op), i (illegal op), \
b (bus error), a (addr error),\n\
t (trace trap), z (zero divide)\n");
		func = 0;
		continue;

	    default: func = 0; printf( "\nUnknown exception\n" );
	  }
	putchar('\n');
	if( func == 0 ) continue;

	pid = Create( 3, func, 400 );

	if( func == TraceTrap )
	  {
	    ReadProcessState( pid, &pstate );
	    /* Turn on the trace bit */
	    /* Compiler doesn't seem to take the |= form here */
	    pstate.PSL = (Unspec) (0x00000010 | (long)pstate.PSL); 
	    WriteProcessState( pid, &pstate );
	  }

	  /*
	   * Flush any output, start the new process, and wait for it
	   */
	Flush( stdout );
	Ready( pid, 0 );

	ReceiveSpecific( msg, pid );
	Resynch( stdout );
      }
 }

PrivilegedOp()
  {
    asm( "halt" );
    printf( "Continue after stop\n" );
  }

AddrError()

  {
    asm( "	jmp 0xffffffff" );
    printf( "Continue after address error\n" );
  }


IllegalOp()
  {
    asm("	xfc");

    printf( "Continue after illegal op\n" );
  }


BusError()
  {
   unsigned *i, j;

   i = (unsigned *) 0xFFFFF0; /* Large address */
   j = *i; /* Bus error */

   printf( "Continued after bus error\n" );
  }


DivideZero()
  {
   unsigned i;

   i = i/0;

   printf( "Continued after divide by zero\n" );
  }


CheckInstruction()
  {
/*    asm( "clrl d0" );
    asm( "subql #1, d0 "); /* Make d0 negative the hard way */
/*    asm( "chk d1, d0" );

    printf( "Continued after check instruction\n" );
*/ printf("Doesn't do anything yet\n");

  }


TrapV()
  {
/*    asm( "orb #/02, cc" );	/* Turn on overflow bit */
/*    asm( "trapv" );

    printf( "Continued after overflow trap\n" );
*/ printf("Doesn't do anything yet\n");
  }

TraceTrap()
  {
loop:
    printf( "Trace trap continuing\n" );
    goto loop;
  }

PokeKernel()
  {
    int * i;

    i = (int *) 0x4000;
    *i = 1;
    printf( "Continued after kernel poke\n" );
  }

Trap()
  {
/*
    asm("	trap #0");
    printf("Continued after trap!\n");
*/ printf("Doesn't do anything yes\n");
  }
