/*
 *   Program to test exception server.
 *   Copyright 1982 (c) David R. Cheriton
 *
 * Fixed by Bill Nowicki and Tim Mann January 1983
 * 8/18/83 (TPM) Fixed some more.
 */

#include <Vio.h>
#include <Vprocess.h>

static  Processor_state pstate;
static  Message msg;

extern PrivilegedOp(), IllegalOp(), TraceTrap(), BusError(), AddrError(),
    PokeKernel(), DivideZero(), CheckInstruction(), TrapV(), abort();

main()
  {
    ProcessId pid;
    char c;
    int (*func)();
    SystemCode err;

    pid = GetPid(EXCEPTION_SERVER,LOCAL_PID);
    if ( pid == 0 ) 
      {
	if ( pid = InitExceptionServer() )
		printf( "Initalized exception server, pid 0x%x\n", pid);
	else printf("Error starting exception server\n");
      }
     else printf("Exception server is pid 0x%x\n", pid );
     c = ~ 'q';

     while( c != 'q' )
      {
	printf( "Pick an exception: " );
	Flush(stdout);
	c = (getchar() & 0x007F);
	switch( c )
	 {
	    case 'p': func = PrivilegedOp; break;

	    case 'i': func = IllegalOp; break;

	    case 'b': func = BusError; break;

	    case 'a': func = AddrError; break;

	    case 't': func = TraceTrap; break;

	    case 'v': func = TrapV; break;

	    case 'z': func = DivideZero; break;

            case 'c': func = CheckInstruction; break;

	    case '\r': func = 0; break;

	    case 'k': func = PokeKernel; break;
	    
	    case 'x': func = abort; break;

	    case 'q': continue;

	    default: func = 0; printf( "\nUnknown exception\n" );
	  }
	putchar('\n');
	if( func == 0 ) continue;

	pid = Create( 3, func, 400 );

	if( func == TraceTrap )
	  {
	    ReadProcessState( pid, &pstate );
	    pstate.sr |= 0x8000; /* Turn on the trace bit */
	    WriteProcessState( pid, &pstate );
	  }

	  /*
	   * Flush any output, start the new process, and wait for it
	   */
	Flush( stdout );
	Ready( pid, 0 );

	ReceiveSpecific( msg, pid );
	Resynch( stdout );
      }
 }

PrivilegedOp()
  {
    asm( "stop #/2000 " );
    printf( "Continue after stop\n" );
  }

AddrError()

  {
    asm( "jmp 9" );
    printf( "Continue after address error\n" );
  }


IllegalOp()
  {
    asm("	.word /FEDC");

    printf( "Continue after illegal op\n" );
  }


BusError()
  {
   unsigned *i, j;

   i = (unsigned *) 0xFFFFF0; /* Large address */
   j = *i; /* Bus error */

   printf( "Continued after bus error\n" );
  }


DivideZero()
  {
   unsigned i;

   i = i/0;

   printf( "Continued after divide by zero\n" );
  }


CheckInstruction()
  {
    asm( "clrl d0" );
    asm( "subql #1, d0 "); /* Make d0 negative the hard way */
    asm( "chk d1, d0" );

    printf( "Continued after check instruction\n" );

  }


TrapV()
  {
    asm( "orb #/02, cc" );	/* Turn on overflow bit */
    asm( "trapv" );

    printf( "Continued after overflow trap\n" );
  }

TraceTrap()
  {
loop:
    printf( "Trace trap continuing\n" );
    goto loop;
  }

PokeKernel()
  {
    int * i;

    i = (int *) 0x4000;
    *i = 1;
    printf( "Continued after kernel poke\n" );
  }
