/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * telnet/main.c - IP user telnet under Vkernel with stdin/stdout
 *
 * by Bill Nowicki
 *  January 1983
 *
 * March 1983 (WIN)
 *	- If ASSUME_SERVER is defined, we do not link in the network server
 * 5/83 Marvin Theimer
 *	- Internet server is now loaded rather than linked in.  This gets rid
 *	  of the ASSUME_SERVER business.
 * 6/83 Marvin Theimer
 *	- Changed format so that internet server is loaded via the team 
 *	  server.
 * 7/83 Marvin Theimer
 *	- Changed format so that internet server is loaded via the new 
 *	  ExecProg routine.
 * 9/83 TPM
 *	- Modified for new calling sequence to ExecProg.
 * 10/83 Marvin Theimer
 *	- Modified (again) for new calling sequence to ExecProg.
 *
 * HISTORY CONTINUED IN RCS LOG
 */

# include <Venviron.h>
# include <Vteams.h>

#define INTERNET_SERVER_FILE "internetserver"

#define TRUE  1
#define FALSE 0

extern ProcessId ExecProgram();
extern RootMessage *RootMsg;

main (argc, argv)
    int argc;
    char **argv;
  {
    char *argv1[2];
    SystemCode error;
    ProcessId pid;
    unsigned long myaddr, GetIpServerAddr();
    char *TerminalType();
    int i;
    char c;
    char *host = NULL;
    int debug = FALSE;
    int load = TRUE;
    int escapes = FALSE;
    int log = FALSE;

    for( argc--, argv++;  argc > 0;  argc--, argv++ )
      {
	if( (*argv)[0] == '-' )
	  {
	    for( i = 1;  (c = (*argv)[i]) != '\0';  ++i )
	      {
		switch( c )
		  {
		    case 'd':
			debug = TRUE;
			break;

		    case 'l':
			load = FALSE;
			break;

		    case 'g':
			log = TRUE;
			debug = TRUE;
			break;

		    case 'e':
			escapes = TRUE;
			break;

		    default:
			printf( "Usage: telnet [-d] [-g] [-l] [-e] [host]\n" );
			printf( "-d = debug\n");
			printf( "-g = log to telnet.logfile (implies -d)\n");
			printf( "-l = don't load internetserver\n");
			printf( "-e = enable <ctrl>^ escapes\n");
			exit();
		  }
	      }
	  }
	else
	  {
	    host = *argv;
	  }
      }

    if( (pid = GetPid( INTERNET_SERVER, LOCAL_PID )) == 0 )
      {
	/* no internet server running locally */
	if( load )
	  {
	    printf( "Loading internet server...\n" );
	    fflush( stdout );
	    argv1[0] = INTERNET_SERVER_FILE;
	    argv1[1] = NULL;
            if( (pid = ExecProgram(argv1, NULL, RootMsg, NULL, NULL, &error))
	    		 == 0 )
	      {
		printf( "Can't load a local internet server: %s%s",
	    	    ErrorString(error), ".\nLooking for a public one...\n" );
		fflush( stdout );
	      }
	  }

	if( !load || pid == 0 )
	  {
	    if( (pid = GetPid( INTERNET_SERVER, ANY_PID )) == 0 )
	      {
		printf( "Can't find a public internet server.\n" );
		exit();
	      }
	  }
      }

    /* In addition to its obvious function, the following procedure call
     * guarantees that a newly loaded internet server completes its
     * initialization before we proceed.
     */
    myaddr = GetIpServerAddr( pid );

    Telnet( stdin, stdout, myaddr, host, debug, log,  escapes, 
	TerminalType( stdout ) );
  }
