/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * addr.c - translate IP host names or address strings into IP addresses
 *
 * Marvin Theimer and Bill Nowicki October 1983
 */

#include <Vio.h>
#include <Vnet.h>
#include <ctype.h>

/*
 * GetHostIpAddrs:
 * Returns up to 'maxaddrs' IP addresses for the specified host name string.
 * Host string may be either a name or an address of the form a.b.c.d
 * In addition, either the name or address can be followed by a port
 * number of the form .p  (a, b, c, d, p are decimal integers).
 */

GetHostIpAddrs( out, host, myaddr, addrs, maxaddrs, port )
    File *out;
    char *host;
    unsigned long myaddr, addrs[];
    unsigned int maxaddrs;
    int *port;
  {
    int a, b, c, d, n;
    char *p, *rindex();

    if (isdigit(host[0]))
      {
        n = sscanf(host, "%d.%d.%d.%d.%d", &a, &b, &c, &d, port);
	if( n == 4 ) *port = 0;
	if( n >= 4 )
	  {
	    addrs[0] = (a << 24) | (b << 16) | (c << 8) | d;
	    return( 1 );
	  }
	else
	  {
	    fprintf( out, "Malformed address: %s\n", host );
	    return( 0 );
	  }
      }

    if( (p = rindex( host, '.' )) != NULL && sscanf( p+1, "%d", port ) == 1 )
	*p = '\0';	/* remove port number from tail of host name */
    else
	*port = 0;

    if( (n = NameToIpAddrs( host, myaddr, addrs, maxaddrs )) == 0 )
      {
	fprintf( out, "Unknown host name: %s\n", host );
      }
    return( n );
  }



/* GetIpServerAddr
 * Queries the identified process (presumed to be an internet server) to
 * obtain its IP address.  Returns an IP address of zero on error.
 */

unsigned long GetIpServerAddr( pid )
    ProcessId pid;
  {
    Message msg;
    NQueryFileRequest *request = (NQueryFileRequest *) msg;
    NQueryIpFileReply *reply   = (NQueryIpFileReply *) msg;

    request->requestcode = NQUERY_FILE;
    request->type = IPtype;
    request->nameindex = 0;
    request->namecontextid = 0;
    request->nameptr = "Ip";
    request->namelength = 2;

    Send( msg, pid );

    return( (reply->replycode == OK) ? reply->localIpAddr : 0 );
  }
