/* withsts.c: main program for a team1 with sts linked in - desirable to
 * save memory. *
 * Kenneth Brooks, 11/16/83
 *
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# include "Vgts.h"

extern stsmain();

main()
  {
    ProcessId stspid;

    InitFirstTeam();
    stspid = Create(10, stsmain, 2048);
    Ready(stspid, 0);
    ExecServer();
  }

/* material almost identical to .../servers/vgts/init.c */
extern ExecWatch();
extern ProcessId StsPid;	/* set in InitTs */
short Debug = 0;

/*
 * stsmain:
 * Main routine for the ts package.
 * This routine sets up the ts process and any applications
 * processes; in this case, ExecWatch.
 */

stsmain()
  {
    Message msg;
    ProcessId initpid;

    InitSts();

    /* ExecWatch plays a bit of the same role that the View Manager plays in
     * the VGTS world: it creates an initial exec and guarantees the existence
     * of at least one exec at all times: if it finds exec 0 dead, it will
     * create a new exec.
     */
    initpid = Create(10, ExecWatch, 512);
    Ready(initpid, 0);

    /*
     * The main server loop: wait for a message and take appropriate action,
     * forever.
     */
    while (1) GetMessage( 0, 0, msg );
 }


ProcessId execserver, myexecpid;
int myexec;

ExecWatch()
  {
    Message msg;
    SystemCode r;

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    if (execserver == 0) 
      {
	printf("No exec server!"); 
	exit();
      }

    while (1)
      {
	/* instance id's of 0 because ts supports only one instance */
	myexec = CreateExec(execserver, StsPid, 0, StsPid, 0, StsPid, 0,
			0, 0, 0, &myexecpid, &r);
	if (r != OK)
	  {
	    printf("Can't create exec: %s", ErrorString(r));
	    exit();
	  }
	ReceiveSpecific(msg, myexecpid);
      }
  }
