/* vgtsexec.c: Main program for the vgtsexec world.  Starts the standard
 * first team servers - exception, name, team - and the exec server.  Loads
 * and starts the vgts as a separate team.
 *
 * Kenneth Brooks, 11/16/83
 *
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vquerykernel.h>
#include <Vteams.h>

main()
  {
    InitFirstTeam();
    startVgts();
    ExecServer();
  }

char *progs[1];

startVgts()
  {
    PeripheralConfigurationReply preply;
    register i;

    QueryKernel(0, PERIPHERAL_CONFIG, &preply);
    for (i = 0; i < MAX_PERIPHERALS; ++i)
	switch (preply.peripheral[i])
	  {
	    case PRF_FRAMEBUFFER_SMI100:
		progs[0] = "sun100vgts";
		AutoStart(1, progs, REAL_TIME4);
		return;
		    
	    case PRF_FRAMEBUFFER_SUN3:
	    case PRF_FRAMEBUFFER_SMI120:
		progs[0] = "sun120vgts";
		AutoStart(1, progs, REAL_TIME4);
		return;

	    case PRF_FRAMEBUFFER_QVSS:
		progs[0] = "mvaxvgts";
		AutoStart(1, progs, REAL_TIME4);
		return;
	  }
    if (i == MAX_PERIPHERALS)
      {
	fprintf(stderr, "Couldn't find a framebuffer - loading \"sts\"\n");
	progs[0] = "sts";
	AutoStart(1, progs, REAL_TIME4);
      }
  }
