# include "td.h"
# include </usr/sun/include/rasterops.h>
/*
 * A reasonable interface to the RasterOp package
 * Bill Nowicki May 15, 1982
 */

extern int GXBase;



ReasonableCopy( xsrc, ysrc, h, w, xdst, ydst, funct)
    register short	h,w;	/* d7, d6 */
    short		xdst,xsrc,ydst,ysrc,funct;
{
#ifdef OLDTD
  struct fb_raster source, destination;
  
  source.x = xsrc;
  source.y = ysrc;
  source.height = h;
  source.width = w;
  destination.x = xdst;
  destination.y = ydst;
  GXfunction = funct;
  RasterCopy( &destination, &source);
#endif
}

ReasonableGet( x, y, h, w, buf, funct)
  short x, y, h, w, funct;
  short *buf;
{
#ifdef OLDTD
  struct fb_raster source;
  struct mem_raster destination;
  
  source.x = x;
  source.y = y;
  source.height = h;
  source.width = w;
  destination.start = buf;
  GXfunction = funct;
  RasterGet( &destination, &source);
#endif
}


ReasonablePut( x, y, h, w, buf, funct)
  short x, y, h, w, funct;
  short *buf;
{
#ifdef OLDTD
  struct mem_raster source;
  struct fb_raster destination;
  
  source.start = buf;
  destination.x = x;
  destination.y = y;
  destination.height = h;
  destination.width = w;
  GXfunction = funct;
  RasterPut( &destination, &source);
#endif
}

extern VRaster *WholeScreen;

ScreenSet()
{
RasterClear(WholeScreen);
}
ScreenClear()
{
RasterSet(WholeScreen);
}

rasterop1 (w, h, x, y)
    register short	x,y,h,w;
{
  VRaster temp;
  RestrictRaster(&temp + 1, WholeScreen, y, x, h, w);
  switch (GXfunction)
    {
      case NOT: RasterInvert(&temp + 1); break;
      case CLEAR: RasterSet(&temp + 1); break;
      case SET: RasterClear(&temp + 1); break;
    }
}

rotor() {};
mysins() {};
ncyl() {};
nkal() {};
burst() {};
frect() {}; 
