/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * convert usernames to teamserver pids and vice versa
 *
 *  5 Sep 85 (mjz): Initialized more of hostStatMsg, a-la whi.
 */

#include <Venviron.h>
#include <Vgroupids.h>
#include <Vteams.h>
#include <Vdirectory.h>


#define GETREPLY_TIMEOUT 100
#define MAXHOSTS 100



ProcessId finduser(username)
    char *username;
  /*
   * finduser attempts to locate the team server on a host given
   * the user name and/or the host name.
   */
  {
    struct hostStatMsg groupQuery;
    int i, count;
    ProcessId pid;
    ProcessId teamServers[MAXHOSTS];
    char remoteusername[2*MaxObjectNameLength+2];
    SystemCode getusername();

    /* collect pids of all team servers by looking for ALL hosts */
    count = 0;
    clear((char *) &groupQuery, sizeof(struct hostStatMsg));
    groupQuery.requestcode = HOST_STATUS;
    groupQuery.avail = 0;					/*mjz*/
    groupQuery.freeTeams = 0;					/*mjz*/
    groupQuery.freeProcs = 0;					/*mjz*/
    groupQuery.minFreeMem = 0;					/*mjz*/
    groupQuery.maxFreeMem = 0;					/*mjz*/
    groupQuery.minIdleTime = 0;					/*mjz*/
    groupQuery.maxIdleTime = 0;					/*mjz*/
    groupQuery.procMachType =	((MACH_TYPE_IRRELEVANT << MACH_TYPE_SHIFT)
				| (PROC_TYPE_IRRELEVANT << PROC_TYPE_SHIFT)
				| (PROC_FAMILY_IRRELEVANT));
    pid = Send(&groupQuery, VTEAM_SERVER_GROUP);
    while ((pid != 0) && (count < MAXHOSTS))
      {
	if (groupQuery.requestcode == OK)
	  {
	    teamServers[count] = pid;
	    ++count;
	  }
	pid = GetReply(&groupQuery, GETREPLY_TIMEOUT);
      }

    /* query each team server individually for host & user name */
    for (i=0; i < count; i++)
      {
/*	printf("querying pid %d.\n",i);  debug--mjz */
	pid = teamServers[i];
	if ((getusername(pid, remoteusername) == OK) &&
	    comparenames(username, remoteusername))
	  return(pid);
/*	printf("pid %d had user %s\n",i,remoteusername); debug -- mjz */
      }
    return(0);
  }



SystemCode getusername(pid, user)
    ProcessId pid;
    char *user;
  /*
   * getusername returns a user@host string given the process id of
   * the team server for a host.
   */
  {
    UpdateHostStatusRequest request;
    HostStatusRecord hostStatus;	/* in Vteams.h */

    request.requestcode = UpdateRequest;
    request.bufferptr = (char *) &hostStatus;
    request.bytecount = sizeof(hostStatus);
    request.requesttype = GetHostStatus;
    Send(&request, pid);
    sprintf(user, "%s@%s", hostStatus.userName, hostStatus.hostName);
    return(request.requestcode);
  }



comparenames(request, found)
    char *request, *found;
/*
 * comparenames determines if the requested name matches the found name.
 *   user matches user@anyhost
 *   @host matches anyuser@host
 *   user@host matches user@host
 */
  {
    if (*request == '@')
      while ((*found != '@') && *found)
	found++;
    for (; *request == *found; request++, found++)
      if (*request == '\0')
	return(1);
    return((*request == '\0') && (*found == '@'));
  }
