/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 *  8 Oct 85 (mjz): Changed TalkProgram structure to reflect new naming
 * talk types and messages
 * 28 Jan 85 (mjz): Added STACKSIZE parm, so you don't have to chase constants
 */

#include <Venviron.h>


#define MAXTALKERS 6	/* limited by MAXVIEWS in view.c */
#define MAXNAMELEN 66	/* user@host - 32 + @ + 32 + \0 */

#define STACKSIZE  1024	/* minimum size stack for helper processes */
			/*  depart, finish, getfilein, openlog, Sender */
			/*  and getinput. */

/*
 * talk message format
 */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	requestcode;
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	requestcode;
#endif LITTLE_ENDIAN
    ProcessId	teamserver;	/* to identify talker by name */
    ProcessId	talker;		/* who we send to */
    ProcessId	invitorteamserver; /* to name the invitor */
    char	text[16];	/* characters being sent */
  } TalkMessage;


/*
 * talk request codes
 */

#define JOIN_TALK	0x0001	/* I'm joining the conversation */
#define LEAVE_TALK	0x0002	/* I'm leaving the conversation */
#define RESERVE_SLOT	0x0003	/* I'm asking someone to join */
#define REMOTE_CHAR	0x0004	/* Here are characters from somebody else */
#define INPUT_CHAR	0x0005	/* Here's a character from the keyboard */
#define FILE_CHAR	0x0006	/* Here's a character from a file */
#define SEND_FAILED	0x0007	/* This talker isn't listening */
#define GIMME_CHAR	0x0008	/* I want to send to a remote talker */


/*
 * state of each talker
 */

typedef struct
  {
    ProcessId	pid;		/* who we send to */
    char	username[MAXNAMELEN]; /* talker's name */
    short	view;		/* where he is on the pad */
    short	status;		/* what he's doing */
    ProcessId	teamserver;	/* to identify talker by name */
    ProcessId	invitorteamserver; /* who asked him to join */
    char	buffer[16];	/* characters we want to send him */
    short	count;		/* number of characters waiting to send */
    ProcessId	sender;		/* process that's sending to him */
  } TalkState;


/*
 * status fields
 */

#define INACTIVE	0	/* nobody there */
#define RESERVED	1	/* invited but hasn't responded yet */
#define TALKING 	2	/* in the conversation */
#define WAITING		3	/* waiting for us to send to him */


/*
 * input modes
 */

#define TALK_MODE	0	/* send text to other talkers */
#define SELECT_COMMAND	1	/* entered escape, now select command */
#define COMMAND_MODE	2	/* entering parameter for command */


/*
 * commands that require parameters
 */

#define INVITE	0	/* invite another talker */
#define READ	1	/* insert file into conversation */
#define	WRITE	2	/* record conversation in file */
#define	QUIT	3	/* leave conversation */


/*
 * command input buffer
 */

typedef struct
  {
    short	count;
    char	buffer[80];
  } InputLine;


/*
 * program to load
 */

typedef struct
  {
#ifdef OLD_WAY
    ProcessId	contextserver;
    ProcessId	nameserver;
    ContextId	contextid;
#else
    ContextPair context;
    char	*contextname;
#endif OLD_WAY
    char	*name;
  } ProgramName;
