/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * 10 Oct 85 (mjz): Added capability to receive (and understand) messages
 *		from machines with different byte orders.
 *
 * main program
 */

#include <Vio.h>
#include "talk.h"
#ifdef DEBUG
#define Receive(msg)	debugReceive("talk", msg)
#define Reply(msg, pid)	debugReply("talk", msg, pid)
#endif DEBUG


/* Exports */
ProgramName TalkProgram;
File *padout, *padin;
File *readingFile;
ProcessId FileReadProcess;
TalkState Talker[MAXTALKERS];
short TopView;
InputLine Input;
int InputMode;
int Command;


main(argc, argv)
    int argc;
    char *argv[];
  /*
   * after initialization, loop repeatedly handling events from
   * local and remote helper processes
   */
  {
    TalkMessage msg;
    ProcessId pid;

    Initialize(argc, argv);
    for (;;)
      {
#ifdef DEBUG
	debugDump("talk");
#endif DEBUG
	pid = Receive(&msg);
	/*
	 * If the sender was of a different byte order the Kernel swapped the
	 * bytes in the message so that longwords came out looking right.
	 * Unfortunately, the last part of the message is interpreted by
	 * us as a character array, which we do not want to have byte
	 * swapped at all.  The solution: Re-swap the last part of the
	 * message as if it were longwords so everything will be back
	 * to normal.
	 */
	if (DifferentByteOrder(pid))
	  ByteSwapLongInPlace(msg.text, sizeof(msg.text));
	switch (msg.requestcode)
	  {
	    case JOIN_TALK:
	      msg.requestcode = JoinTalk(&msg);
	      break;

	    case LEAVE_TALK:
	      msg.requestcode = LeaveTalk(&msg);
	      break;

	    case RESERVE_SLOT:
	      msg.requestcode = ReserveSlot(&msg);
	      break;

	    case REMOTE_CHAR:
	      msg.requestcode = RemoteChar(&msg);
	      break;

	    case INPUT_CHAR:
	      msg.requestcode = InputChar(&msg);
	      break;

	    case FILE_CHAR:
	      msg.requestcode = FileChar(&msg);
	      break;

	    case SEND_FAILED:
	      msg.requestcode = SendFailed(&msg);
	      break;

	    case GIMME_CHAR:
	      msg.requestcode = GimmeChar(&msg);
	      break;

	    default:
	      msg.requestcode = NO_REPLY;
	  }
	if (msg.requestcode != NO_REPLY)
	  {
	    /* must re-swap "text" portion so it looks right to receiver */
	    if (DifferentByteOrder(pid))
	      ByteSwapLongInPlace(msg.text, sizeof(msg.text));
	    Reply(&msg, pid);
	  }
      }
  }
