/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 *  8 Oct 85(mjz): Altered to reflect new naming protocol (vs OLD_WAY)
 *
 * initialization
 */

#include <Vio.h>
#include <Vgts.h>
#include <Vnaming.h>
#include <Vtermagent.h>
#include "talk.h"

#ifdef DEBUG
#define Receive(msg)	debugReceive("init", msg)
#define Reply(msg, pid)	debugReply("init", msg, pid)
#define ReceiveSpecific(msg, pid) debugReceiveSpecific("init", msg, pid)
#endif DEBUG


/* Imports */
#ifdef OLD_WAY
extern ProcessId NameServerPid;	/* really context prefix server */
#endif OLD_WAY
extern ProgramName TalkProgram;
extern File *padout, *padin;
extern TalkState Talker[MAXTALKERS];
extern short TopView;
extern InputLine Input;
extern int InputMode;
extern char *malloc();		/* live free or die! */


Initialize(argc, argv)
    int argc;
    char *argv[];
  /*
   * initialize everything
   */
  {
    int i, slot;
    ProcessId pid;
    int getinput();

    if (argc > 2)
      {
	fprintf(stderr, "Usage: %s user@host\n", argv[0]);
	exit(1);
      }

    /* save current context for later invitations */
    TalkProgram.name = argv[0];
#ifdef OLD_WAY
    TalkProgram.contextserver = NameServerPid;
    TalkProgram.nameserver = PerProcess->nameserver;
    TalkProgram.contextid = PerProcess->contextid;
#else
    TalkProgram.context = PerProcess->ctx;
    TalkProgram.contextname = malloc(1+strlen(PerProcess->ctxname));
    strcpy(TalkProgram.contextname,PerProcess->ctxname);  /* get name */
    /* 
     * I got a new place to get the string name, and then copied it over
     * because the context pair can become invalid at any time and so
     * may need to be created by the string name, and likewise the 
     * string may have been trashed (since it was given to us, it can
     * probably be taken away (i.e. when redefining the current context!)
     * should check this out with Tim).  Soo, the only safe thing to do
     * is to save the information rather than a pointer to the information.
     * --mjz
     */
#endif OLD_WAY

    /* initialize Talker table */
    for (i=0; i<MAXTALKERS; i++)
      {
	Talker[i].view = -1;
	Talker[i].status = INACTIVE;
      }
    Talker[0].pid = GetPid(ACTIVE_PROCESS, LOCAL_PID);
    Talker[0].status = RESERVED;
    Talker[0].teamserver = GetPid(TEAM_SERVER, LOCAL_PID);
    getusername(Talker[0].teamserver, Talker[0].username);
    if ((argc == 2) && (strcmp(argv[1], "-i") == 0))
      {
	remotesetup();
	argc--;
      }
    else
      localsetup();

    /* set up view, create helper process to read keyboard */
    InputMode = TALK_MODE;
    TopView = viewInit(padout);
    Talker[0].status = TALKING;
    Talker[0].view = viewAdd(Talker[0].username);
    viewPuts(TopView, "\nUse <ESC> plus a single character to enter commands.");
    if (argc == 2)
      Invite(argv[1]);
    pid = Create(3, getinput, STACKSIZE);
    Ready(pid, 0);
  }


localsetup()
  /*
   * only need to create pad for first talker
   */
  {
    SystemCode error;
    File *OpenPad();

    padout = OpenPad("talk", PadHeight, PadWidth, &error);
    if (error == OK)
      padin = OpenFile(FileServer(padout), FileId(padout), FREAD, &error);
    if (error != OK)
      {
	fprintf(stderr, "%s: couldn't open talk pad\n", TalkProgram.name);
	exit(1);
      }
    SelectPad(padin);
  }


remotesetup()
  /*
   * invitation from somebody else - need to ensure there's space
   * in conversation
   */
  {
    ProcessId pid;
    TalkMessage msg;
    File *VGTS;
    File *OpenPad();

    pid = Receive(&msg);
    if (msg.requestcode != RESERVE_SLOT)
      {
	fprintf(stderr, "%s: didn't get correct startup message\n",
							TalkProgram.name);
	exit(1);
      }
    msg.requestcode = OK;
    Reply(&msg, pid);

    /* wait until everyone ok's invitation */
    ReceiveSpecific(&msg, pid);
    if (msg.requestcode != JOIN_TALK)
      exit(1);

    /* tell invitee what's happening */
    getusername(msg.invitorteamserver, Talker[1].username);
    VGTS = OpenFile(GetPid(VGT_SERVER, LOCAL_PID), 0, FAPPEND,
						    &msg.requestcode);
    if (msg.requestcode != OK)
      {
	Reply(&msg, pid);
	exit(1);
      }
    ModifyPad(VGTS, LF_Output);
    fputs("\007\033[1mYou have an invitation to talk from:\n", VGTS);
    fputs(Talker[1].username, VGTS);
    putc('\n', VGTS);
    fputs("Accept: create pad; reject: click 3 mouse buttons\033[m\n", VGTS);
    fflush(VGTS);
    padout = OpenPad("talk", PadHeight, PadWidth, &msg.requestcode);
    if (msg.requestcode != OK)
      {
	Reply(&msg, pid);
	exit(1);
      }
    padin = OpenFile(FileServer(padout), FileId(padout), FREAD,
						    &msg.requestcode);
    Reply(&msg, pid);
    if (msg.requestcode != OK)
      exit(1);
    fputs("\007\033[1mPlease select talk pad for input\033[m\n", VGTS);
    Close(VGTS);

#ifdef OLD_WAY
    /* change to this user's [home] context for file reads/writes */
    NameServerPid = GetPid(CONTEXT_SERVER, LOCAL_PID);
#endif OLD_WAY
    ChangeDirectory("[home]");
  }
