/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * routines to handle messages sent to main talk process
 */

#include <Vio.h>
#include "talk.h"


/* Imports */
extern TalkState Talker[MAXTALKERS];
extern int InputMode;



SystemCode SendFailed(msg)
    TalkMessage *msg;
  /*
   * handle SEND_FAILED - remote talker isn't listening
   */
  {
    int i, slot;
    char banner[MAXNAMELEN+30];

    /* find slot */
    for (slot=0; slot<MAXTALKERS; slot++)
      if (Talker[slot].pid == msg->talker)
	break;
    if (slot == MAXTALKERS)
      return(NOT_FOUND);
    if (Talker[slot].status >= TALKING)
      {
	/* notify our user, destroy sender process */
	sprintf(banner, "%s has disappeared.", Talker[slot].username);
	viewBanner(banner);
	Talker[slot].status = INACTIVE;
	if (Talker[slot].view != -1)
	  {
	    viewDel(Talker[slot].view);
	    for (i=0; i<MAXTALKERS; i++)
	      if (Talker[i].view > Talker[slot].view)
		Talker[i].view--;
	    Talker[slot].view = -1;
	  }
	if (ValidPid(Talker[slot].sender))
	  Destroy(Talker[slot].sender);
      }
  }



SystemCode FileChar(msg)
    TalkMessage *msg;
  /*
   * handle FILE_CHAR - character from a file we're reading
   */
  {
    ProcessId pid;

    /* simply send it on to everybody */
    return(Notify(msg->text[0]));
  }



SystemCode GimmeChar(msg)
    TalkMessage *msg;
  /*
   * handle GIMME_CHAR - sender process wants characters to send to
   *	remote talker
   */
  {
    int slot;

    /* find slot */
    for (slot=1; slot<MAXTALKERS; slot++)
      if ((Talker[slot].pid == msg->talker) && (Talker[slot].status >= TALKING))
	break;
    if (slot == MAXTALKERS)
      return(NOT_FOUND);
    if (Talker[slot].count)
      {
	/* we've got stuff waiting - give it to him */
	Talker[slot].buffer[Talker[slot].count] = '\0';
	Talker[slot].count = 0;
	Talker[slot].status = TALKING;
	strcpy(msg->text, Talker[slot].buffer);
	return(OK);
      }
    else
      {
	/* nothing waiting - remember he's awaiting a reply */
	Talker[slot].status = WAITING;
	return(NO_REPLY);
      }
  }



SystemCode InputChar(msg)
    TalkMessage *msg;
  /*
   * handle INPUT_CHAR - character from user's keyboard
   */
  {
    SystemCode reply;
    SystemCode TalkMode(), SelectCommand(), CommandMode();

    switch (InputMode)
      {
	case TALK_MODE:
	  reply = TalkMode(msg->text[0]);
	  break;

	case SELECT_COMMAND:
	  reply = SelectCommand(msg->text[0]);
	  break;

	case COMMAND_MODE:
	  reply = CommandMode(msg->text[0]);
	  break;
      }
    return(reply);
  }




SystemCode JoinTalk(msg)
    TalkMessage *msg;
  /*
   * handle JOIN_TALK - talk has joined conversation
   */
  {
    int i, slot;
    char banner[MAXNAMELEN+30];
    int Sender();

    /* find slot - use previous slot if reserved, else allocate new slot */
    slot = -1;
    for (i=0; i<MAXTALKERS; i++)
      if (Talker[i].pid == msg->talker)
	{
	  slot = i;
	  break;
	}
      else if (Talker[i].status == INACTIVE)
	slot = i;
    if (slot == -1)
      return(NO_SERVER_RESOURCES);

    /* set up TalkState and create helper process to send to remote talker */
    getusername(msg->teamserver, Talker[slot].username);
    if (Talker[slot].status == RESERVED)
      sprintf(banner, "%s has accepted the invitation.", Talker[slot].username);
    else
      sprintf(banner, "%s is in the conversation.", Talker[slot].username);
    viewBanner(banner);
    Talker[slot].pid = msg->talker;
    Talker[slot].teamserver = msg->teamserver;
    Talker[slot].status = TALKING;
    if (Talker[slot].view == -1)
      Talker[slot].view = viewAdd(Talker[slot].username);
    if (ValidPid(Talker[slot].sender))
      Destroy(Talker[slot].sender);
    Talker[slot].count = 0;
    Talker[slot].sender = Create(3, Sender, STACKSIZE);
    Ready(Talker[slot].sender, 1, Talker[slot].pid);
    return(OK);
  }



SystemCode LeaveTalk(msg)
    TalkMessage *msg;
  /*
   * handle LEAVE_TALK - talker is leaving conversation
   */
  {
    int i, slot;
    char banner[MAXNAMELEN+30];

    /* find slot */
    for (slot=0; slot<MAXTALKERS; slot++)
      if (Talker[slot].pid == msg->talker)
	break;
    if (slot == MAXTALKERS)
      return(NOT_FOUND);
    if (Talker[slot].status == INACTIVE)
      return(ILLEGAL_REQUEST);

    /* release resources - helper process, view, TalkState slot */
    if (Talker[slot].status == RESERVED)
      sprintf(banner, "%s has declined the invitation.", Talker[slot].username);
    else
      sprintf(banner, "%s has left the conversation.", Talker[slot].username);
    viewBanner(banner);
    if (ValidPid(Talker[slot].sender))
      Destroy(Talker[slot].sender);
    if (Talker[slot].view != -1)
      {
	viewDel(Talker[slot].view);
	for (i=0; i<MAXTALKERS; i++)
	  if (Talker[i].view > Talker[slot].view)
	    Talker[i].view--;
	Talker[slot].view = -1;
      }
    Talker[slot].status = INACTIVE;
    return(OK);
  }


SystemCode RemoteChar(msg)
    TalkMessage *msg;
  /*
   * handle REMOTE_CHAR - characters from remote talker
   */
  {
    int i, slot;
    char banner[MAXNAMELEN+30];
    int Sender();

    /* find slot */
    slot = -1;
    for (i=0; i<MAXTALKERS; i++)
      if (Talker[i].pid == msg->talker)
	{
	  slot = i;
	  break;
	}
      else if (Talker[i].status == INACTIVE)
	slot = i;
    if (slot == -1)
      return(NO_SERVER_RESOURCES);
    if (Talker[slot].status < TALKING)
      {
	/* magically appeared - simulate JOIN_TALK */
	getusername(msg->teamserver, Talker[slot].username);
	Talker[slot].pid = msg->talker;
	Talker[slot].teamserver = msg->teamserver;
	Talker[slot].status = TALKING;
	if (Talker[slot].view == -1)
	  Talker[slot].view = viewAdd(Talker[slot].username);
	sprintf(banner, "%s has mysteriously joined the conversation.",
							Talker[slot].username);
	viewBanner(banner);
	if (ValidPid(Talker[slot].sender))
	  Destroy(Talker[slot].sender);
	Talker[slot].count = 0;
	Talker[slot].sender = Create(3, Sender, STACKSIZE);
	Ready(Talker[slot].sender, 1, Talker[slot].pid);
      }

    /* send characters to pad */
    viewPuts(Talker[slot].view, msg->text);
    return(OK);
  }



SystemCode ReserveSlot(msg)
    TalkMessage *msg;
  /*
   * handle RESERVE_SLOT - someone is making an invitation
   */
  {
    int i, slot;
    char banner[MAXNAMELEN+30];

    /* find slot */
    slot = -1;
    for (i=0; i<MAXTALKERS; i++)
      if (Talker[i].status == INACTIVE)
	slot = i;
      else if (Talker[i].pid == msg->talker)
	return(ILLEGAL_REQUEST);
    if (slot == -1)
      return(NO_SERVER_RESOURCES);

    /* reserve slot */
    Talker[slot].pid = msg->talker;
    Talker[slot].teamserver = msg->teamserver;
    Talker[slot].invitorteamserver = msg->invitorteamserver;
    Talker[slot].status = RESERVED;
    getusername(msg->teamserver, Talker[slot].username);
    getusername(msg->invitorteamserver, banner);
    sprintf(banner, "%s has invited %s.", banner, Talker[slot].username);
    viewBanner(banner);
    return(OK);
  }
