/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * 10 Oct 85 (mjz): Added ability to display messages to/from machines of
 *		different byte order.
 *
 * debugging routines
 */

#include <Vio.h>
#include "talk.h"

#ifdef DEBUG

/* Imports */
extern TalkState Talker[MAXTALKERS];


int debug = 1;


ProcessId debugSend(who, msg, pid)
    char *who;
    TalkMessage *msg;
    ProcessId pid;
  /*
   * report a Send
   */
  {
    ProcessId mypid = GetPid(ACTIVE_PROCESS, LOCAL_PID);

    if (debug)
      {
	fprintf(stderr, "%s (%lx): sending to %lx\n", who, mypid, pid);
	debugDisplay(msg,pid);
      }
    pid = Send(msg, pid);
    if (debug)
      {
	fprintf(stderr, "%s (%lx): reply from %lx\n", who, mypid, pid);
	debugDisplay(msg,pid);
      }
    return(pid);
  }


ProcessId debugReceiveSpecific(who, msg, pid)
    char *who;
    TalkMessage *msg;
    ProcessId pid;
  /*
   * report a ReceiveSpecific
   */
  {
    ProcessId mypid = GetPid(ACTIVE_PROCESS, LOCAL_PID);

    pid = ReceiveSpecific(msg, pid);
    if (debug)
      {
	fprintf(stderr, "%s (%lx): received specific from %lx\n", who, mypid,
									pid);
	debugDisplay(msg,pid);
      }
    return(pid);
  }


ProcessId debugReceive(who, msg)
    char *who;
    TalkMessage *msg;
  /*
   * report a Receive
   */
  {
    ProcessId pid;
    ProcessId mypid = GetPid(ACTIVE_PROCESS, LOCAL_PID);

    pid = Receive(msg);
    if (debug)
      {
	fprintf(stderr, "%s (%lx): received from %lx\n", who, mypid, pid);
	debugDisplay(msg,pid);
      }
    return(pid);
  }


ProcessId debugReply(who, msg, pid)
    char *who;
    TalkMessage *msg;
    ProcessId pid;
  /*
   * report a Reply
   */
  {
    ProcessId mypid = GetPid(ACTIVE_PROCESS, LOCAL_PID);

    if (debug)
      {
	fprintf(stderr, "%s (%lx): reply to %lx\n", who, mypid, pid);
	debugDisplay(msg,pid);
      }
   return(Reply(msg, pid));
  }


debugDisplay(message,pid)
    TalkMessage *message;
    ProcessId pid;		/* so we can tell byte order of other machine*/
  /*
   * print contents of a talk message
   */
  {
    switch (message->requestcode)
      {
	case OK:
	  fprintf(stderr, "  OK          ");
	  break;

	case JOIN_TALK:
	  fprintf(stderr, "  JOIN_TALK   ");
	  break;

	case LEAVE_TALK:
	  fprintf(stderr, "  LEAVE_TALK  ");
	  break;

	case RESERVE_SLOT:
	  fprintf(stderr, "  RESERVE_SLOT");
	  break;

	case REMOTE_CHAR:
	  fprintf(stderr, "  REMOTE_CHAR ");
	  break;

	case INPUT_CHAR:
	  fprintf(stderr, "  INPUT_CHAR  ");
	  break;

	case SEND_FAILED:
	  fprintf(stderr, "  SEND_FAILED ");
	  break;

	default:
	  fprintf(stderr, "  0x%4x ", message->requestcode);
	  break;
      }
    fprintf(stderr, "  text[0]='%c'", 
		DifferentByteOrder(pid) ? message->text[1] : message->text[0]);
    fprintf(stderr, "  teamserver=0x%lx", message->teamserver);
    fprintf(stderr, "  talker=0x%lx", message->talker);
    putc('\n', stderr);
    fflush(stderr);
  }


debugDump(s)
    char *s;
  /*
   * report TalkState
   */
  {
    int i;

    fprintf(stderr, "%s (%lx): Talker table\n", s,
					GetPid(ACTIVE_PROCESS, LOCAL_PID));
    for (i=0; i<MAXTALKERS; i++)
      {
	fprintf(stderr, "  %d  ", i);
	switch (Talker[i].status)
	  {
	    case INACTIVE:
	      fprintf(stderr, "INACTIVE  ");
	      break;

	    case RESERVED:
	      fprintf(stderr, "RESERVED  ");
	      break;

	    case TALKING:
	      fprintf(stderr, "TALKING   ");
	      break;

	    case WAITING:
	      fprintf(stderr, "WAITING	 ");
	      break;

	    default:
	      fprintf(stderr, "%4d      ", Talker[i].status);
	      break;
	  }
	fprintf(stderr, "pid=0x%lx  ", Talker[i].pid);
	fprintf(stderr, "teamserver=0x%lx  ", Talker[i].teamserver);
	fprintf(stderr, "view=%d\n", Talker[i].view);
      }
    fflush(stderr);
  }
#endif DEBUG
