/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * 8 Oct 85 (mjz): Converted to new naming protocol (look at OLD_WAY sections)
 *
 * process commands from keyboard
 */

#include <Vio.h>
#include <Vteams.h>
#include "talk.h"


/* Imports */
#ifdef OLD_WAY
extern ProcessId NameServerPid;
#endif OLD_WAY
extern TalkState Talker[MAXTALKERS];
extern int InputMode;
extern int Command;
extern InputLine Input;
extern short TopView;
extern ProgramName TalkProgram;
extern File *viewFile1, *viewFile2;
extern File *readingFile;
extern ProcessId FileReadProcess;


SystemCode TalkMode(c)
    char c;
  /*
   * process InputMode = TALK_MODE
   * user is entering text to be sent to other talkers
   */
  {
    SystemCode reply;

    switch (c)
      {
	case '\003':
	  /* ^C - abort talk */
	  viewPuts(TopView, "\nQuit: are you sure?");
	  Input.count = 0;
	  InputMode = COMMAND_MODE;
	  Command = QUIT;
	  reply = OK;
	  break;

	case '\033':
	  /* ^[ - enter command */
	  viewPuts(TopView,
      "\nCommand: I)nvite user, L)og in pad, Q)uit, R)ead file, W)rite file?");
	  InputMode = SELECT_COMMAND;
	  reply = OK;
	  break;

	default:
	  /* none of the above - send to everyone else */
	  reply = Notify(c);
	  break;
      }
    return(reply);
  }


SystemCode SelectCommand(c)
    char c;
  /*
   * process InputMode = SELECT_COMMAND
   * user entered ESC, now must select command character
   */
  {
    switch(c)
      {
	case 'I':
	case 'i':
	  /* Invite */
	  viewPuts(TopView, "\nInvite: whom?");
	  InputMode = COMMAND_MODE;
	  Command = INVITE;
	  Input.count = 0;
	  break;

	case 'L':
	case 'l':
	  /* Log */
	  Log();
	  InputMode = TALK_MODE;
	  break;

	case 'Q':
	case 'q':
	  /* Quit */
	  viewPuts(TopView, "\nQuitting.");
	  Quit("yes");
	  InputMode = TALK_MODE;
	  break;

	case 'R':
	case 'r':
	  /* Read */
	  if (ValidPid(FileReadProcess))
	    {
	      /* currently reading - so stop reading */
	      ReadFile("");
	      InputMode = TALK_MODE;
	    }
	  else
	    {
	      viewPuts(TopView, "\nRead: what file?");
	      InputMode = COMMAND_MODE;
	      Command = READ;
	      Input.count = 0;
	    }
	  break;

	case 'W':
	case 'w':
	  /* Write */
	  if (viewFile1)
	    {
	      /* currently writing - so stop writing */
	      WriteFile("");
	      InputMode = TALK_MODE;
	    }
	  else
	    {
	      viewPuts(TopView, "\nWrite: what file?");
	      InputMode = COMMAND_MODE;
	      Command = WRITE;
	      Input.count = 0;
	    }
	  break;

	default:
	  /* Say what? */
	  viewPutc(TopView, '\n');
	  viewPutc(TopView, c);
	  viewPuts(TopView, ": unknown command");
	  InputMode = TALK_MODE;
	  break;
      }
    return(OK);
  }


SystemCode CommandMode(c)
    char c;
  /*
   * process InputMode = COMMAND_MODE
   * user selected a command, now must enter parameter for it
   */
  {
    switch (c)
      {
	case '\003':
	  /* ^C - give up */
abort:	  viewPuts(TopView, "\nCommand aborted!");
	  InputMode = TALK_MODE;
	  break;

	case '\b':
	case '\177':
	  /* ^H or ^? - erase character */
	  if (Input.count > 0)
	    {
	      Input.count--;
	      viewPutc(TopView, '\b');
	    }
	  break;

	case '\025':
	  /* ^U - erase line */
	  while (Input.count > 0)
	    {
	      Input.count--;
	      viewPutc(TopView, '\b');
	    }
	  break;

	case '\n':
	  /* newline - process command */
	  if (Input.count == 0)
	    goto abort;
	  Input.buffer[Input.count] = '\0';
	  switch (Command)
	    {
	      case INVITE:
		Invite(Input.buffer);
		break;

	      case QUIT:
		Quit(Input.buffer);
		break;

	      case READ:
		ReadFile(Input.buffer);
		break;

	      case WRITE:
		WriteFile(Input.buffer);
		break;
	    }
	  InputMode = TALK_MODE;
	  break;

	default:
	  /* none of the above - put it in the buffer */
	  if ((Input.count < sizeof(Input.buffer)) && (c >= ' '))
	    {
	      viewPutc(TopView, c);
	      Input.buffer[Input.count++] = c;
	    }
	  break;
      }
    viewFlush();
    return(OK);
  }


Quit(s)
    char *s;
  /*
   * Quit command - leave talk
   */
  {
    ProcessId pid;
    int depart();

    if (*s == 'y')
      {
	/* call helper process to send LEAVE_TALK requests */
	pid = Create(3, depart, STACKSIZE);
	Ready(pid, 0);
      }
  }


Invite(s)
    char *s;
  /*
   * Invite command - ask another user to join
   */
  {
    SystemCode error;
    SelectionRec hostSpec;
    ProcessId teamserver, pid;
    int i;
    char *argv[3];
    int Finish();
    char banner[MAXNAMELEN+20];
#ifdef OLD_WAY
    ContextId currentcontext;
    ProcessId currentnameserver;
    ProcessId currentcontextserver;
#else
    ContextPair currentcontext;
    char *currentcontextname;
#endif OLD_WAY

    /* locate user */
    if ((teamserver = finduser(s)) == 0)
      {
	viewPuts(TopView, "\nCan't find ");
	viewPuts(TopView, s);
	viewPutc('!');
	return;
      }

    /* is there an empty slot? */
    for (i=1; i<MAXTALKERS; i++)
      if (Talker[i].status == INACTIVE)
	break;
    if (i == MAXTALKERS)
      {
	viewPuts(TopView, "\nToo many talkers!");
	return;
      }

    /* restore initial context to load talk on remote user's workstation */
#ifdef OLD_WAY
    currentcontext = PerProcess->contextid;
    currentnameserver = PerProcess->nameserver;
    currentcontextserver = NameServerPid;
    PerProcess->contextid = TalkProgram.contextid;
    PerProcess->nameserver = TalkProgram.nameserver;
    NameServerPid = TalkProgram.contextserver;
#else
    currentcontext = PerProcess->ctx;
    currentcontextname = PerProcess->ctxname;
    /* i will leave environment things... (mainly because I don't think
	they can be saved.. */
    PerProcess->ctx = TalkProgram.context;
    PerProcess->ctxname = TalkProgram.contextname;
#endif OLD_WAY

    /* set up arguments and load program */
    argv[0] = TalkProgram.name;
    argv[1] = "-i";
    argv[2] = (char *) NULL;
    hostSpec.teamServerPid = teamserver;
    Talker[i].pid = ExecProgram(argv, &hostSpec, (RootMessage *) NULL,
			(char *) NULL, (int *) NULL, &error);

    /* switch contexts again */
#ifdef OLD_WAY
    PerProcess->contextid = currentcontext;
    PerProcess->nameserver = currentnameserver;
    NameServerPid = currentcontextserver;
#else
    PerProcess->ctx = currentcontext;
    PerProcess->ctxname = currentcontextname;
#endif

    /* did load work? */
    if (Talker[i].pid == 0)
      {
	viewPuts(TopView, "\nInvitation failed!");
	return;
      }

    /* call helper to finish invitation */
    Talker[i].status = RESERVED;
    Talker[i].teamserver = teamserver;
    Talker[i].invitorteamserver = Talker[0].teamserver;
    getusername(teamserver, Talker[i].username);
    sprintf(banner, "Inviting %s.", Talker[i].username);
    viewBanner(banner);
    pid = Create(3, Finish, STACKSIZE);
    Ready(pid, 1, i);
  }


ReadFile(s)
    char *s;
  /*
   * Read command - insert file contents into conversation
   */
  {
    SystemCode error;
    int getfilein();

    if (ValidPid(FileReadProcess))
      {
	/* already reading - abort it */
	Destroy(FileReadProcess);
	viewPuts(TopView, "\nReading aborted!");
	Close(readingFile);
      }
    else
      {
	readingFile = Open(s, FREAD, &error);
	if (error != OK)
	  readingFile = (File *) 0;
	if (readingFile)
	  {
	    /* create helper to read file */
	    FileReadProcess = Create(3, getfilein, STACKSIZE);
	    Ready(FileReadProcess, 0);
	    viewPuts(TopView, "\nReading file.");
	  }
	else
	  viewPuts(TopView, "\nCouldn't read file!");
      }
  }


WriteFile(s)
    char *s;
  /*
   * Write command - record conversation in file
   */
  {
    SystemCode error;

    if (viewFile1)
      {
	/* already writing - terminate it */
	viewPuts(TopView, "\nWriting turned off.");
	Close(viewFile1);
	viewFile1 = (File *) 0;
      }
    else
      {
	viewFile1 = Open(s, FAPPEND, &error);
	if (error != OK)
	  viewFile1 = Open(s, FCREATE, &error);
	if (error != OK)
	  viewFile1 = (File *) 0;
	if (viewFile1)
	  viewPuts(TopView, "\nWriting turned on.");
	else
	  viewPuts(TopView, "\nCouldn't write file!");
      }
  }


Log()
  /*
   * Log command - record conversation in separate pad
   */
  {
    ProcessId pid;
    int openlog();

    if (viewFile2)
      {
	/* already logging - terminate it */
	viewPuts(TopView, "\nLogging turned off.");
	Close(viewFile2);
	viewFile2 = (File *) 0;
      }
    else
      {
	/* create helper process to open pad */
	pid = Create(3, openlog, STACKSIZE);
	Ready(pid, 0);
      }
  }
