/*
 * stuffboot.c
 * Tim Mann, 8-24-84
 *
 * Stuffs the file named in argument 2 into the boot block of
 *  the disk named as argument 1.  The "boot block" is a 8192 byte
 *  area, beginning at logical block #1 of the device, reserved for
 *  bootstrap loaders.  This program requires (and checks) that the 
 *  logical block size is 1024.  Don't let the fact that the disk 
 *  is formatted with 512 byte sectors, or the fact that the 8192 byte
 *  area the bootstrap goes in is called the "boot block" confuse you.
 *  Blocks are definitely 1024 bytes long!  (I think.)
 *
 * If a third argument is present, it is taken as the name of a file
 *  to copy into block #0 of the device (the disk label).  Labels are
 *  only 512 bytes long, but we write the whole 1024 byte block.
 */

#include <Vio.h>

#define LOGICAL_BLOCK_SIZE	1024
#define BOOT_BLOCK_SIZE		8192

main(argc, argv)
    int argc;
    char **argv;
  {
    File *diskf, *bootf, *labelf;
    int i, cnt;
    char buffer[LOGICAL_BLOCK_SIZE];
    SystemCode error;

    if (argc < 3 || argc > 4)
      {
	fprintf(stderr, "Usage: %s disk-name bootstrap-name [label-name]\n",
	    argv[0]);
	exit(1);
      }

    diskf = Open(argv[1], FMODIFY+FBLOCK_MODE, &error);
    if (error != OK)
      {
	fprintf(stderr, "%s: error opening %s: %s\n",
	    argv[0], argv[1], ErrorString(error));
	exit(error);
      }

    if (diskf->blocksize != LOGICAL_BLOCK_SIZE)
      {
	fprintf(stderr, "%s: Block size of %s = %d, expected %d\n",
	    argv[0], argv[1], diskf->blocksize, LOGICAL_BLOCK_SIZE);
	exit(1);
      }

    bootf = Open(argv[2], FREAD, &error );
    if( error != OK )
      {
	fprintf(stderr, "%s: error opening %s: %s\n",
	    argv[0], argv[2], ErrorString(error));
	exit(error);
      }

    if (argc == 4)
      {
	labelf = Open(argv[3], FREAD, &error);
	if (error != OK)
          {
	    fprintf(stderr, "%s: error opening %s: %s\n",
	        argv[0], argv[1], ErrorString(error));
	    exit(error);
          }
      }
    else
	labelf = NULL;

    for (i=1; i<1+(BOOT_BLOCK_SIZE/LOGICAL_BLOCK_SIZE); i++)
      {
	if ( (cnt = fread(buffer, 1, LOGICAL_BLOCK_SIZE, bootf)) != 
		LOGICAL_BLOCK_SIZE && 
		Eof(bootf) != END_OF_FILE )
	  {
	    fprintf(stderr, "%s: error reading %s: %s, %d bytes read\n",
	    	argv[0], argv[2], ErrorString(Eof(bootf)), cnt);
	    exit(Eof(bootf));
	  }
	diskf->block = i;
	if (Write(diskf, buffer, LOGICAL_BLOCK_SIZE) != 
		LOGICAL_BLOCK_SIZE || diskf->lastexception != OK)
	  {
	    fprintf(stderr, "%s: error writing to disk: %s\n", 
	    	argv[0], ErrorString(diskf->lastexception));
	    exit(diskf->lastexception);
	  }
      }

    if (labelf == NULL) exit(0);

    if ( (cnt = fread(buffer, 1, LOGICAL_BLOCK_SIZE, labelf)) != 
	    LOGICAL_BLOCK_SIZE && 
	    Eof(labelf) != END_OF_FILE )
      {
	fprintf(stderr, "%s: error reading %s: %s, %d bytes read\n",
	    argv[0], argv[3], ErrorString(Eof(labelf)), cnt);
	exit(Eof(labelf));
      }

    diskf->block = 0;
    if (Write(diskf, buffer, LOGICAL_BLOCK_SIZE) != 
	    LOGICAL_BLOCK_SIZE || diskf->lastexception != OK)
      {
	fprintf(stderr, "%s: error writing to disk: %s\n", 
	    argv[0], ErrorString(diskf->lastexception));
	exit(diskf->lastexception);
      }

  }
