#include <Venviron.h>
#include <Vio.h>
#include "sh.h"
#define MAXARGS 200
#define ARGBUFSIZE 2000

static    int  newargc ;
static    char  **newargv, *argsbuf, *argptr ;

expandargs(addressOFargc, addressOFargv)
    int *addressOFargc ;
    char **addressOFargv[] ;

  {
    int oldargc ;
    char **oldargv ;

    oldargc = *addressOFargc ;
    oldargv = *addressOFargv ;

    newargc = 0 ;
    /* allocate space for new argv pointers */
    if ((newargv = (char **) malloc(MAXARGS*sizeof(char *))) == (char **) 0)
      {
        fprintf(stderr, "Cannot allocate %d bytes of memory\n",
             MAXARGS*sizeof(char *)) ;
        return (-1) ;
      }
    *addressOFargv = newargv ;

    /* allocate space for new expanded arguments */

    if ((argsbuf = (char *) malloc(ARGBUFSIZE)) == (char *) 0)
      {
        fprintf(stderr, "Cannot allocate %d bytes of memory\n",ARGBUFSIZE) ;
	free (*addressOFargv) ;
        return (-1) ;
      }
    argptr = argsbuf ;

    while (oldargc--)
      {
        /* printf("Trying to match %s\n", *oldargv) ; */
 	if (matchpattern(*oldargv) == -1) 
	  {
	    free (*addressOFargv) ;
	    free(argsbuf) ;
	    return(-1) ;
	  } 
	oldargv++ ;
      }
    *addressOFargc = newargc ;
  }



matchpattern(pat)
  char *pat;
  {
 /*
  * Search for files whose names match pattern 'pat', and
  * put them into 'expandBuf'.
  */

    register char *slash = pat-1;
    register char *star = pat;
    char path[256];
    char *endptr;
    char pathend, c;
    DirList *entrylist, *e1, *ReadDirectory();


    /* look for a star in the pattern */
    while (*star && (*star != '*'))
      {
        if (*star == '/' || *star == ']') slash = star;
        star++;
      }
    if (!*star) /* A match ! */
      {
        /* printf ("We have a match : %s\n", pat) ; */
        if (newargc >= MAXARGS)
          {
            printf("Too many arguments.\n");
            return(-1);
	  }
	if (argptr + strlen(pat) - argsbuf >= ARGBUFSIZE)
          {
            printf("Too many long arguments.\n");
            return(-1);
	  }
	/* using 'slash' as a temp copy the complete pattern
	   into the buffer space pointed to by *argv.
	*/
	*newargv = argptr ;
	newargv++  ;
	newargc++  ;
	while (*argptr++ = *pat++) ;
	*argptr++ = '\0' ;
        return(0);
      }

    /* strip the current path from the pattern */
    if (slash < pat)
         *path = 0;
    else
      {
        char *ptr1 = path;
        char *ptr2 = pat;
	while (ptr2 <= slash) *ptr1++ = *ptr2++;
	/* knock the trailing '/' off the path */
        if ((pathend = *(ptr2 - 1)) == '/') *(ptr1-1) = 0;else *ptr1 = 0; 
      }
    /* find the next level of directories */
    endptr = star;
    while (*endptr && (*endptr != '/')) endptr++;
    c = *endptr;
    if (*endptr) *endptr++ = 0;

    star = slash+1;

    /* use slash to mark the end of the path */
    slash = path;
    while (*slash) slash++;

    /* read directory names */
    entrylist = ReadDirectory(path);
    
    /* append the slash back onto the path */
    if (pathend == '/') { *slash++ = '/'; *slash = 0; }
    
   /* check each directory entry */
    while (entrylist)
      {
        /* special kludge to prevent matching filenames with leading '.'s */
	if (((*(entrylist->fn) != '.') || (*star == '.')) &&
	    (MatchName(entrylist->fn, star)))
          {
            /* this is a match so far */
            strcat(path, entrylist->fn);
	    if (c) strcat(path, "/");
            strcat(path, endptr);
            if (matchpattern(path) == -1) return(-1);
            *slash = 0;
          }
        free(entrylist->fn);
        e1 = entrylist;
        entrylist = entrylist->link;
        free(e1);
      }
    if (c) *(endptr-1) = c;
    return(0);
  } /* End of MatchPattern */

int MatchName(s,p)
char *s, *p;
  /* see if s matches pattern p */
  {

    while (*s && (*s == *p))
      {
        s++; p++;
      }
    /* if both strings are empty then they match */
    if (!*s && !*p) return(1);

    /* if the pattern doesn't contain a star at the differing
     * character then this is not a match */
     if (*p != '*') return(0);
    
    if (MatchName("", p+1)) return(1); /* check for trailing star case first */
    /* attempt to match by successivley 'eating'
     * characters and recursing on the remainder
     * of the source and pattern
     */
    while (*s)
      {
	if (MatchName(s, p+1)) return(1);
	s++;
      }
    return(0);
  }

