/*
 * silread.c - read a sil file into data structures
 *
 * Bill Nowicki November 1983
 *
 * Removed from siledit.c
 * (see RCS file for history)
 */

# include "sil.h"
# include <stdio.h>

char SmallFontName[100] = "Helvetica7";
char BigFontName[100] = "Helvetica10";
extern char *rindex();

ReadAltFonts(name)
    char *name;
  {
  	/*
	 * Try to read an alternate font file
	 */
    char our[128];
    register char *p;
    FILE *f;

    strcpy(our,name);
    if (p = rindex(our,'.'))
      {
        if (strcmp(p,".sil")==0) *p = 0;
      }
    f = fopen(our,"r");
    if (f==NULL)
      {
        strcat(our,".fonts");
	f = fopen(our,"r");
	if (f==NULL)
	  {
	     return;
	  }
      }
    while ( fgets(our,sizeof our,f) && our[0]=='#')
 	if (feof(f)) return;
    if (p = rindex(our,'\n'))
        *p = 0;

    strcpy(SmallFontName,our);
    while ( fgets(our,sizeof our,f) && our[0]=='#')
 	if (feof(f)) return;
    if (p = rindex(our,'\n'))
        *p = 0;
    strcpy(BigFontName,our);
  }


PrettyPut(c)
 char c;
  {
    /*
     * put a character, but make darn sure it is printable!
     */
     if (c<' ' || c > '~' )
       printf("<0%o>", c & 255);
     else
       putchar(c);
  }

GetByte(f)
    FILE *f;
  {
  	/*
	 * get a byte from the file
	 */
    return(getc(f) & 255 );
  }

GetShort(f)
    FILE *f;
  {
  	/*
	 * get a short (16-bit) word from the file
	 * in big-endian order
	 */
    int temp = getc(f) << 8;
    return( (temp | getc(f)) & 0xFFFF );
  }

ParseFile(f, xminp, xmaxp, yminp, ymaxp)
    FILE *f;
    short *xminp, *xmaxp, *yminp, *ymaxp;
  {
	/*
	 * read the .sil file into internal data structures,
	 * and calculate the bounding box.
	 * Returns the bounding box in the last four pointers
	 * if they are non-null.
	 */
     short password;
     short link, xmin, xmax, ymin, ymax, length, font, ital;
     short newymin, newymax;
     short xminb, xmaxb, yminb, ymaxb;
     long objs;
     register struct Object *ob = Table;
  
	/*
	 * default values for bounding box (entire page)
	 */
    xminb = 0;	xmaxb = XLimit;
    yminb = 0;	ymaxb = YOffset;

    for (objs=0;objs<FirstItem;objs++, ob++)
      {
        ob->state = Special;
      }
     while (ob<Table+MaxObjects) 
       {
         ob->state = Empty;
	 ob++;
       }

    if (f)
     {
      ob = Table+FirstItem;
      password = GetShort(f);
      if (password!=Password)
        {
          printf("Does not look like a SIL file, Password=0%o\r\n",
		password);
         }

      while (feof(f)==0 ) 
       {
	link = GetShort(f);
	if (feof(f)) break;
	if (link != -1)
    	    if (Debug) printf("Link=0%o", link);
	xmin = GetShort(f) & CoordMask;
	ymin = GetShort(f) & CoordMask;
	xmax = GetShort(f) & CoordMask;
	ymax = GetShort(f);
	font = GetFont(ymax);
	ital = ymax & (CoordMask+1);
	ymax &= CoordMask;
	if (Debug) 
	    printf(" Object %d xmin=%d, ymin=%d, xmax=%d, ymax=%d ", 
		objs,xmin,ymin,xmax,ymax);
	  /*
	   * Alto numbers from top down, VGTS bottom up.
	   * Also, VGTS includes borders, while SIL does not.
	   * Therefore we must fudge, generating VGTS coordinates.
	   */
	newymin = YOffset - ymax + 1;
	newymax = YOffset - ymin;
	xmax--;
	if (objs==FirstItem)
	  {
	    xminb = xmin;
	    xmaxb = xmax;
	    yminb = newymin;
	    ymaxb = newymax;
	  }
	else
	  {
	  	/*
		 * update bounding box if more than one object
		 */
	    if (xminb > xmin) xminb = xmin;
	    if (xmaxb < xmax) xmaxb = xmax;
	    if (yminb > newymin) yminb = newymin;
	    if (ymaxb < newymax) ymaxb = newymax;
	  }
	ob->state = Used;
	ob->selected = 0;
	ob->number = objs++;
	ob->xmin = xmin;
	ob->ymin = newymin;
	ob->xmax = xmax;
	ob->ymax = newymax;
        ob->fontNumber = font + (ital ? 8 : 0);
	if (font==LineFont || font==LineFont+1)
	  {
	    ob->kind = Line;
	    if (Debug) printf("Line\r\n");
	  }
	else
	  {
	    int odd;
	    char *string;
	    register char *p;
	    
	    length = GetByte(f);
	    if (length==0)
	      {
	        GetByte(f);
		if (Debug) printf("Zero length string\r\n");
	        continue;
	      }
	    odd = length &1;
	    if (length>200)
	      {
	        printf("Strange string length, %d\r\n", length);
		continue;
	      }
	    string = (char *) malloc(length+1);
	    if (string==NULL)
	      {
	        printf("Ran out of memory\r\n");
		Quit();
	      }
	    if (Debug) printf("\r\n   String length %d:",length);
	    for (p=string;length-->0 && !feof(f);p++)
	      {
	        *p = GetByte(f);
	        if (Debug) PrettyPut(*p);
	      }
	    *p++ = 0;
	    if (!odd) GetByte(f);
	    if (Debug) printf("   in Font %d\r\n",font);
	    ob->kind = Text;
	    ob->string = string;
	  }
	ob++;
       }
     }
     while (ob<Table+MaxObjects) 
       {
         ob->state = Empty;
	 ob++;
       }
      if (xminp) *xminp = xminb;
      if (xmaxp) *xmaxp = xmaxb;
      if (yminp) *yminp = yminb;
      if (ymaxp) *ymaxp = ymaxb;
 }


BaseOf(string,font,ymin,ymax)
    char *string;
    short font, ymin, ymax;
  {
  	/*
	 * calculate the baseline of some text given the
	 * bounding box and the VGTS font number.
	 * Some day this could be made smarter...
	 */
    if (font==Template64) return(ymax-1);
    
    if (Descenders(string))
        return(ymin+DescentFudge);

    return(ymin);
  }


Descenders(string)
  char *string;
 {
 	/*
	 * return true if there are any characters with descenders
	 * in the string.
	 */
    return( index(string,'g') ||
    	    index(string,'j') ||
    	    index(string,'p') ||
    	    index(string,'q') ||
    	    index(string,'y') ||
    	    index(string,']') ||
    	    index(string,'}') ||
    	    index(string,'[') ||
    	    index(string,'{') 
	  );
 }
 
