/*
 * silmove.c - moving options for silly
 * Bill Nowicki April 1983
 *
 */

# include "sil.h"

# include <Vgts.h>
# include <Vio.h>
# include <text.h>

extern short Changed;		/* true if changes were made */

DoMove(copyFlag)
  {
  	/*
	 * Move the selected objects.  If the copyFlag is true,
	 * we move new copies; otherwise move the originals
	 */
    struct Object *list, *cloneList;	
    register struct Object *ob = SelectList;
    short buttons, x, y, xstart, ystart, xoffset, yoffset, xlast, ylast;
    short boundXmin, boundXmax, boundYmin, boundYmax;

    if (ob==NULL)
      {
        printf("You have to select something first\r\n");
	return;
      }

    printf("%s objects from ", copyFlag ? "Copy" : "Move");
    Flush(stdout);
    RedrawPad(stdout);
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }
    if (copyFlag)
      {
		/*
		 * here we clone the selected objects if desired.
		 * The new objects stay put, and we drag the old
		 * objects (and keep them selected).
		 */
        list = NULL;
        EditSymbol(sdf,TopSymbol);	
	for (ob=SelectList;ob;ob=ob->next)
	  {
	     register struct Object *temp = GetFreeObject();
	     if (temp==NULL)
	       {
	         printf("Too many objects\r\n");
		 return;	       
	       }
	     temp->kind = ob->kind;
	     temp->fontNumber = ob->fontNumber;
	     temp->xmin = ob->xmin;
	     temp->xmax = ob->xmax;
	     temp->ymin = ob->ymin;
	     temp->ymax = ob->ymax;
             temp->selected = 0;
	     temp->next = list;
	     list = temp;
             switch (temp->kind)
               {
	  	case Line:
	    	    AddItem(sdf,temp->number,
		    	temp->xmin, temp->xmax, temp->ymin, temp->ymax, BLACK,
	    		SDF_FILLED_RECTANGLE, NULL);
	    	    break;

    		case Text:
	       	    temp->string = (char *)malloc(strlen(ob->string)+1);
		    strcpy(temp->string,ob->string);
		    AddItem(sdf,temp->number,temp->xmin, temp->xmax, 
	  BaseOf(ob->string, FontMap[ ob->fontNumber ],ob->ymin,ob->ymax),
			0, FontMap[ temp->fontNumber ], SDF_TEXT, temp->string);
	            break;
	      } /* switch */
	  }  /* for */
        EndSymbol(sdf,TopSymbol,vgt);
	cloneList = list;
      } /* clone objects */

    list = SelectList;

    boundXmin = list->xmin;
    boundXmax = list->xmax;
    boundYmin = list->ymin;
    boundYmax = list->ymax;
    for (ob=list;ob;ob=ob->next)
      {
	    /*
	     * Calculate the bounding box of all selected objects
	     */
	if (boundXmin > ob->xmin) boundXmin = ob->xmin;
	if (boundXmax < ob->xmax) boundXmax = ob->xmax;
	if (boundYmin > ob->ymin) boundYmin = ob->ymin;
	if (boundYmax < ob->ymax) boundYmax = ob->ymax;
      }


    printf("to desired position ");
    Flush(stdout);
    RedrawPad(stdout);
    xlast = x;
    ylast = y;
    Changed++;

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {
      	  /*
	   * Calculate the offset, then check to make sure all
	   * selected objects are still on the page
	   */
	
        xoffset = x - xstart;
	yoffset = y - ystart;
	
	if (xoffset + boundXmin < 0)  xoffset = -boundXmin;
	if (xoffset + boundXmax > XLimit) xoffset = XLimit - boundXmax;
	if (yoffset + boundYmin < 0)  yoffset = -boundYmin;
	if (yoffset + boundYmax > YOffset) yoffset = YOffset - boundYmax;

  	/*
	 * If we moved out of the view, then just update things.
	 * If aborted, try to put things back the way they were.
	 * When copying, delete the clones an re-select
	 * the originals.
	 */
	 if (buttons<0)
	    {
	       for (ob=list;ob;ob=ob->next)
	         {
	           ob->xmin += xoffset;
		   ob->xmax += xoffset;
		   ob->ymin += yoffset;
		   ob->ymax += yoffset;
	          }
		printf("Out of view\r\n");
	        return;
	      } /* buttons<0 */

	  if (buttons==7)
	   {
            EditSymbol(sdf,TopSymbol);
	    for (ob=list;ob;ob=ob->next)
		 {
		   switch (ob->kind)
                      {
	  		case Line:
	      		  ChangeItem(sdf,ob->number,ob->xmin, ob->xmax, 
	    		    ob->ymin, ob->ymax, 
			    GRAY, SDF_FILLED_RECTANGLE, NULL);
	    		  break;

			case Text:
	  		  ChangeItem(sdf,ob->number,ob->xmin, ob->xmax, 
	  BaseOf(ob->string, FontMap[ ob->fontNumber ],ob->ymin,ob->ymax), 0,
	        FontMap[ ob->fontNumber ], SDF_TEXT, NULL);
#ifndef INVERT
			  ChangeItem(sdf,ob->number+SelectFlag,
	    		ob->xmin, ob->xmax, 
	    		ob->ymin - 1, ob->ymax + 1, 
	    	HILIGHT, SDF_FILLED_RECTANGLE, NULL);
#endif INVERT
	    		  break;
     			 } /* switch */
	          } /* for each selected object */
	       if (copyFlag)
		  for (ob=cloneList;ob;ob=ob->next)
		     {
		       ob->state = Deleted;
		       DeleteItem(sdf,ob->number);
		       DeleteItem(sdf,ob->number+SelectFlag);
		     } /* for each cloned object */
        	EndSymbol(sdf,TopSymbol,vgt);
	        printf("Aborted\r\n");
		return;
	      } /* if buttons==Abort */

	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         EditSymbol(sdf,TopSymbol);
         for (ob=list;ob;ob=ob->next)
          {
	    /*
	     * translate each object by the relative distance we
	     * have moved so far
	     */
        switch (ob->kind)
          {
	  case Line:
	    ChangeItem(sdf,ob->number,ob->xmin+xoffset, ob->xmax+xoffset, 
	    	ob->ymin+yoffset, ob->ymax+yoffset, 
		GRAY, SDF_FILLED_RECTANGLE, NULL);
	    break;

	case Text:
	    ChangeItem(sdf,ob->number,ob->xmin+xoffset, ob->xmax+xoffset, 
	  BaseOf(ob->string, FontMap[ ob->fontNumber ],ob->ymin + yoffset,
	  					ob->ymax + yoffset), 0,
	        FontMap[ ob->fontNumber ], SDF_TEXT, NULL);
#ifndef INVERT
	  ChangeItem(sdf,ob->number+SelectFlag,
	    		ob->xmin+xoffset, ob->xmax+xoffset, 
	    		ob->ymin+yoffset - 1, ob->ymax+yoffset + 1, 
	    	HILIGHT, SDF_FILLED_RECTANGLE, NULL);
#endif INVERT
	    break;
	  } /* switch on object kind */
	} /* for each selected object */
        EndSymbol(sdf,TopSymbol,vgt);
     } /* while button down */

     for (ob=list;ob;ob=ob->next)
       {
         ob->xmin += xoffset;
	 ob->xmax += xoffset;
	 ob->ymin += yoffset;
	 ob->ymax += yoffset;
       }
     printf("moved.\r\n");
  }


DoBox()
  {
    register struct Object *ob1, *ob2, *ob3, *ob4;
    short buttons, x, y, xstart, ystart, xoffset, yoffset, xlast, ylast;

    ob1 = GetFreeObject();
    ob2 = GetFreeObject();
    ob3 = GetFreeObject();
    ob4 = GetFreeObject();
    if (ob1==NULL || ob2==NULL || ob3==NULL || ob4==NULL)
      {
        printf("Too many objects already");
	return;
      }
    Changed++;
    ob1->kind=Line;
    ob1->fontNumber=LineFont;
    ob2->kind=Line;
    ob2->fontNumber=LineFont;
    ob3->kind=Line;
    ob3->fontNumber=LineFont;
    ob4->kind=Line;
    ob4->fontNumber=LineFont;

    printf("Select one corner of Box ");
    Flush(stdout);
    RedrawPad(stdout);
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }
    printf("lift up at other corner ");
    Flush(stdout);
    RedrawPad(stdout);
    Contain(&xstart,&ystart);
    xlast = x;
    ylast = y;
    EditSymbol(sdf,TopSymbol);
    AddItem(sdf,ob1->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    AddItem(sdf,ob2->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    AddItem(sdf,ob3->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    AddItem(sdf,ob4->number,x, x+Width, 
    		y, y+Width, BLACK, SDF_FILLED_RECTANGLE, NULL);
    EndSymbol(sdf,TopSymbol,vgt);

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {
    	Contain(&x,&y);
        xoffset = x - xstart;
	yoffset = y - ystart;
	
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    EditSymbol(sdf,TopSymbol);
            DeleteItem(sdf,ob1->number);
            DeleteItem(sdf,ob2->number);
            DeleteItem(sdf,ob3->number);
            DeleteItem(sdf,ob4->number);
            EndSymbol(sdf,TopSymbol,vgt);
	    ob1->state = Deleted;
	    ob2->state = Deleted;
	    ob3->state = Deleted;
	    ob4->state = Deleted;
	    return;
	  }
	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         EditSymbol(sdf,TopSymbol);
	 if (x>xstart)
	   {
             ob1->xmin = xstart;
             ob1->xmax = x;
             ob2->xmin = x-(Width-1);
             ob2->xmax = x;
             ob3->xmin = xstart;
             ob3->xmax = x;
             ob4->xmin = xstart;
             ob4->xmax = xstart+(Width-1);
	   }
	 else
	   {
             ob1->xmin = x;
             ob1->xmax = xstart;
             ob2->xmin = xstart-(Width-1);
             ob2->xmax = xstart;
             ob3->xmin = x;
             ob3->xmax = xstart;
             ob4->xmin = x;
             ob4->xmax = x+(Width-1);
	   }
	 if (y>ystart)
	   {
             ob1->ymin = ystart;
             ob1->ymax = ystart+(Width-1);
             ob2->ymin = ystart;
             ob2->ymax = y;
             ob3->ymin = y-(Width-1);
             ob3->ymax = y;
             ob4->ymin = ystart;
             ob4->ymax = y;
	   }
	 else
	   {
             ob1->ymin = y;
             ob1->ymax = y+(Width-1);
             ob2->ymin = y;
             ob2->ymax = ystart;
             ob3->ymin = ystart-(Width-1);
             ob3->ymax = ystart;
             ob4->ymin = y;
             ob4->ymax = ystart;
	   }
         ChangeItem(sdf,ob1->number, ob1->xmin, ob1->xmax, 
    		ob1->ymin, ob1->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         ChangeItem(sdf,ob2->number, ob2->xmin, ob2->xmax, 
    		ob2->ymin, ob2->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         ChangeItem(sdf,ob3->number, ob3->xmin, ob3->xmax, 
    		ob3->ymin, ob3->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         ChangeItem(sdf,ob4->number, ob4->xmin, ob4->xmax, 
    		ob4->ymin, ob4->ymax, BLACK, SDF_FILLED_RECTANGLE, NULL);
         EndSymbol(sdf,TopSymbol,vgt);
       }
     printf("done.\r\n");
  }


DoStretch()
  {
    register struct Object *ob = SelectList;
    short buttons, x, y, xstart, ystart, xlast, ylast;
    short xanchor, yanchor, width, xminOld, yminOld;

    if (ob==NULL || ob->kind!=Line)
      {
        printf("You have to select a line first\r\n");
	return;
      }

    printf("Select end to stretch ");
    Flush(stdout);
    RedrawPad(stdout);
    Changed++;
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }
      	/*
	 * now we need to be clever, and  find the end of the line
	 * that we are farthest away from, and how wide it is.
	 */
    if ( abs(xstart - ob->xmin) > abs(xstart - ob->xmax) )
      xanchor = ob->xmin;
    else
      xanchor = ob->xmax;
    if ( abs(ystart - ob->ymin) > abs(ystart - ob->ymax) )
      yanchor = ob->ymin;
    else
      yanchor = ob->ymax;

    if ( abs(ob->xmax - ob->xmin) < abs(ob->ymax - ob->ymin) )
      width = ob->xmax - ob->xmin;
    else
      width = ob->ymax - ob->ymin;

    xminOld = ob->xmin;
    yminOld = ob->ymin;

    printf("lift up at desired position ");
    Flush(stdout);
    RedrawPad(stdout);
    xlast = x;
    ylast = y;

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {

    	Contain(&x,&y);
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         EditSymbol(sdf,TopSymbol);
         for (ob=SelectList;ob;ob=ob->next)
          {
	    /*
	     * translate the object by the relative distance we
	     * have moved so far
	     */
	    if ( abs(x - xanchor) < abs(y - yanchor) )
	    {
	    	/*
		 * Vertical lines - move ymin and ymax, leave x alone.
		 * If we have to swing the line around 90 degrees, remember
		 * which side was the anchor and move the other.
		 */
	      if (ob->xmax - ob->xmin > width)
	        {
		  if (ob->xmin == xanchor) ob->xmax = ob->xmin+width;
		  if (ob->xmax == xanchor) ob->xmin = ob->xmax-width;
		}
	      if (y<yanchor)
	        {
		  ob->ymin = y;
		  ob->ymax = yanchor;
		}
	      else
	        {
		  ob->ymin = yanchor;
		  ob->ymax = y;
		}
	      }
	    else
	    {
    		/* 
		 * Horizontal lines - move xmin and xmax
		 */
	      if (ob->ymax - ob->ymin > width)
	        {
		  if (ob->ymin == yanchor) ob->ymax = ob->ymin+width;
		  if (ob->ymax == yanchor) ob->ymin = ob->ymax-width;
		}
	      if (x<xanchor)
	        {
		  ob->xmin = x;
		  ob->xmax = xanchor;
		}
	      else
	        {
		  ob->xmin = xanchor;
		  ob->xmax = x;
		}
	      }
        ChangeItem(sdf,ob->number,ob->xmin,ob->xmax,
	    		ob->ymin, ob->ymax, GRAY, SDF_FILLED_RECTANGLE, NULL);
	  }
        EndSymbol(sdf,TopSymbol,vgt);
     }
     printf("done.\r\n");
  }


DoArea()
  {
  	/*
	 * Area select
	 */
    register struct Object *ob = SelectList;
    short buttons, x, y, xstart, ystart, xlast, ylast;
    short xanchor, yanchor, width, xminOld, yminOld;

    printf("Hold button to select area ");
    Flush(stdout);
    RedrawPad(stdout);
    while ((buttons=GetGraphicsStatus(stdin,&xstart,&ystart,NULL))<=0)
      {
        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
      }

    printf("lift up when done ");
    Flush(stdout);
    RedrawPad(stdout);
    xlast = x;
    ylast = y;

    while ((buttons=GetGraphicsStatus(stdin,&x,&y,NULL)) != 0)
      {

        if (buttons<0 || buttons==7)
	  {
	    printf("Aborted\r\n");
	    return;
	  }
	 if (x==xlast && y==ylast) continue;
	 xlast = x;
	 ylast = y;
         for (ob=SelectList;ob;ob=ob->next)
          {
	      /*
	       * unselect everything outside the box
	       */
# define Between(mid,a,b) ((a <= mid && mid <= b) || (b <= mid && mid <= a))
	   if ( Between(ob->xmin,xstart,x) && Between(ob->xmax,xstart,x) &&
	        Between(ob->ymin,ystart,y) && Between(ob->ymax,ystart,y) )
	     continue;
	   UnSelect(ob->number);
	  }
	 for (ob = Table+FirstItem;ob<Table+MaxObjects;ob++)
	  if (ob->state==Used &&
	      Between(ob->xmin,xstart,x) && Between(ob->xmax,xstart,x) &&
	      Between(ob->ymin,ystart,y) && Between(ob->ymax,ystart,y) &&
		 ob->selected == 0)
	       {
	       		/*
			 * Add the object to the selected list.
			 * It is inside our rectangle, but was not
			 * previously selected.
			 */
		 ob->next = SelectList;
		 SelectList = ob;
		 ob->selected = 1;
		 switch (ob->kind)
	          {
		   case Line:
		        EditSymbol(sdf,TopSymbol);
			ChangeItem(sdf,ob->number,
			    ob->xmin, ob->xmax, ob->ymin, ob->ymax, GRAY,
			    SDF_FILLED_RECTANGLE, NULL);
			EndSymbol(sdf,TopSymbol,vgt);
		 	break;
		 
		   case Text:
			EditSymbol(sdf,TopSymbol);
#ifdef INVERT
			ChangeItem(sdf,num,ob->xmin, ob->xmax, 
	           		BaseOf(ob->string,FontMap[ ob->fontNumber ],
				ob->ymin,ob->ymax),	
		     0,  FontMap[ ob->fontNumber ], SDF_TEXT, Sel(ob->string));
#else INVERT
			InquireItem(sdf,ob->number, &(ob->xmin), &(ob->xmax), 
		    		NULL, &(ob->ymax), NULL, NULL, NULL);
			AddItem(sdf,ob->number+SelectFlag,ob->xmin, ob->xmax, 
		    		ob->ymin - 1, ob->ymax - 1, 
		    		HILIGHT, SDF_FILLED_RECTANGLE, NULL);
#endif INVERT
	      		EndSymbol(sdf,TopSymbol,vgt);
	       
	    	   } /* switch */
	} /* for each object */
     } /* Mouse button down */
     printf("done.\r\n");
  }


