/*-------------------------------------------------------------
 *
 *  Copyright (C) 1980, Ivor Durham.
 *
 *  Translated 1980 from SAIL into C by Tom Rodeheffer (tlr)
 *      by permission of the original author.
 *
 *-------------------------------------------------------------
 *
 *  This file contains the definitions for the interface
 *  exposed by press.c
 *
 *-------------------------------------------------------------
 *
 *  Design:
 *
 *  This file contains the appropriate "external" declarations
 *  for using the functions exported by the Press File module
 *  (press.c).  It also defines a number of the command codes
 *  used in the Entity list of a printed page part of a press
 *  file (as documented in "Press File Format" by Bob Sproull
 *  and William Newman).
 *
 *-------------------------------------------------------------
 */

/*
 * ~~~~ Functions on Type "Data List" ~~~~
 */

extern DLPutByte ( /* int Value */ );

/*
 * ~~~~ Functions on Type "Entity List" ~~~~
 */

extern ELPutByte ( /* char Value */ );
extern ELPutWord ( /* short Value */ );
extern ELPutLong ( /* long Value */ );
extern ELSetFont ( /* int Font_Number */ );

/*
 * ~~~~ Functions on Type "Entity" ~~~~
 */

extern BeginEntity ( /* int Type, FontSet, AbsoluteX, AbsoluteY,
				Left, Bottom, Width, Height */ );
extern EndEntity ();
extern PutStringontoPage ( /* int XPosition, YPosition;
			      char * Text */ );

/*
 * ~~~~ Functions on Type "Printed Page" ~~~~
 */

extern BeginPage ();
extern EndPage ();

/*
 * ~~~~ Functions on Type "Press File" ~~~~
 */

extern EnterFontinDirectory ( /* int FontSet, Font;
				 int FirstChar, LastChar;
				 char *Family;
				 int Face, Source;
				 int Size, Rotation */ );
extern int PressStart ( /* char *PressFileName; int Copies */ );
extern int PressFinish ();
extern PressAbort ();

extern PressSetCopies ( /* int copies */ );
extern PressSetCreator ( /* char * creator */ );
extern PressSetBanner ( /* char * banner */ );


/*
 * ~~~~ Entity List Commands ~~~~
 */

#define ELShowCharactersShort    0000
#define ELFont                   0160
#define ELSetX                   0356
#define ELSetY                   0357
#define ELShowCharacters         0360
#define ELShowCharacterImmediate 0363
#define ELShowRectangle          0376
#define ELNop                    0377

/*
 * ~~~~ Additional "Entity" Functions ~~~~
 */

extern PressSetX ( /* int Position */ );
extern PressSetY ( /* int Position */ );
extern PressFont ( /* int Font */ );
extern PressShowRectangle ( /* int Xposition, Yposition;
			       int Width, Height */ );
extern PressShowRectangleHere ( /* int Width, Height */ );

/*
 * ~~~~ End of Definitions ~~~~
 */

