/*
 * the layout of a font information block
 */

struct font
{
    struct font * next;     /* link to next font info block */
    int code;               /* numeric code designating this font */
    unsigned char set;      /* font set */
    unsigned char number;   /* font number within set */
    char name [20];         /* name of font family */
    int scaled;             /* TRUE if this is a scaled font */
    int size;               /* size in points */
    int rotation;           /* rotation in minutes */

    unsigned char bc;       /* beginning char defined */
    unsigned char ec;       /* ending char defined */

    char face;     /* encoded facecode: */
                  /*  (bold: 2, light: 4, else: 0)  +         */
                  /*  (italic: 1, else: 0)  +                 */
                  /*  (condensed: 6, expanded: 12, else: 0)   */
		  /*                                          */
		  /* ... or if less than 0, logical size 
				   For TEX fonts: 
				   - 2*(logical points+1) */

    int bcUsed;       /* beginning char used (or 256) */
    int ecUsed;       /* ending char used (or -1) */

    long atsize;	/* "at" size in rsu's (10^(-7) meters) */
    int widthbase;	/* index into width table */

};


struct family
{
    char * family_name;
    unsigned char family_face;
    struct font * family_font [40];
};

extern struct font fontEmpty[];	     /* empty font for missing defs */
extern struct font * fontListHead;   /* list of all font info blocks */
extern int logAtLeftMargin;          /* log (stderr) at left margin */
extern int onlySpruceFonts;          /* only use spruce fonts */

#define even(x) (((x)&01) == 0)
#define odd(x) (((x)&01) != 0)


#define MicasPerInch 2540

#define MicasPageHeight \
	( MicasPerInch*10 + (MicasPerInch*5)/8 )   /* 10.625 inches */

#define MicasPageWidth \
	( MicasPerInch*8 + (MicasPerInch*1)/2 )    /*  8.5   inches */


#define PointsPerInch 72

#define MicasToPoints(m) \
	( (((m)+0L)*PointsPerInch+(MicasPerInch/2)) / MicasPerInch )

#define PointsToMicas(p) \
	( (((p)+0L)*MicasPerInch+(PointsPerInch/2)) / PointsPerInch )


#define	NotThere 0100003



extern char * MyAlloc ();

extern struct font * UseFontinFamily ();
extern char * FontName ();

extern DefineFamily ();
 
