/* include files for show: DVI- and Press-file viewer for the Suns under V */
/* Per Bothner. Jan 1984 */
#include <stdio.h>

/* DVI file constants */
#define IdByte 2 /* kind of DVI format we can handle */
#define NoOp 138
#define Bop 139
#define FntDef1 243

#define InvalidWidth 017777777777
#define NullCount 0x80000000

typedef struct _FontInfo
  {
    struct _FontInfo *next;
    int fontNum;	/* external font number, as used in DVI file */
    long checkSum;
    long scaleFactor;
    long fontSpace;	/* cut-off between "small" and "large" spaces */
    float designSize;
    unsigned short minChar, maxChar;
    char *fileName, *fontName;
    unsigned long *width0;
    short internalFont; /* only valid if correct internalFontMag */
    int internalFontMag;
  } FontInfo;
extern FontInfo *CurFont, *FontList;
extern FILE *dataFile, *auxFile;
extern short CurPage, TotalPages;
extern long *PageStart, *Count0;
extern long TeXbookStart[], TeXbookCount0[];
extern long	fdStart;	/* start record of font directory */
extern long	fdRecs;		/* length of font directory */
typedef unsigned short ushort;

/* used when searching in press files */
#define PressPart(n) (PageStart[n]&0xFFFF)
#define PageRecs(n) ((PageStart[n]>>16)&0xFF)
#define EntityPadding(n) ((PageStart[n]>>24)&0xFF)
extern long Spacing; /* if != InvalidWidth, spaces are this many pixels wide */
#define MicasPerPixel 32  /* maintaining consistency with Alto software */
enum format { NoFormat, DVIFormat, PressFormat};
extern enum format Format;
#define crash fatal
