/* show		Copyright Per Bothner, Dec 1985 */
#include <Vio.h>
#include "show.h"
#include <Vgts.h>
#include <Vtermagent.h>
#include <fields.h>

short LastCommandWasHelp = 0;
Help()
  {
fputs(
"'show' displays a DVI file or a Press file on the screen.\n\
(It is tailored for TeX DVI files, and the Press support is very rudimentary.)\n\
You give it commands by using the mouse to select a command from this window.\n\
You can \"drag\" the contents of the text window with the mouse (press a\n\
mouse button inside the view, move the mouse and release the button).\n\
\n\
The \"File to show\" command is used to read in a new DVI (or Press) file.\n\
The \"Page i of n\" command allows you to go directly to any page.\n\
The \"Page counters\" string displays the non-zero \\count0 numbers from TeX.\n\
The \"Page counter pattern\" is matched against these counters for the Next and\n\
Previous commands. Non-matching pages are skipped; * matches any number.\n\
\n\
There are also keyboard commands:\n\
q, ^C, ^Z (same as hitting [Quit] with the mouse): Exit the program.\n\
n, N, ^N (or [Next page]): Go (circularly) to next page matching the pattern.\n\
p, P or ^P (or [Previous Page]): Go to previous page matching the pattern.\n\
u, U, ^U or d, D, ^D scroll half a page up or down, respectively.\n\
\n\
Give a command (e.g. <space>) to continue.\n", stdout);
fflush(stdout);
LastCommandWasHelp = 1;
  }

#define ConvScale (1<<20)
#define DefaultTFMdirectory "/usr/stanford/lib/tex82/fonts/"
#define AlternateTFMdirectory "/usr/local/fonts/tfm/"

FontInfo *FontList = 0;
FontInfo NullFont = {0, 0, 0, 0, 0, 0, 1, 0, "", "", 0, 0xFF};
FontInfo *
GetNullFont() {return &NullFont;}

int GetDVIname(), Quit(), NewPage(), MatchPage(), SetMagnification();
FontInfo *NewFont(), *SelectFont(), *CurFont = NULL;
char DVIname[70] = "-- no file -- \000";
#define DefaultPressMag 1.0
#define Resolution 80.0 /* pixels per inch on the screen */
float TrueConv;
FILE *dataFile = NULL, *auxFile = NULL;
enum format Format = NoFormat;
long DVIlength = 0, FixConv = 1, Spacing = InvalidWidth;
#ifdef PROFILE
int _Profile = 0; long mTime, nItems;
#endif PROFILE

PixelRound(d)
  { return (d * FixConv + (1<<19)) >> 20; /* ??? could this overflow ??? */ }

RulePixels(x)
  { return (x * FixConv + ConvScale - 1) >> 20; }

#define CharWidth(fnt, ch)						\
	((ch) < (fnt)->minChar || (ch) > (fnt)->maxChar ? InvalidWidth	\
	 : (fnt)->width0[ch])
long Numerator = 0, Denominator = 1, MaxV, MaxH, MaxStack;
short CurPage = 1, TotalPages = 0;
long *PageStart = NULL; /* PageStart[i] is the position of page i, if > 0 */
long *Count0 = NULL;    /* like PageStart, but gives values of \count0 */
long Count[10]; char CountStr[100] = "";
long CountPat[10] = {
    NullCount, NullCount, NullCount, NullCount, NullCount,
    NullCount, NullCount, NullCount, NullCount, NullCount};
char CountPatStr[100] = "*";
#ifdef TeX_BOOK
#include "TeXbook.h"
#endif TeX_BOOK

struct MagTextField { char fmt[15]; float mag}
  MagText[ ] = {
    { " step0=%g",	1.0},
    { " step1=%g",	1.2},
    { "*step2=%g",	1.44},
    { " step3=%g",	1.728},
    { " step4=%g",	2.0736},
    { " step5=%g",	2.48832},
    { " Special: %g",	1.0},
    { " Source: %g",	1.0} /* DVImag */
};
#define SpecialMagField 6 /* index into MagText of "Special" magnification */
int CurMagField = 2; /* index into MagText of "current" magnification */
#define Magnification MagText[CurMagField].mag
#define DVImag MagText[7].mag
#define MagField(i) \
    {i+2,65,14,VAL &MagText[i].mag, SetMagnification, MagText[i].fmt}
/* The menu occupies lines 1:MenuEnd; the remainer can be used for messages */
#define MenuEnd 10
#define MoveBelowMenu printf("\033[%d;1H", MenuEnd+1)
#define ClearBelowMenu printf("\033[%d;1H\033[J", MenuEnd+1)

Field Menu[] =
  {
    {2, 1,64, VAL DVIname,	GetDVIname,	"File to show: %.50s"},
    {3, 1, 8, VAL &CurPage,	NewPage,	"Page %hd    "},
    {3,10, 0, VAL &TotalPages,	0,		"of %hd    "},
    {4, 1, 0, VAL CountStr,	0,	 	"Page counters: %s"},
    {5, 1,43, VAL CountPatStr,	MatchPage,	"Page counter pattern: %s"},
    {6, 1,11, VAL 1,		MatchPage,	"[Next page]"},
    {6,13,15, VAL -1,		MatchPage,	"[Previous page]"},
    {7, 1, 6, 0,		Quit,		"[Quit]"},
    {7,13, 6, 0,		Help,		"[Help]"},
    {1,65, 0, 0,		0,	 	"Magnification"},
    MagField(0),
    MagField(1),
    MagField(2),
    MagField(3),
    MagField(4),
    MagField(5),
    MagField(6),
    MagField(7),
    LASTFIELD
  };

SetMagnification(f)
    Field *f;
  { int newMagField = (struct MagTextField*)(f->value) - MagText;
    if (newMagField == SpecialMagField)
	if (!ReadStdFld(f)) return;
    MagText[CurMagField].fmt[0] = ' ';
    CurMagField = newMagField;
    MagText[CurMagField].fmt[0] = '*';
    FixConv = TrueConv * Magnification * ConvScale;
    MoveBelowMenu;
    GotoPage(CurPage);
    ShowPage();
  }

#define TopItem 1
#define PageItem 2
#define CallItem 3
short sdf, vgt;
short x, y, xPos, yPos, buttons, c; char cBuf[30]; File vgtFile;
char input[120], output[120], sysout[120];
#define CTRL(ch) (ch&31)

main(argc, argv)
    int argc; char **argv;
  { Field *field;
/* The following hack is so that dvisun.p can write error messages */
asm(" movl #-1,sp@-"); asm(" movl #-1,sp@-");
asm(" movl #sysout,sp@-");asm(" movl #output,sp@-"); asm(" movl #input,sp@-");
asm(" jsr $initstd"); asm(" lea sp@(12),sp");
    sdf = CreateSDF();
    DefineSymbol(sdf, TopItem, 0);
    EndSymbol(sdf, TopItem, 0);
    vgt = CreateVGT(sdf, GRAPHICS, TopItem, "show");
    DefaultView(vgt, 765, 700, -10, -675, 0, 0, 0, 0);
    vgtFile.fileserver = stdin->fileserver;
    vgtFile.fileid = vgt;
    ModifyPad(stdin, ReportTransition+LF_Output);
    if (argc > 1)
#ifdef PROFILE
      if (strcmp(argv[1], "-X") == 0) _Profile = 1;
      else 
#endif PROFILE
      {
	strncpy(DVIname, argv[1], 70);
	GetDVIname(0);
      }
    for (;;)
      {
	if (LastCommandWasHelp)
	    LastCommandWasHelp = 0;
	else
	    DisplayMenu();
	c = GetEvent(stdin, &x, &y, &buttons, cBuf);
	ClearBelowMenu;
	if (c < 0) {printf("Mouse Error!"); Flush(stdout);continue;}
	if (c > 0)
	    switch(c = *cBuf)
	      {
		case 'h': case 'H': case '?':
		    Help(); continue;
		case 'q': case CTRL('Z'): case CTRL('C'): case CTRL('D'):
		    Quit();
		case 'n': case 'N': case CTRL('N'):
		    GotoPage (CurPage == TotalPages ? 1 : CurPage + 1);
		    ShowPage(); continue;
		case 'p': case 'P': case CTRL('P'):
		    GotoPage (CurPage == 1 ? TotalPages : CurPage - 1);
		    ShowPage(); continue;
#ifdef TeX_BOOK
		case 'T': DumpTables(0);
		    continue;
#endif TeX_BOOK
		case 'u':
		    MovePage(0, 500); continue; 
		case 'd':
		    MovePage(0, -500); continue;
		case ' ': case '\t': case '\n': /* no-ops */
		    continue;
#ifdef PROFILE
		case 'X': if (_Profile) _Profile = 2; continue;
#endif PROFILE
		default:
		    printf("[Received character: o%o.]\r\n", c);
		    fflush(stdout); continue;
	      }
	if (buttons!=GetGraphicsStatus(&vgtFile,&x,&y,0))
	  {
	    field = GetField(Menu, 999, buttons, stdout);
	    MoveBelowMenu;
	    if (field && field->proc) (*(field->proc)) (field);
	    continue;
	  }
	if (buttons==LeftButton||buttons==MiddleButton||buttons==RightButton)
	  { short xOld = x, yOld = y;
	    c = GetEvent(stdin, &x, &y, &buttons, cBuf);
	    if (c!=0 || buttons!=0) continue;
	    MovePage(x - xOld, y - yOld);
	  }
      }    
  }

MovePage(dx, dy)
  {
#ifdef PROFILE
    mTime = GetMilliseconds();
    if (_Profile > 1) _Profile = 3;
#endif PROFILE
    xPos += dx; yPos += dy;
    EditSymbol(sdf, TopItem);
    DeleteItem(sdf, CallItem);
    AddCall(sdf, CallItem, xPos, yPos, PageItem);
    EndSymbol(sdf, TopItem, vgt);
  }

DisplayMenu()
  { int i;
    printf("\033[H"); /* move cursor to upper left corner */
    /* clear first MenuEnd lines */
    for (i = MenuEnd; --i >= 0; ) printf("\033[K\n");
    DisplayFields(Menu, 999, stdout);
    MoveBelowMenu;
#ifdef PROFILE
    if (_Profile & 1)
      {
	 mTime = GetMilliseconds() - mTime;
	 printf("[Used: %dmS", mTime);
	 if (nItems > 0) printf(", %d items", nItems);
	 printf("]\n");
	 _Profile = 1;
      }
#endif PROFILE
    fflush(stdout); RedrawPad(stdout);
  }

GotoPage(n)
  /* goto page number n (1 <= n <= TotalPages),
     positioning dataFile after bop command */
  { int i;
    CurPage = n;
    if (Format != DVIFormat) return;
    for (i = n; PageStart[i] < 0; i++) {}
    for (; i > n; i--)
        if (Count0[i] != NullCount)
	  {
	    MoveToByte(PageStart[i] + 41);
	    PageStart[i - 1] = GetSigned4(dataFile);
	  }
	else
	  {
	    MoveToByte(PageStart[i] + 1);
	    Count0[i] = GetSigned4(dataFile);
	    fseek(dataFile, 36, 1);
	    PageStart[i - 1] = GetSigned4(dataFile);
	  }
    MoveToByte(PageStart[n]);
    do
      {
	i = GetUnsigned1(dataFile);
	if (i >= FntDef1 && i < FntDef1 + 4)
	  { FirstPar(i, dataFile);
	    fseek(dataFile, 12, 1);
	    fseek(dataFile, GetUnsigned1(dataFile) + GetUnsigned1(dataFile), 1);
	    i = NoOp;
	  }
      } while (i == NoOp);
    if (i != Bop)
      {
	fatal("Bad DVI file: not start of page!");
      }
    fread(Count, 4, 10, dataFile);
    Count0[CurPage] = Count[0];
    fread(&PageStart[CurPage - 1], 4, 1, dataFile);
    sprintf(CountStr, "%d", Count[0]);
    for (n = 9; n > 0 && Count[n] == 0; n--) {};
    for (i = 1; i <= n; i++)
        sprintf(CountStr + strlen(CountStr), ".%d", Count[i]);
  }

NewPage(f)
    Field *f;
  { int i, n;
    if ((int)f->value == -1)
	GotoPage (CurPage == 1 ? TotalPages : CurPage - 1);
    else if ((int)f->value == 1)
	GotoPage (CurPage == TotalPages ? 1 : CurPage + 1);
    else
      { int old = CurPage;
	int ok = ReadStdFld(f);
	MoveBelowMenu;
	if (ok == 1 && CurPage >= 1 && CurPage <= TotalPages)
	    GotoPage(CurPage);
	else {CurPage = old; return 0;}
      }
    ShowPage();
  }

FindMatch(direction)
  { int oldPage = CurPage, i, CountPat0 = CountPat[0];
    for (;;)
      {
        if (direction > 0)
	    if (CurPage < TotalPages) CurPage++; else CurPage = 1;
	else
	    if (CurPage > 1) CurPage--; else CurPage = TotalPages;
	if (CurPage == oldPage) return 0;
        if (CountPat0 == NullCount || Count0[CurPage] == NullCount
	 || Count0[CurPage] == CountPat0)
	  {
	    GotoPage(CurPage);
	    for (i = 10; ; )
	      {
		if (--i < 0) return 1;
		if (CountPat[i] != NullCount && CountPat[i] != Count[i]) break;
	      }
	  }
      }
  }

int
CompilePat()
  { register char c, *s = CountPatStr; int i, val, negative = 0;
    for (i = 10; --i>= 0; ) CountPat[i] = NullCount;
    for (i = 0;;)        
	switch (c = *s++)
	  {
	    case 0: return 1;
	    case ' ': case '\t': break;
	    case '*': i++; negative = 0; break;
	    case '.': if (*s == '.') i++; negative = 0; break;
	    case '-': if (negative) return 0; negative = 1; break;
	    default:
	        if (c < '0' || c > '9') return 0;
		val = c - '0';
	        while (c = *s++, c >= '0' && c <= '9') {
	            val *= 10; val += c - '0';}
	        if (i >= 10) return 0;
		if (negative) {val = -val; negative = 0;}
	        CountPat[i++] = val; s--; break;
	  }
	    
  }

MatchPage(f)
    Field *f;
  { int ok, direction = (int)f->value;
    if ((char *)f->value == CountPatStr)
      {
	ok = ReadStdFld(f);
	if (ok < 0) return;
	if (ok) ok = CompilePat();
	MoveBelowMenu;
	if (ok <= 0)
	  {printf("Bad 'count' string!\r\n"); fflush(stdout); return;}
        direction = 1;
      }
    if (FindMatch(direction)) ShowPage();
  }

GetDVIname(field)
    Field *field;
  { char temp[80]; char *temp0;
    int i, k, firstLoc, lastLoc, postLoc; FILE *f;
    
    if (field)
      {
        i = EditStdFld(Menu);
        if (i < 1) goto error;
      }
    strcpy(temp, "show: ");
    temp0 = temp + strlen(temp);
    strncpy(temp0, DVIname, 70);
    f = fopen(DVIname, "r");
    ClearBelowMenu;
    i = strlen(DVIname);
    if (f <= 0 && strcmp(DVIname+i-4, ".dvi") != 0
     && strcmp(DVIname+i-6, ".press") != 0)
      {
	strcat(temp0+i, ".press");
        f = fopen(temp0, "r");
	if (f <= 0)
	  {
	    strcpy(temp0+i, ".dvi");
            f = fopen(temp0, "r");
	  }
      }
#ifdef DEFAULT_DIR
    if (f <= 0)
      { char temp[90];
        strcpy(temp, DEFAULT_DIR);
	strncat(temp, temp0, 70);
	f = fopen(temp, "r");
	strcpy(DVIname, temp);
      }
#endif DEFAULT_DIR
    if (f <= 0)
      {
	printf("File %.*s not found!\r", i, DVIname);
	goto error;
      }
    SetVgtBanner(stdin, temp);
    if (dataFile > 0) fclose(dataFile);
    if (auxFile > 0) fclose(auxFile);
    dataFile = f;
    Format = DVIFormat;
    if (GetUnsigned1(dataFile) != 247)
      {
/* ??? can a file be both DVI and Press format by this test ???*/
	MagText[CurMagField].fmt[0] = ' ';
	CurMagField = 0;
	MagText[CurMagField].fmt[0] = '*';
 /*	Magnification = DefaultPressMag; */
	FixConv = Magnification * (1<<15);
	Format = PressFormat;
	auxFile = fopen(DVIname, "r");
	if (auxFile <= 0) fatal("Couldn't open auxillary file: %s!", DVIname);
	DocDir();
	GotoPage(1); ShowPage();
 /*	printf("Bad DVI file: first byte isn't start of preamble!\n");*/
	goto error;
      }
    if (GetUnsigned1(dataFile) != IdByte)
      {
	printf("Bad DVI version: identification in byte 1 should be: %d\n",
	      IdByte);
	goto error;
      }
    MoveToByte(14);
    i = GetUnsigned1(dataFile);
    if (i > 0)
      {
        fputc('[', stdout);
	while (--i >= 0) fputc(GetUnsigned1(dataFile), stdout);
	printf("]\n");
      }
    firstLoc = ftell(dataFile);
    fseek(dataFile, -4, 2);
    i = ftell(dataFile);
    DVIlength = i + 4;
    if (DVIlength < 57)
      {
	printf("Bad DVI file: only %d bytes long!\n", DVIlength);
	goto error;
      }
    do
      {
        if (i <= 0)
	  {printf("Bad DVI file: Nothing but <223>-padding!\n"); goto error;}
	fseek(dataFile, i--, 0);
      }
    while ((k = GetUnsigned1(dataFile)) == 223);
    if (k != IdByte)
      {printf("Bad DVI file: Postamble ID byte is: %d!\n", k); goto error;}
    MoveToByte(i - 3);
    postLoc = GetSigned4(dataFile);
    MoveToByte(postLoc); i = GetUnsigned1(dataFile);
    if (i != 248)
      {printf("Bad DVI file: no postamble code!\n"); goto error;}
    lastLoc = GetSigned4(dataFile);
    Numerator = GetSigned4(dataFile);
    Denominator = GetSigned4(dataFile);
    TrueConv = (Numerator/254000.0)*(Resolution/Denominator);
    DVImag = GetSigned4(dataFile) / 1000.0;
    FixConv = TrueConv * Magnification * ConvScale;
    MaxV = GetSigned4(dataFile);
    MaxH = GetSigned4(dataFile);
    MaxStack = GetUnsigned2(dataFile);
    TotalPages = GetUnsigned2(dataFile);

    FreeJunk();

    /* initialize PageStart and Count0 tables */

#ifdef TeX_BOOK
    if (strcmp(DVIname, "/usr/local/doc/texbook.dvi") == 0)
      { PageStart = TeXbookStart; Count0 = TeXbookCount0; }
    else
#endif TeX_BOOK
      {
        PageStart = (long *)(malloc((TotalPages+2)*4));
        Count0 = (long *)(malloc((TotalPages+1)*4));
        for (i = TotalPages; i >= 0; i--) Count0[i] = NullCount;
        for (i = TotalPages; --i >= 0; ) PageStart[i] = -1;
        PageStart[1] = firstLoc;
        PageStart[TotalPages] = lastLoc;
        PageStart[TotalPages + 1] = postLoc;
      }

    do
      {
	i = GetUnsigned1(dataFile);
	if (i >= FntDef1 && i < FntDef1 + 4)
	  {NewFont(FirstPar(i), dataFile); i = NoOp;}
      } while (i == NoOp);
    GotoPage(1); ShowPage();
    return 1;    
  error:
    fflush(stdout); RedrawPad(stdout);
    return 0;
  }

FreeJunk()
  { FontInfo *fnt;
#ifdef TeX_BOOK
    if (PageStart != TeXbookStart)
#endif TeX_BOOK
      {   
	if (PageStart != NULL) free(PageStart);
	if (Count0 != NULL) free(Count0);
	PageStart = NULL; Count0 = NULL;
       }

    /* free FontList */
    for (fnt = FontList; fnt; )
      { FontInfo *next_fnt = fnt->next;
	if (fnt->width0 != NULL) free(fnt->width0 + fnt->minChar);
	if (fnt->fileName != NULL) free(fnt->fileName);
	free(fnt);
	fnt = next_fnt;
      }
    FontList = 0;
  }

fatal(s, a, b)
    char *s;
  {
    MoveBelowMenu;
    printf("\r\nFatal ERROR: ");
    printf(s, a, b);
    fflush(stdout);
    abort();
    Quit();
  }

FontInfo *
NewFont(i)
 /* Allocate FontInfo node, collecting information from the dvi file */
  {
    int dirSize, fileSize;
    register FontInfo *fnt = (FontInfo *)(malloc(sizeof(FontInfo)));
    if (!fnt) fatal("Ran out of memory!");
    fnt->fontNum = i;
    fnt->checkSum = GetSigned4(dataFile);
    fnt->scaleFactor = GetSigned4(dataFile);
    fnt->fontSpace = fnt->scaleFactor / 6;
    fnt->designSize = GetSigned4(dataFile) / 65536.0;
    dirSize = GetUnsigned1(dataFile);
    fileSize = GetUnsigned1(dataFile);
    fnt->fileName = (char *)(malloc(dirSize + fileSize + 1));
    if (!fnt->fileName) fatal("Ran out of memory!");
    fread(fnt->fileName, dirSize, 1, dataFile);
    fnt->fontName = fnt->fileName + dirSize;
    fread(fnt->fontName, fileSize, 1, dataFile);
    fnt->fontName[fileSize] = 0;
  /*printf("\r\nFont %d: scale: %x, design: %gpt [%s]", i, fnt->scaleFactor,
       fnt->designSize, fnt->fileName);
   */
    fnt->width0 = NULL;
    fnt->internalFontMag = -1;
    fnt->next = FontList;
    FontList = fnt;
    return fnt;
  }

FontInfo *
SelectFont(i)
  { register FontInfo *fnt; long magMagic;
    for (fnt = FontList; ; fnt = fnt->next)
      {
        if (!fnt) fatal("Selecting an undefined font!");
	if (fnt->fontNum == i) break;
      }
    CurFont = fnt;
    if (fnt->width0 == NULL && fnt->fileName)
      { /* load TFM file */
	unsigned short hdrLen, widthLen; short nChars, i; 
#define tempSize 100
	long z, alpha, beta, *widths; char temp[tempSize];
	FILE *TFMfile;
	if (fnt->fileName < fnt->fontName)
	    TFMfile = fopen(fnt->fileName, "r");
	else
	  {
	    strncpy(temp, DefaultTFMdirectory, tempSize);
	    strncat(temp, fnt->fontName, tempSize);
	    strncat(temp, ".tfm", tempSize);
	    TFMfile = fopen(temp, "r");
	    if (TFMfile <= 0)
	      {
		strncpy(temp, AlternateTFMdirectory, tempSize);
		strncat(temp, fnt->fontName, tempSize);
		TFMfile = fopen(temp, "r");
	      }
	  }
	if (TFMfile <= 0)
	  {
	    sprintf(temp, "Could not find TFM file: %s!", fnt->fileName);
	    fatal(temp);
	  }
	fgetc(TFMfile); fgetc(TFMfile);
	hdrLen = GetUnsigned2(TFMfile);
	fnt->minChar = GetUnsigned2(TFMfile);
	fnt->maxChar = GetUnsigned2(TFMfile);
	if (fnt->maxChar < fnt->minChar) fnt->minChar = fnt->maxChar + 1;
	widthLen = GetUnsigned2(TFMfile);
     /* printf("min:%d,max:%d,hdrLen:%d,widthLen:%d.",fnt->minChar,
             fnt->maxChar,hdrLen,widthLen);
      */
	if (fnt->checkSum != 0)
	  { /* check checksum */
	    long TFMcheckSum;
	    fseek(TFMfile, 24, 0);
	    TFMcheckSum = GetSigned4(TFMfile);
	    if (TFMcheckSum != fnt->checkSum && TFMcheckSum)
	      {
		printf("Warning: checksum %d in TFM file %s\r\n",
		      TFMcheckSum, fnt->fileName);
		printf(" does not agree with checksum %d in DVI file!\r\n",
		    fnt->checkSum);
		fflush(stdout);
	      }
	  }

	fseek(TFMfile, (6 + hdrLen) * 4, 0);
	nChars = fnt->maxChar - fnt->minChar + 1;
	fnt->width0 = (unsigned long *)(malloc(nChars*4));
	widths = (int *)(malloc(widthLen*4));
	if (!fnt->width0 || !widths) fatal("Ran out of memory!");
	for (i = 0; i < nChars; i++) {fnt->width0[i] = GetSigned4(TFMfile);}

	/* compute z, alpha, beta, which are used to prevent overflow */
	z = fnt->scaleFactor;
	alpha = z << 4; beta = 4;
	while (z >= 040000000) {z >>= 1; beta--;}
	for (i = 0; i < widthLen; i++)
	  { unsigned char b[4]; register long wi;
	    fread(b, 4, 1, TFMfile);
	    wi = (((((b[3]*z) >> 8) + (b[2]*z)) >> 8) + (b[1]*z)) >> beta;
	    if (b[0] > 0)
	      if (b[0] < 255) fatal("TFM file contains garbage!");
	      else wi -= alpha;
	    widths[i] = wi;
	  }
	for (i = nChars; --i >= 0; )
	  { unsigned int wi = fnt->width0[i] >> 24;
	    if (wi >=  widthLen)
		printf("Too big a width index: %d for %d!", wi,i);
	    fnt->width0[i] = ((wi != 0) ? widths[wi] : InvalidWidth);
	  }
	fnt->width0 -= fnt->minChar;
	free(widths);
	fclose(TFMfile);
      }
    
    magMagic = (int)
	((fnt->scaleFactor/65536.0)*Resolution*Magnification
	    /fnt->designSize + 0.5);
    if (fnt->internalFontMag != magMagic)
      {
	fnt->internalFontMag = magMagic;
	LoadFont(fnt);
      }
    return fnt;
  }

/* table of substitutions for fonts in Press files */
typedef struct
  { char *old, *new;
  } FontMapEntry;
static FontMapEntry ScribeFonts[] =
  { /* should probably depend on magnification */
#if 0
    {"SAIL10",		"Ascii12"},
    {"GACHA10B",	"cmr12"},
    {"HIPPO10",		"Greek12"},
    {"HELVETICA10",	"Helvetica12"},
    {"HELVETICA10B",	"Helvetica12B"},
    {"HELVETICA10I",	"Helvetica12I"},
    {"HELVETICA14B",	"Helvetica18B"},
#endif
    {NULL,		NULL}
  };
double fabs();
LoadFont(fnt)
    register FontInfo *fnt;
  /* load internal VGTS font */
  { char fontName[50]; char ext[2]; register int i, len;
/* #define FONTFILE "[public]/usr/sun/lib/libsfonts.a" */
#define FONTFILE NULL
    sprintf(fontName, "%s.%d", fnt->fontName, fnt->internalFontMag);
    fnt->internalFont = i = DefineFont(fontName, FONTFILE);
    if (i >= 0 && i < 0xFF)
	return;
 /* Try loading a non-standard font*/
    strcpy(fontName, fnt->fontName);
    len = strlen(fontName);
    i = fontName[len-1] & 0137 /* to ignore case */;
    if (i == 'I' || i == 'B')
      { --len; ext[0] = i; ext[1] = 0;}
    else ext[0] = 0;
    i = fontName[len-1];
    if (fnt->designSize < 0.001 && (i < '0' || i > '9'))
      {
	if (Format == PressFormat
	 && fabs(Magnification - DefaultPressMag) < 0.01)
	  { register FontMapEntry *p = ScribeFonts;
	    sprintf(fontName+len, "%d%s",
		(int)(fnt->designSize+0.5), ext);
	    for (; p->old != NULL; p++)
		if (strcmp(p->old, fontName))
		  {
		    fnt->internalFont = i = DefineFont(p->new, FONTFILE);
		    if (i >= 0 && i < 0xFF) return;
		  }
	  }    
	sprintf(fontName+len, "%d%s",
	    (int)(fnt->designSize*Magnification+0.5), ext);
      }
    fnt->internalFont = i = DefineFont(fontName, FONTFILE);
    if (i < 0 || i >= 0xFF)
        printf(
    "Failed to load font:%.*s (factor: %gpt, design size: %gpt => %dppi)!\r\n",
	    len, fontName,
	    fnt->scaleFactor/65536.0, fnt->designSize, fnt->internalFontMag);
  }

Quit()
  {
    DeleteVgt(vgt, 1);
    DeleteSDF(sdf);
    ClearBelowMenu;
    exit(-1);
  }

#ifdef TeX_BOOK
DumpTables()
/* This provides a method for saving an index for a big file. */
  { char name[30], file[30]; FILE *fp; int i;
strcpy(name, "TeXbook");
    printf("Dumping page tables, with name: (^G to abort): ");
    if (getchar() == CTRL('G')) return 0;
    sprintf(file, "%s.h", name);
    fp = fopen(file, "w");
    if (fp <= NULL) {printf("Couldn't create %s!\r\n", file); return 0;}
    fprintf(fp, "long %sStart[] = {\n", name);
    for (i = 0; i < TotalPages + 2; i++) fprintf(fp, "%d,", PageStart[i]);
    fprintf(fp, "\n};\nlong %sCount0[] = {\n", name);
    for (i = 0; i < TotalPages + 1; i++) fprintf(fp, "%d,", Count0[i]);
    fprintf(fp, "};\n");
    fclose(fp);
  }
#endif TeX_BOOK

/* File parsing function.
   These should be portable to both little-endian and big-endian machines.
 */

MoveToByte(n)
  {
    fseek(dataFile, n, 0);
  }

CurLoc()
  {
    return ftell(dataFile);
  }

/* main VGTS manipulating routines */

int stringCount;

#ifdef PROFILE
GetMilliseconds()
  { long ticks, secs = GetTime(&ticks);
    return 1000*secs + 10*ticks;
  }
#endif PROFILE

ShowPage()
  {
#ifdef PROFILE
    mTime = GetMilliseconds(); nItems = 0;
    if (_Profile > 1) _Profile = 3;
#endif PROFILE
    stringCount = 0;
    xPos = 0; yPos = 0;
    EditSymbol(sdf, TopItem);
    DeleteItem(sdf, CallItem);
    EndSymbol(sdf, TopItem, vgt);
    DeleteSymbol(sdf, PageItem);
    
    DefineSymbol(sdf, PageItem);
    switch (Format)
      {
	case DVIFormat: DoPage(dataFile); break;
	case PressFormat: TranslatePage(CurPage); break;
      }
    
/* ??? now that eop has been read, use it to set PageTable */
    EndSymbol(sdf, PageItem, 0);
    EditSymbol(sdf, TopItem);
    AddCall(sdf, CallItem, xPos, yPos, PageItem);
    EndSymbol(sdf, TopItem, vgt);
    /*printf("[Displayed %d strings.]\n", stringCount);*/
  }

PutString(h, v, fnt, str)
    char *str; FontInfo *fnt;
  { int fontNum = fnt->internalFont;
    if (fontNum >= 0xFF) return;
    stringCount++;
/*    EditSymbol(sdf, PageItem);*/
#ifdef PROFILE
    nItems++;
    if (_Profile < 2)
#endif PROFILE
    AddItem(sdf, 0, h, h, -v, -v, fontNum, SDF_TEXT, str);
/*    EndSymbol(sdf, PageItem, vgt);*/
  }

Rectangle(x, y, width, height)	/* display a black rectangle at (x, y) */
  { int type;
    if (height <= 0 || width <= 0) return;
    if (height==1) type = SDF_HORIZONTAL_LINE;
    else if (width==1) type = SDF_VERTICAL_LINE;
    else type = SDF_FILLED_RECTANGLE;
/*    EditSymbol(sdf, PageItem);*/
#ifdef PROFILE
    nItems++;
    if (_Profile < 2)
#endif PROFILE
    AddItem(sdf, 0, x, x + width - 1, -y, height - 1 - y, BLACK, type, 0);
/*    EndSymbol(sdf, PageItem, vgt);*/
  }

OutVector(xmin,ymin,xmax,ymax,pensize)
    double pensize;	/* in points - currently ignored */
  /* draw line from (xmin,ymin) to (xmax,ymax) */
  {
#ifdef PROFILE
    nItems++;
    if (_Profile < 2)
#endif PROFILE
  AddItem(sdf,0,xmin,xmax,-ymin,-ymax,0,SDF_GENERAL_LINE,0);
  }
