/* press/pressformat.h
 *
 * last edited by shore on Shasta.Stanford : Thu May 12 23:00:16 1983
 *
 * Xerox Press File Format definitions
 *
 *	see [IFS]<PrintingDocs>PressFormat.Press
 *
 */

#ifndef PRESSFORMAT
#define PRESSFORMAT

/* Nice constants to have around */
#define BytesPerRecord	512

#define MicasPerInch	2540
#define PointsPerInch	72
#define MicasPerPoint	(2540.0/72.27)
#define PointsPerMica	(72.27/2540.0)


/* Document Directory */
#define PressPassword		27183
#define SwappedPressPassword	((PressPassword>>8)|((PressPassword&0377)<<8))

/* Part Directory */
#define PagePart	0
#define FontPart	1
#define PDEntrySize	8

/* Entity Info and Entity List Commands */
#define EntityHeadSize	24

#define ShowShort	0000
#define SkipShort	0040
#define ShowSkip	0100
#define SetSpXShort	0140
#define SetSpYShort	0150
#define Font		0160
#define Available	0200
#define SkipImmediate	0353
#define Alternative	0354
#define OnlyOnCopy	0355
#define SetX		0356
#define SetY		0357
#define ShowCh		0360
#define SkipCh		0361
#define SkipControl	0362
#define ShowImmediate	0363
#define SpaceX		0364
#define SpaceY		0365
#define ResetSpace	0366
#define Space		0367
#define SetBrightness	0370
#define SetHue		0371
#define SetSaturation	0372
#define ShowObject	0373
#define ShowDots	0374
#define ShowOpaque	0375
#define ShowRectangle	0376
#define Nop		0377

/* Data List Commands */
    /*  Objects  */
#define Moveto		0
#define Drawto		1
#define Drawcurve	2

    /*  Dots  */
#define SetCoding	1
#define SetMode		2

#define SetWindow	1
#define SetSize		2
#define DotsFollow	3
#define DotsFromFile	4
#define DotsPressFile	5
#define SetSamplingPrps	6

#define SSPinput	0
#define SSPoutput	1
#define SSPscreen	2

#endif PRESSFORMAT
