/*
 *                     RCS utilities
 */
 static char rcsid[]=
 "$Header: rcsutil.c,v 3.10 86/01/21 22:03:59 mann Exp $ Purdue CS";
/*****************************************************************************
 *****************************************************************************
 *
 * Copyright (C) 1982 by Walter F. Tichy
 *                       Purdue University
 *                       Computer Science Department
 *                       West Lafayette, IN 47907
 *
 * All rights reserved. No part of this software may be sold or distributed
 * in any form or by any means without the prior written permission of the
 * author.
 * Report problems and direct all inquiries to Tichy@purdue (ARPA net).
 */



/* $Log:	rcsutil.c,v $
 * Revision 3.10  86/01/21  22:03:59  mann
 * small bugfix in WorkPerms
 * 
 * Revision 3.9  86/01/21  20:17:40  mann
 * Ported to V
 * 
 * Revision 3.8  83/02/15  15:41:49  wft
 * *** empty log message ***
 * 
 * Revision 3.8  83/02/15  15:41:49  wft
 * Added routine fastcopy() to copy remainder of a file in blocks.
 * 
 * Revision 3.7  82/12/24  15:25:19  wft
 * added catchints(), ignoreints() for catching and ingnoring interrupts;
 * fixed catchsig().
 *
 * Revision 3.6  82/12/08  21:52:05  wft
 * Using DATEFORM to format dates.
 *
 * Revision 3.5  82/12/04  18:20:49  wft
 * Replaced SNOOPDIR with SNOOPFILE; changed addlock() to update
 * lockedby-field.
 *
 * Revision 3.4  82/12/03  17:17:43  wft
 * Added check to addlock() ensuring only one lock per person.
 * Addlock also returns a pointer to the lock created. Deleted fancydate().
 *
 * Revision 3.3  82/11/27  12:24:37  wft
 * moved rmsema(), trysema(), trydiraccess(), getfullRCSname() to rcsfnms.c.
 * Introduced macro SNOOP so that snoop can be placed in directory other than
 * TARGETDIR. Changed %02d to %.2d for compatibility reasons.
 *
 * Revision 3.2  82/10/18  21:15:11  wft
 * added function getfullRCSname().
 *
 * Revision 3.1  82/10/13  16:17:37  wft
 * Cleanup message is now suppressed in quiet mode.
 */




#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include "rcsbase.h"

extern char * malloc();
extern FILE * finptr;
extern char * getfullRCSname();

struct hshentry dummy;         /* dummy delta for reservations  */


struct lock * addlock(delta,who)
struct hshentry * delta; char * who;
/* Given a delta, addlock checks whether
 * the delta is locked by somebody other than who.
 * If so, an error message is printed, and false returned.
 * If the delta is not reserved at all, a lock for it is added,
 * and a pointer for the lock returned.
 */
{
        struct lock * next;

        next=Locks;
        while (next!=nil) {
                if (cmpnum(delta->num,next->delta->num)==0) {
                        if (strcmp(who,next->login)==0)
                                return next;
                                /* lock exists already */
                        else {
                                error("revision %s already locked by %s",
                                      delta->num, next->login);
                                return false;
                        }
                } else {
                        if (strcmp(who,next->login)==0) {
                                error("you already locked %s; only one lock allowed per person.",
                                       next->delta->num);
                                return false;
                        } else {
                                next=next->nextlock;
                        }
                }
        }
        /* not found; set up new lockblock */
        next= (struct lock *) malloc(sizeof (struct lock));
        delta->lockedby=next->login=who;
        next->delta= delta;
        next->nextlock=Locks;
        Locks=next;
        return next;
}



int addsymbol(delta,name,rebind)
struct hshentry * delta; char * name; int rebind;
/* Function: adds a new symbolic name and associates it with node delta.
 * If name already exists and rebind is true, the name is associated
 * with the new delta; otherwise, an error message is printed and
 * false returned. Returns true it successful.
 */
{       register struct assoc * next;
        next=Symbols;
        while (next!=nil) {
                if (strcmp(name,next->symbol)==0) {
                        if (rebind) {
                                next->delta=delta;
                                return true;
                        } else {
                                error("symbolic name %s already bound to %s",
                                        name,next->delta->num);
                                return false;
                        }
                } else  next = next->nextassoc;
        }
        /* not found; insert new pair. */
        next = (struct assoc *) malloc(sizeof(struct assoc));
        next->symbol=name;
        next->delta=delta;
        next->nextassoc=Symbols;
        Symbols = next;
        return true;
}




int checkaccesslist(who)
char * who;
/* function: Returns true if who is the superuser, the owner of the
 * file, the access list is empty, or who is on the access list.
 * Prints an error message and returns false otherwise.
 */
{
        register struct access * next;
        struct stat statbuf;

        if ((AccessList==nil) || (strcmp(who,"root")==0))
                return true;

        next=AccessList;
        do {
                if (strcmp(who,next->login)==0)
                        return true;
                next=next->nextaccess;
        } while (next!=nil);

#ifdef Vsystem
	/* %%% ignore this case for now */
#else
        fstat(fileno(finptr),&statbuf);  /* get owner of file */
        if (getuid() == statbuf.st_uid) return true;
#endif Vsystem

        error("User %s not on the access list",who);
        return false;
}

#ifdef Vsystem
ProcessId WorkPid;
int ReturnValue;
int RootStackSize = 2000;

/* We arrange to be able to catch ^C and clean up
 *  by having all the work done in a son of the team root
 *  process, with the son also set to be the break process.
 *  Thus when the son exits the root regains control and
 *  can clean up if necessary.
 */
#undef main

main(argc, argv)
  int argc;
  char **argv;
  {
    int WorkProc();
    MsgStruct msg;
    
    DefineTempArea();	/* define [tmp] */

    WorkPid = Create(3, WorkProc, 4000);
    Ready(WorkPid, 2, argc, argv);
    ReceiveSpecific(&msg, WorkPid);

    if (WorkPid == 0)
        exit(ReturnValue);
    else
      {
        diagnose("\nRCS: cleaning up\n");
        cleanup();
        exit(1);
      }
  }

WorkProc(argc, argv)
  int argc;
  char **argv;
  {
    ReturnValue = main_(argc, argv);
    WorkPid = 0;	/* indicate we finished up okay */
  }

#else	/* UNIX */

void catchsig(sig)
{
	signal(sig, SIG_IGN);
        diagnose("\nRCS: cleaning up\n");
        cleanup();
        exit(1);
}
#endif Vsystem

void catchints()
{
#ifdef Vsystem
	if (Interactive(stdin)) SetBreakProcess(stdin, WorkPid);
#else
        signal(SIGINT,catchsig); signal(SIGHUP,catchsig);
        signal(SIGQUIT,catchsig); signal(SIGPIPE,catchsig);
	signal(SIGTERM,catchsig);
#endif Vsystem
}

void ignoreints()
{
#ifdef Vsystem
	if (Interactive(stdin)) SetBreakProcess(stdin, 0);
#else
        signal(SIGINT,SIG_IGN); signal(SIGHUP,SIG_IGN);
        signal(SIGQUIT,SIG_IGN); signal(SIGPIPE,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
#endif Vsystem
}


fastcopy(inf,outf)
FILE * inf, * outf;
#ifdef Vsystem
/* Function: copies the remainder of file inf to outf. Tries to go
 * fast without being too dirty.
 */
{	register char *buffer;
	register SystemCode r;
	register int bytes, blocksize, c;

#ifdef BRAVE
	while (!BufferEmpty(inf)) putc(getc(inf), outf);
	blocksize = BlockSize(inf);
	SeekBlock(BytePosition(inf)/blocksize);	/* normalize block posn */
	buffer = malloc(BlockSize(inf));
	do
	  {
	    bytes = Read(inf, buffer, blocksize);
	    fwrite(buffer, blocksize, 1, outf);
	  }
	while ( (r = Eof(outf)) == OK && (r = FileException(inf)) == OK );

	free(buffer);
	if (r != END_OF_FILE)
	    faterror("i/o error in fastcopy");
#else
	while ( (c = getc(inf)) != EOF ) putc(c, outf);
#endif BRAVE
}
#else
/* Function: copies the remainder of file inf to outf. First copies the
 * rest that is in the IO-buffer of inf character by character, and then
 * copies the remainder in blocks.
 */
{       char buf[BUFSIZ];
        register int rcount, wcount;

        /* write the rest of the buffer to outf */
        while ((--inf->_cnt)>=0) {
                putc(*inf->_ptr++&0377,outf);
        }
        fflush(outf);

        /*now read the rest of the file in blocks*/
        while ((rcount=read(fileno(inf),buf,BUFSIZ))>0) {
                wcount=write(fileno(outf),buf,rcount);
                if (wcount!=rcount) {
                    faterror("write error");
                }
        }
}
#endif





#ifdef SNOOPFILE

#include "time.h"
extern struct tm* localtime();
extern long time();

logcommand(commandname,delta, sequence,login)
char* commandname; struct hshentry * delta, * sequence[];char * login;
/* Function: start a process to write the file that
 * logs the RCS command.
 * Each line in the log file contains the following information:
 * operation, revision(r), backward deltas applied(b), forward deltas applied(f),
 * total deltas present(t), creation date of delta(d), date of operation(o),
 * login of caller, full path of RCS file
 */
{
        char command[200];
        char curdate[datelength];
        register int i, backward, forward;
        long clock;
        struct tm * tm;

        clock=time(0);
        tm=localtime(&clock);

        sprintf(curdate,DATEFORM,
                tm->tm_year, tm->tm_mon+1, tm->tm_mday,
                tm->tm_hour, tm->tm_min, tm->tm_sec);

        i= backward=forward=0;
        while(sequence[i]!=nil) {  /* count deltas to be applied*/
        if (countnumflds(sequence[i]->num) == 2)
                backward++;  /* reverse delta */
        else    forward++;   /* branch delta  */
        i++;
        }
        sprintf(command,"%s \"%s %10sr %3db %3df %3dt %sc %so %s %s\" &\n",
                SNOOP, commandname,delta->num,backward,forward,TotalDeltas,delta->date,
                curdate,login,getfullRCSname());
        system(command);
}
#endif


#ifdef Vsystem
#include <Vio.h>

#ifndef R_OK
#define R_OK 4
#define W_OK 2
#define X_OK 1
#define F_OK 0
#endif R_OK

access(name, mode)
  {
    File *fad;
    SystemCode error;
    int vmode, ret;

    vmode = (mode & W_OK) ? FAPPEND : FREAD;
    
    fad = Open(name, vmode, &error);
    if (error != OK)
      {
        if (mode == F_OK && error == NO_PERMISSION)
	  return 0;
	else
	  return -1;
      }

    ret = 0;

    if ( (mode & (R_OK|X_OK)) && !(fad->type & READABLE) ) ret = -1;
    if ( (mode & W_OK) && !(fad->type & WRITEABLE) ) ret = -1;

    Close(fad);
    return ret;
  }


/*
 * Copy permissions from indesc to outdesc
 */
SystemCode CopyPerms(outdesc, indesc)
  register ArbitraryDescriptor *indesc, *outdesc;
  {
    if (indesc->e.descriptortype != outdesc->e.descriptortype)
      return BAD_ARGS;

    switch (indesc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  if (outdesc->f.perms == indesc->f.perms) return OK;
	  outdesc->f.perms = indesc->f.perms;
	  break;

	case UNIXFILE_DESCRIPTOR:
	  if (outdesc->u.st_mode == indesc->u.st_mode) return OK;
	  outdesc->u.st_mode = indesc->u.st_mode;
	  break;

	default:
	  return BAD_ARGS;
      }

    return OK;
  }


/* Modify perms in desc to turn off all write permission */
#include <Vstorage.h>
SystemCode NoWrite(desc)
  register ArbitraryDescriptor *desc;
  {
    switch (desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  desc->f.perms &= ~(SS_WRITE + (SS_WRITE<<5) + (SS_WRITE<<10));
	  break;

	case UNIXFILE_DESCRIPTOR:
	  desc->u.st_mode &= ~0222;
	  break;

	default:
	  return BAD_ARGS;
      }
    return OK;
  }


/* Modify perms in desc to be appropriate for a working file */
SystemCode WorkPerms(desc, owneraccess)
  register ArbitraryDescriptor *desc;
  {
    switch (desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  desc->f.perms &= ~(SS_WRITE + (SS_WRITE<<5) + (SS_WRITE<<10));
	  if (owneraccess) desc->f.perms |= SS_WRITE + SS_READ;
	  break;

	case UNIXFILE_DESCRIPTOR:
	  desc->u.st_mode &= ~0222;
	  if (owneraccess) desc->u.st_mode |= 0600;
	  break;

	default:
	  return BAD_ARGS;
      }
    return OK;
  }


/* Return 1 if permissions allow writing, 0 otherwise */
#include <Vstorage.h>
IsWriteable(desc)
  register ArbitraryDescriptor *desc;
  {
    switch (desc->e.descriptortype)
      {
	case FILE_DESCRIPTOR:
	  return (desc->f.perms & (SS_WRITE + (SS_WRITE<<5) +
			(SS_WRITE<<10))) != 0;

	case UNIXFILE_DESCRIPTOR:
	  return (desc->u.st_mode & 0222) != 0;

	default:
	  return BAD_ARGS;
      }
  }

#endif
