#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vethernet.h>

/* Exports:	QEthernet().	*/


QEthernet()
    /* Prints the information found by querying the Ethernet.
     * Some of this code was copied from the OpenConfigFile library routine.
     */
  {
    Message msg;
    register NameRequest *qerequest = (NameRequest *) msg;
    register QueryEnetReply *qereply = (QueryEnetReply *) msg;

    printf("Querying Ethernet:\n");

    qerequest->requestcode = NQUERY_FILE;
    qerequest->nameptr = "ethernet";
    qerequest->namelength = sizeof("ethernet");
    qerequest->nameindex = 0;
    qerequest->namecontextid = DEFAULT_CONTEXT;

    Send(qerequest, GetPid(DEVICE_SERVER, LOCAL_PID));

    if (qereply->NetworkType == ENET_TYPE_3MBIT)
	printf("    3Mbps Ethernet - address = %02x\n",
	       qereply->HostAddress.e3);
    else /* qereply->NetworkType == ENET_TYPE_10MBIT */
	printf("    10Mbps Ethernet - address = %04x.%04x.%04x\n",
	       qereply->HostAddress.e10.addrhigh, 
	       qereply->HostAddress.e10.addrmid,
	       qereply->HostAddress.e10.addrlow);
    printf("    %d valid packets.\n", qereply->NumValidPackets);
    printf("    %d collisions.\n", qereply->NumCollisions);
    printf("    %d overflows.\n", qereply->NumOverflows);
    printf("    %d CRC errors.\n", qereply->NumCRCErrors);
    printf("    %d sync. errors.\n", qereply->NumSyncErrors);
    printf("    %d timeouts.\n", qereply->NumTimeOuts);
  }
