/* pc68/pcvax - front end for MC68000/VAX Pascal Compiler
 * Hacked up from cc68 and old pc68,
 * which again was hacked up from cc, cc68 and pc by Jim Archer.
 * Version for MC68000 by Per Bothner, version for VAX by Greg Boyd
 * Bug fixes by Per Bothner, April 1983.
 * Added supprt for experimental Vkernel with -vxV switch. PB, July 1984.
 */

#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#ifndef Vsystem
#include <signal.h>
#endif Vsystem

#define BSD42 1

#ifdef BSD42
#include <sys/dir.h>
#else
#include <dir.h>
#define	MAXNAMLEN DIRSIZ
#endif

#ifdef Vsystem
#define BUFSIZ 512

extern char *mktemp();
extern SystemCode GetContextId();
/* #define DefaultTmpDirectory "[mem]" */
#define DefaultTmpDirectory "/tmp/"
#define AltDefaultTmpDirectory "/tmp/"
char TmpDirectory[256];
#endif Vsystem

#define UNIMPLEMENTED(x) fprintf(stderr, "%s: not yet implemented '%s'\n",compiler,x)

#ifdef isvax
char	*upas = "/m2/star/upas/upasvax";    	/* ucode generator (from source) */
char	*ufort = "ufort";
char	*ugen = "/m2/star/pcvax/ugvax";		/* ugen */
char	*uopt = "/usr/sun/src/cmd/pc68/uopt";		/* ucode-to-ucode optimizer */
char	*as = "as";		/* standard assembler */
char	*ld = "ld";		/* standard loader */

char    *compiler = "pcvax";	/* name of compiler */
char 	*help = "/m2/star/pcvax/run/how_pcvax";
char	*plib = "-lplib";
#endif
#ifdef Vsystem
char *BinDirectory = "[bin]";
#else Vsystem
char *BinDirectory = "";
#endif Vsystem
#ifdef is68
char	*upas = "upas68";   /* ucode generator (from source) */
char	*ufort = "ufort68"; /* Fortran front-end */
char	*ugen = "ugen68";	/* ugen: ucode to assembler */
char	*uopt = "uopt68";	/* ucode-to-ucode optimizer */
char	*as = "as68";		/* standard assembler */
char	*ld = "ld68";		/* standard loader */
char	*dl = "/usr/local/bin/dl68";	    /* MACSBUG downloader */
char	*rev = "rev68";    /* Pratt's .b 68k reformatter */

char    *compiler = "pc68";	/* name of compiler */
char 	*help = "/usr/sun/crc/cmd/pc68/how_pc68";
char	*plib = "-lpcfc";
#define crt0_default "/usr/sun/lib/crtsun.b"
char	*crt0 = NULL; /* run-time start-up */
#endif


char	*suf;			/* temp for suffixes */
#ifdef is68
char    *binsufptr = "b";		/* suffix for binary files */
char    binsuf = 'b';
char	ucdsuf = 'u';
#endif
#ifdef isvax
char    *binsufptr = "o";		/* suffix for binary files */
char    binsuf = 'o';
#ifdef usebcode
char	ucdsuf = 'b';
#else
char 	ucdsuf = 'u';
#endif
#endif

char    optsuf = 'z';		/* suffix uopt puts on output ucode output */
char    optsuf2 = 'l';		/* suffix uopt puts on garbage output */
char	tmp_u[30];		/* big enough for /tmp/ptm%05.5d */
char	*tmp1, *tmp_as, *tmp_z;
int	free_u=0, free1=0, free_as=0, free_z=0; /*if tmpXX must be unlinked */
char	*upassrc, *uoptsrc,*assource,*ugensrc,*loadsrc;
char	*infile=0, *outfile=0;
char	*savestr(), *strspl(), *setsuf(), *setlongsuf();
char	*type;
int	idexit();
char	**av, **srclist, **loaderfiles, **loaderflags, **undefinedlist, **plist, **ugenswitch, 
	**upasswitch;
int	cflag=0, 	/* skip link editing, result is filename.b */
	eflag=0, 	/* error flag; records errors */
	gflag=0, 	/* 1 -> debugging on (not implemented) */
#ifdef isvax
	jflag=0,	/* -J switch to pass to as */
#endif
	oflag=0, 	/* optimization flag; 1 -> invoke o68 */
	pflag=0,	/* 1 -> don't delete temporary files */
	Rflag=0,	/* 1 -> ld68 preserves relocation bits */
	sflag=0,  	/* 1 -> skip assembly, result is filename.s */
	Vflag=0,	/* print exec() trace */
	noxflag=0,	/* 1 -> -x flag off -> output local symbols */
#ifdef is68
	dflag=0,	/* 1 -> apply dl68 to yield filename.d */
	lflag=0,	/* 1 -> as68 generates listing */
	rflag=0,	/* 1 -> apply rev68 to yield filename.r; -1 == don't */
	Vkernel=0,	/* 1 -> V kernel environment; 2 -> xV */
	proflag=0;	/* profile flag: generate jbsr mcount for each fctn */
#endif
	uflag = 0;	/* generate ucode only. (only invoke upas)*/
#ifdef debug
	tflag = 0;	/* for debugging, must be set to actually issue sys calls*/
#endif
int	
	exfail;
#ifdef is68
char	*version=0,	/* version: -vm, -v1, -v2, ... */
	*Torg=0,	/* Text origin */
	*entrypt=0;	/* entry point */
#endif
#ifdef isvax
char	*entrypt = "_main";	/* standard entrypt created by ugvax */
#endif

int	nc=0, 	/* no of programs for upas */
	nl=0, 	/* no of .b inputs for ld (including libraries) */
	nm=0,	/* no of modules (excluding libraries) */
	nf=0,	/* no of flags for ld68 */
	nu=0,	/* no of files of unknown type */
	np=0, 	/* no of args for upas */
	na=0;	/* no of args to each callsys */
	nusw=0;	/* number of switches to pass on to upas */
	ngsw=0;	/* number of switches to pass on to ugen */

#define	cunlink(f) \
	if (f&&!pflag) {if (Vflag) fprintf(stderr,"[rm %s]\n",f); unlink(f);}
#define unlinktmp(x) if (free/**/x) { free/**/x = 0; \
	if (Vflag) fprintf(stderr,"[rm %s]\n", tmp/**/x); unlink(tmp/**/x);}

main(argc, argv)
	char **argv;
{
	char *t;
	int i, j, jj, c;
#ifdef Vsystem
	File *fad;
	int t1, t2, cl1, cl2, tsecs, ttenths;
	ContextPair context;

	t1 = GetTime(&cl1);
#endif Vsystem

#ifndef Vsystem
    /*  make sure there is something to do */
        if (argc <= 1) 
        {   execl("/usr/ucb/more", "oops", help);
	    exit(1);
        }
#endif

    /*  give an 'in progress' warning message, detailing the limits
	of the compiler  */
#ifdef isvax
	fprintf(stderr,"\n\nPCVAX : in-progress Pascal compiler for the VAX.\n");
	fprintf(stderr,"Report any problems to Greg Boyd (boyd@shasta).\n");
#endif

	/* ld currently adds upto 5 args; 20 is room to spare */
	/* [Does this apply to ld68?  - pratt] */
	av = (char **)calloc(argc+20, sizeof (char **));
	srclist = (char **)calloc(argc, sizeof (char **));
	loaderfiles = (char **)calloc(argc, sizeof (char **));
	loaderflags = (char **)calloc(argc, sizeof (char **));
	undefinedlist = (char **)calloc(argc, sizeof (char **));
	plist = (char **)calloc(argc, sizeof (char **));
	upasswitch = (char **)calloc(argc, sizeof (char **));
#ifdef isvax
	ugenswitch = (char **)calloc(argc, sizeof (char **));
#endif
	for (i = 1; i < argc; i++) {
		if (*argv[i] == '-') switch (argv[i][1]) {

		case '-':	/* negate some default */
			switch(argv[i][2]) 
			  {
				case 'r':
					rflag = -1;
					break;
				case 'x':
					noxflag++;
					break;
		    	  }
			break;

		case 'S':
			sflag++;
			cflag++;
			break;

		case 'e':
			if (++i < argc)
				entrypt = argv[i];
			break;
		case 'o':
			if (++i < argc) {
				outfile = argv[i];
				switch (getsuf(outfile)) {

				case 'p': case 'f':
					error("-o would overwrite %s",
					    outfile);
					exit(8);
				}
			}
			break;
#ifdef is68
		case 'T':
			if (++i < argc) 
				Torg = argv[i];
			break;
#endif
		case 'u':
			if (++i < argc) {
				loaderfiles[nl++] = "-u";
				loaderfiles[nl++] = argv[i];
			}
			break;
		case 'W':
			oflag++;
			break;
#ifdef debug
		case 't':
			tflag++;
			break;
#endif
		case 'p':
			UNIMPLEMENTED("- p");
			break;
		case 'O':
			oflag++;
			break;
		case 'g':
			UNIMPLEMENTED("- g");
			break;
		case 's':
			UNIMPLEMENTED("- s");
			break;
		case 'w':
			UNIMPLEMENTED("- w");
			break;
#ifdef is68
		case 'L':			/* WIN */
			lflag++;
			break;
#endif
		case 'P':
			pflag++;
			plist[np++] = argv[i];
			break;
		case 'c':
			cflag++;
			break;
#ifdef is68
		case 'd':
			dflag++;
			break;
		case 'r':
			rflag=1;
			break;
#endif
		case 'R':
			Rflag++;
			break;

#ifdef is68
		case 'l':
			loaderfiles[nl++] = argv[i];/* NOT loaderflags, order matters! */
			break;
		case 'v':
			version = argv[i];
			break;
		case 'i':
			crt0 = argv[i]+2;
			break;
#endif
		case 'V':	/* trace exec() calls */
			Vflag++;
			break;
		case 'U':
			uflag++;
			cflag++;
			break;
#ifdef isvax
		case 'J':	/* 'use long jumps always' flag should
				    be passed to as */
			jflag++;
			break;
#endif
		default:
			loaderflags[nf++] = argv[i];
			break;
		}
		else if (argv[i][0]=='#')
		{	argv[i][0]='-';
			upasswitch[nusw++] = argv[i];
		}
#ifdef isvax
		else if (argv[i][0]=='%')
		{	argv[i][0] = '-';
			ugenswitch[ngsw++]=argv[i];
		}
#endif
		else {			/* not a flag */
			t = argv[i];
			c = getsuf(t);
			if (c=='p' || c=='f'
			    || c=='s' || c==ucdsuf || c==optsuf) {
				srclist[nc++] = t;
				t = setsuf(t, binsuf);
				c = binsuf;
			}
			if (c==binsuf) 
			  {
				if (nodup(loaderfiles, t))
				  {
					loaderfiles[nl++] = t;
					nm++;	/* count programs */
				  }
			  }
#ifdef is68
			else if (!strcmp(t,"b.out") || !index(t,'.') )
				infile = t;
#endif
			else {
				undefinedlist[nu++] = t; /* Unrecognized suffix */
				nm++;
			}
		}
	}	/* End of loop to process arguments */
	for (i=0; i<nu; i++) {
		if (uflag||sflag||cflag) {
			srclist[nc++] = undefinedlist[i];
			type = "Pascal code ";
			suf = "p";
		}
#ifdef is68
		else if (dflag||rflag>0) {
			infile = undefinedlist[i];
			type = "b.out format";
			suf = 0;
		} 
#endif
		else {
			loaderfiles[nl++] = undefinedlist[i];
		       	type = "relocatable binary ";
			suf = binsufptr;
		}

		fprintf(stderr,
		       "%s: warning: %s has unrecognized suffix, taken to be %s",
		       compiler,undefinedlist[i],type);
		if (suf) fprintf(stderr,"(type .%s)\n",suf);
		else fprintf(stderr,"\n");
	}
#ifdef is68
	if (version)
	  {
	    if (version[2]=='m') crt0 = "/usr/sun/lib/crt0.b";
	    else if (version[2]=='V') Vkernel++;
	    else if (version[2]=='x') 
	    {
		if (version[3] == 'V') { Vkernel++; version = "-vx"; }
	    }
	    else if (version[2]=='\0' && Vkernel) version = "-vV";
	  }
	else if (Vkernel) version = "-vV";
	if (Vkernel)
	  {
	    if (!entrypt)
	      {
		loaderfiles[nl++] = "-u";
		loaderfiles[nl++] = "_start";
	      }
	    if (!Torg) Torg = "20000";
	  }
#endif
	if (!nl && !infile) {
		fprintf(stderr,"%s: no input specified\n",compiler);
		exit(8);
	}
#ifdef is68
	if ((eflag||sflag||cflag) && (dflag || rflag>0)) {
		fprintf(stderr,"is68: warning: -E,-S,-c disable -d,-r\n");
		dflag = 0;
		rflag = 0;
	}
#endif
	if (gflag) {
		if (oflag)
			fprintf(stderr, "%s: warning: -g disables -O\n",compiler);
		oflag = 0;
	}
#ifdef is68
	if (proflag)
		crt0 = "/usr/sun/lib/mcrt0.b";
#endif
#ifndef Vsystem
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, idexit);
	if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
		signal(SIGTERM, idexit);
#endif Vsystem

#ifdef Vsystem
	if (GetContextId(DefaultTmpDirectory, &context) == OK)
	  {
	    strcpy(TmpDirectory, DefaultTmpDirectory);
	  }
	else
	  {
	    strcpy(TmpDirectory, AltDefaultTmpDirectory);
	  }
#endif Vsytem
/*	if (pflag==0) */
#ifdef Vsystem
		strcpy(tmp_u, TmpDirectory);
		strcat(tmp_u, "ptmXXXXXXXX");
		mktemp(tmp_u);
		/* Check if the temporary-file directory really exists - we
		   may just have a bad context. */
		if ((fad = fopen(tmp_u, "w")) == NULL)
		  {
		    strcpy(TmpDirectory, AltDefaultTmpDirectory);
		    strcpy(tmp_u, TmpDirectory);
		    strcat(tmp_u, "ptmXXXXXXXX");
		    mktemp(tmp_u);
		  }
		else
		  {
		    fclose(fad);
		    unlink(tmp_u);
		  }
	
#else Vsystem
	sprintf(tmp_u, "/tmp/ptm%05.5d", getpid());
#endif Vsystem
	strcat(tmp_u, ".");
	tmp1 = strspl(tmp_u, "1");
	tmp_as = strspl(tmp_u, "s");
	tmp_z = strspl(tmp_u, "z");
	i = strlen(tmp_u); tmp_u[i] = ucdsuf; tmp_u[i+1] = 0;
	if (nc==0)
		goto nocom;

	for (i=0; i<nc; i++) 
	{ char suffix;
		loadsrc=0;
		if (nc > 1) {
			printf("%s:\n", srclist[i]);
			fflush(stdout);
		}
		suffix = getsuf(srclist[i]);
		if (suffix == 'p' || suffix == 'f')
		{	upassrc = srclist[i];
			goto ucode;
		}
		else if (suffix == ucdsuf)
		{	uoptsrc = srclist[i];
			goto optimize;
		}
		else if (suffix == optsuf)
		{	ugensrc = srclist[i];
			goto ugenerate;
		}
		else if (suffix == 's') 
		{	assource = srclist[i];
			goto assemble;		/* thereby skipping ugen68 */
		}
		else 
		{	fprintf(stderr,"%s:garbage input (#%i)\n",srclist[i]);
			fflush(stderr);
			exit(1);
		}

ucode:		na = 0;
		av[na++] = suffix == 'f' ? "ufort" : "upas";
		for (j=0;j<nusw;j++)
			av[na++] = upasswitch[j];
#ifdef pcvax
		if ((pflag)||(uflag)||(oflag))
			av[na++] = "R:0";
#endif
		av[na++] = srclist[i];
		if (pflag || (uflag && !oflag))
			uoptsrc = setsuf(srclist[i], ucdsuf);
		else {uoptsrc = tmp_u; free_u = 1;}
		av[na++] = uoptsrc;
		av[na++]=0;
		if (callsys(suffix == 'f' ? ufort : upas,av))
		{	exfail++;
			error("compilation error (upas) on %s",srclist[i]);
			if (!uflag || oflag) cunlink(uoptsrc);
			exit(1);
		}

optimize:	if (!oflag) ugensrc=uoptsrc;
		else
		{
			if (pflag || uflag)
			    ugensrc = setsuf(srclist[i],optsuf);
			else ugensrc = tmp_z;
			ugensrc = setsuf(srclist[i],optsuf);
 			for (jj=0; jj<= na; jj++) av[jj]=0;
		 	na = 0;
			av[na++] = "uopt";
			av[na++] = uoptsrc;
			av[na++] = ugensrc;
			av[na++] = 0;
			if (callsys(uopt,av))
			{	exfail++;
				error("compilation error (uopt) on %s",srclist[i]);
				cunlink(ugensrc);
				cunlink (setsuf(ugensrc,optsuf2));
				if (!uflag) cunlink(uoptsrc);
				exit(1);
			}
			unlinktmp(_u);
			cunlink (setsuf(ugensrc,optsuf2));
		}

ugenerate:	if (uflag) continue;
		if (pflag || sflag)
			assource = setsuf(srclist[i],'s');
		else { assource = tmp_as; free_as = 1;}
		for (jj=0; jj<= na; jj++) av[jj]=0;
		na = 0;
		av[na++] = "ugen";
#ifdef isvax
		for (j=0;j<ngsw;j++)
			av[na++] = ugenswitch[j];
#endif
		av[na++]=ugensrc;
		av[na++]=assource;
		av[na++]=0;
		if (callsys(ugen,av))
		{	exfail++;
			error("compilation error (ugen) on %s",srclist[i]);
			cunlink(assource);
			if (!uflag) unlinktmp(_u);
			exit(1);
		}
		unlinktmp(_u); unlinktmp(_z);

assemble:	if (sflag) continue;
		loadsrc = setsuf(srclist[i],binsuf);
		for (jj=0; jj<= na; jj++) av[jj]=0;
		na=0;
		av[na++] = as;
#ifdef isvax
		if (jflag) av[na++] = "-J";
#endif
#ifdef is68
		av[na++] = "-g"; /* treat undefined symbols as globals */
#endif
		av[na++] = "-o";
		av[na++] = loadsrc;
		if (lflag) {
			av[na++] = "-L";
			av[na++] = setlongsuf(srclist[i], "ls");
		}
		av[na++] = assource;
		av[na++] = 0;
		if (callsys(as,av))
		{	exfail++;
			error("assembly error (as) on %s",srclist[i]);
			cunlink(loadsrc);
			if (!sflag) unlinktmp(_as);
			exit(1);
		}
		unlinktmp(_as);
/*		if (loadsrc) loaderfiles[nl++] = loadsrc;*/
	}


					

nocom:			/* link edit files in loaderfiles[0:nl-1] */
	if (cflag==0 && nl!=0) {
		for (jj=0; jj<= na; jj++) av[jj]=0;
		na = 0;
		if (Vflag && rflag == 0) rflag = 1;
#ifdef Vsystem
		av[na++] = ld;
		if (rflag > 0)
		  {
			/* two byte-reversals cancel each other */
			av[na++] = "-R";
			rflag = 0;
		  }
#else Vsystem
		av[na++] = "ld";
#endif Vsystem
		av[na++] = "-X";
		if (Rflag)
			av[na++] = "-r";
		if (entrypt) {
			av[na++] = "-e";
			av[na++] = entrypt;
		}
#ifdef is68
		av[na++] = "-f";	/* ignore case in identifiers */
		if (version)
			av[na++] = version;
		if (Torg) {
			av[na++] = "-T";
			av[na++] = Torg;
		};
		if (crt0 != NULL)	/* startup */
			av[na++] = crt0;
		else if (!Vkernel)
			av[na++] = crt0_default;
		if (dflag || rflag>0) {	/* if dl or rev then just output to */
			av[na++] = "-o";/* temporary file */
			av[na++] = infile = tmp1;
		}
		else
#endif
		if (outfile) {	/* else if outfile exists then */
			av[na++] = "-o";/* output to it.  Default is b.out */
			av[na++] = outfile;
		}
		for (i=0; i<nf; i++)	/* supply all non-library flags */
		{	if (loaderflags[i][1] != 'l') {
				av[na++] = loaderflags[i];
				loaderflags[i] = 0;
			}
		}
		for (i=0; i<nl; i++)	/* supply all .b arguments */
			av[na++] = loaderfiles[i];

		for (i=0; i<nf; i++)	/* supply libraries */
		{	if (loaderflags[i] != 0) {
				av[na++] = loaderflags[i];
			}
		}

		av[na++] = plib;	/* pio: Pascal runtime library */
#ifdef is68
		if (gflag)
			av[na++] = "-lg";
		if (Vkernel) {
			av[na++] = "-lpcV";
			av[na++] = "-lV";
		} else {
			av[na++] = "-lpc68";
		        av[na++] = "-lrfio";
		        av[na++] = "-lleaf";
		        av[na++] = "-lpup";
			av[na++] = "-lc";
		}
#else
		av[na++] = "-lm";	/* math lib always used */
		av[na++] = "-lc";
#endif
		if (!noxflag)	       /* add -x by default unless --x given */
			av[na++] = "-x";
		av[na++] = 0;			/* argument delimiter */
		eflag |= callsys(ld, av);	/* invoke ld68 */

		if (nc==1 && nm==1 && eflag==0)
		    /*
		     * If we have only one module AND it was compiled
		     * (as opposed to just linked) then remove the .b file.
		     */
			cunlink(setsuf(srclist[0], binsuf));
	}
#ifdef is68
dnload:
	if (dflag && eflag==0) {
		for (jj=0; jj<= na; jj++) av[jj]=0;
		na = 0;
		av[na++] = "dl68";
		av[na++] = infile;
		if (version)
			av[na++] = version;
		if (Torg) {
			av[na++] = "-T";
			av[na++] = Torg;
		}
		av[na++] = "-o";
		av[na++] = outfile?	outfile:
			   nl?		strspl(setsuf(loaderfiles[0],'d'),"l"):
			   		"d.out";
		av[na++] = 0;
		eflag |= callsys(dl, av);	/* invoke dl68 */
	}

reverse:
	if (rflag>0 && eflag==0) {
		for (jj=0; jj<= na; jj++) av[jj]=0;
		na = 0;
		av[na++] = rev;
		av[na++] = infile;
		av[na++] = outfile && !dflag?	outfile:
			   nl?			setsuf(loaderfiles[0],'r'):
			   			"r.out";
		av[na++] = 0;
		eflag |= callsys(rev, av);
	}
#endif

#ifdef Vsystem
	if (Vflag)
	  {
	    t2 = GetTime(&cl2);
	    t2 = (t2 - t1) * 100 + (cl2 - cl1);
	    tsecs = t2 / 100;
	    ttenths = (t2 / 10) % 10;
	    printf("  Total execution time: %d.%d secs.\n", tsecs, ttenths);
	  }
#endif Vsystem
	dexit();
}

idexit()
{
	eflag = 100;
	dexit();
}

dexit()
{
	exit(eflag);
}


error(s, x)
	char *s, *x;
{
	FILE *diag = exfail ? stderr : stdout;

	fprintf(diag, "%s: ",compiler);
	fprintf(diag, s, x);
	putc('\n', diag);
	exfail++;
	cflag++;
	eflag++;
}

getsuf(as)
char as[];
{
	register int c;
	register char *s;
	register int t;

	s = as;
	c = 0;
	while (t = *s++)
		if (t=='/')
			c = 0;
		else
			c++;
	s -= 3;
	if (c <= MAXNAMLEN && c > 2 && *s++ == '.')
		return (*s);
	return (0);
}

char *
setsuf(as, ch)
	char *as;
{
	register char *s, *s1;

	s = s1 = savestr(as);
	while (*s)
		if (*s++ == '/')
			s1 = s;
	s[-1] = ch;
	return (s1);
}

char *
setlongsuf(as, suff)
char *as;
char *suff;
{
	register char *s, *s1;
	register int suflen = strlen(suff);

	s = s1 = savestr(as);
	while (*s)
		if (*s++ == '/')
			s1 = s;
	s[-1] = 0;
	if (strlen(s1) > (MAXNAMLEN - suflen)) {
		s[-suflen] = 0;
		s[-(suflen-1)] = '.';
	}
	return(strspl(s1,suff));
}

callsys(f, v)
	char *f, **v;
{
	int t, status;
	char cmd[256];
#ifdef Vsystem
	ProcessId pid;
	SystemCode verror;
	int t1, t2, c1, c2, tsecs, ttenths;
#endif Vsystem
	
#ifndef Vsystem
	if (*f!='/')
	   {
	       /*
	        * add the binary directory at the begining if not
		* already specified, so you can have other versions
		* in your path without screwing up.
		*/
	    strcpy( cmd, BinDirectory);
	    strcat( cmd, f);
	   }
	 else
#endif Vsystem
	    strcpy( cmd, f);
#ifdef Vsystem
	v[0] = cmd;
#endif Vsystem

	if (Vflag) 
	  {
	  	/*
		 * print out a trace of all commands executed
		 */
	    char **arg = v+1;
	    printf("[%s", cmd);
	    while (*arg) printf( " %s", *arg++);
	    printf("]\n");
#ifdef Vsystem
	    /* Measure the run time required. */
	    t1 = GetTime(&c1);
#endif Vsystem
	  }
#ifdef debug
	if (tflag)
	{
#endif
#ifndef Vsystem
	t = vfork();
	if (t == -1) {
		printf("No more processes\n");
		return (100);
	}
	if (t == 0) {
		execvp( cmd, v);
		printf("Can't find %s\n", cmd);
		fflush(stdout);
		_exit(100);
	}
	while (t != wait(&status))
		;
#else Vsystem
	pid = ExecProgram(v, NULL, NULL, NULL, &status, &verror);
	if (verror != OK)
	  {
	    printf("Fatal error executing %s: %s\n", cmd, ErrorString(verror));
	    eflag = 8;
	    dexit();
	  }
	if (Vflag)
	  {
	    t2 = GetTime(&c2);
	    t2 = (t2 - t1) * 100 + (c2 - c1);
	    tsecs = t2 / 100;
	    ttenths = (t2 / 10) % 10;
	    printf("        Execution time: %d.%d secs.\n", tsecs, ttenths);
	  }
#endif Vsystem

	if ((t=(status&0377)) != 0 && t!=14) {
		if (t!=2) {
			printf("Fatal error in %s\n", cmd);
			eflag = 8;
		}
		dexit();
	}
#ifdef debug
	}
#endif
	return ((status>>8) & 0377);
}

nodup(l, os)
	char **l, *os;
{
	register char *t, *s;
	register int c;

	s = os;
	if (getsuf(s) != binsuf)
		return (1);
	while (t = *l++) {
		while (c = *s++)
			if (c != *t++)
				break;
		if (*t==0 && c==0)
			return (0);
		s = os;
	}
	return (1);
}

#define	NSAVETAB	1024
char	*savetab;
int	saveleft;

char *
savestr(cp)
	register char *cp;
{
	register int len;

	len = strlen(cp) + 1;
	if (len > saveleft) {
		saveleft = NSAVETAB;
		if (len > saveleft)
			saveleft = len;
		savetab = (char *)malloc(saveleft);
		if (savetab == 0) {
			fprintf(stderr, "ran out of memory (savestr)\n");
			exit(1);
		}
	}
	strncpy(savetab, cp, len);
	cp = savetab;
	savetab += len;
	saveleft -= len;
	return (cp);
}

char *
strspl(left, right)
	char *left, *right;
{
	char buf[BUFSIZ];

	strcpy(buf, left);
	strcat(buf, right);
	return (savestr(buf));
}

