/*
 *  perm.c
 *
 *  This file contains the code the deal with the permanent menu commands.
 *  The only permanent menu commands which stand on their own are the
 *  Miscellaneous commands and the Help command.
 *
 *  David Kaelbling, May 1983
 *  Gustavo Fernandez 10/23/84 - Implemented press files. Removed
 *	unimplemented message and made it extermal.
 *  GAF 11/10/84 - Implemented alto draw file read mode
 *      transparent to the user.
 *  GAF 11/14/84 - Added SIL format read support
 *  GAF  4/11/85 - Fixed bugs, split into smaller files load,save
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern GetMisc();
extern char *GetString();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
extern CopyObject();
extern MoveObject();
extern DrawPress();
extern WriteFile();
extern ReadFile();
 
 
/* Exports */
extern PermMisc();
extern PermExit();
 
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# define SILHEADER	034562	/* SIL format header (password) */
# ifdef VAX
# define File FILE		/* Make files work on both machines */
# endif


/*
 *  This routine will deal with the miscellaneous menu.
 */
 
PermMisc()
  {
    short i;
    register ITEM_LIST_PTR *p, *q;
    
    GetMisc( &i );
    switch (i)
      {
	case 0:
	    /* Clear the screen.  Erase everything. */
	    if (CurrentCmd != CMisc)
	      {
		printf("You cannot clear the screen while another command");
		printf(" is in progress.\n\r");
		break;
	      }
	    Checkpoint();
	    p = activelist->prev;
	    while (p)
	      {
	        q = p->next;
		EraseObject( p, 0 );
		p = q;
	      }
	    DisplayItem( sdf, mainSymbol, mainVgt );
	    modified = 0;
	    CurrentObject = NULL;
	    break;
	    
	case 1:
	    WriteFile();
	    break;
	
	case 2:
	    ReadFile();
	    break;
	
	case 3:
	    DrawPress();
	    break;
	
	case 4:
	    if (Debug)
	      {
		Debug = 0;
		printf("Exit Debug mode.\n\r");
	      }
	    else
	      {
		Debug = 1;
		printf("Enter Debug mode.\n\r");
		printf("    sdf = %d, menuVgt = %d, mainVgt = %d,\n\r",
			sdf, menuVgt, mainVgt );
		printf("    item = %d, menuSymbol = %d, mainSymbol = %d.\n\r",
			item, menuSymbol, mainSymbol );
		printf("\n\r");
		DebugObjectList( "active list", activelist, 4 );
	      }
	    break;
      }
  }

/*
 *  This function will perform the 'exit' command.
 */
 
PermExit()
  {
    char c;
    
    /* Don't exit in the middle of things. */
    if (CurrentCmd != CExit)
      {
	printf("You can't exit when other commands are in progress.\n\r");
	return;
      }
    
    /* If unsaved changes exist, confirm exit. */
    if (modified)
      {
        do
	  {
	    printf("\n\rThere are unsaved changes.\n\r");
	    printf("Do you really want to Exit? ");
	    fflush( stdout );
	    scanf("%c", &c );
	  }
	while (((c = tolower(c)) != 'y') && (c != 'n') && (c != 't'));
	if (c == 'n')
	  {
	    printf("\n\rAborted.\n\r");
	    return;
	  }
      }
    printf("\n\r");
    Quit();
  }
