@make(report)
@libraryfile(picture)
@device(dover)
@begin(titlepage)
@begin(titlebox)
@majorheading[
DRAW:
A Draw program for the SUN Workstation
User's Manual
]
@end(titlebox)
@heading[
David Kaelbling, Gustavo Fernandez
@value(date)
]
@end(titlepage)

@section[Introduction]

This program is meant to fill a specific void in the V System software.
Specifically, the lack of a document illustrator which can be used to add
figures to documents created with programs such as Scribe. This program is
loosely based on the Alto DRAW program. Many of the same primitive objects
are common to both programs, but the style of interaction is quite different.
If you have any questions about the
behavior of the program, try using the @b[Help] command.  It will
provide some meaningful information.

@section[Conceptual Model]

The conceptual model behind this program is one similar to a person drawing
regular objects on pieces of paper.  The drawing pen has a number of
different nibs (tips) which can be selected.  Similarly, the 'ink' and fill
pattern used to shade areas also comes in several flavors.  The ink can be
either @c[transparent] or @c[opaque].  If transparent ink is used to fill an
object, anything under the object will show through.  If opaque ink is used,
underlying objects will be obscured.  The @b[Bring to Front] (raise) and
 @b[Push to Back] (lower) commands are useful for shuffling which objects
lie on top of each other.  Each object lies entirely in its own plane, so it
is impossible to create works similar to those popularized by M. C. Escher.

Curves are generated using B-Splines of various orders.  By default, all
curves are of order 3, and thus use quadratic interpolation.  
Automatic filling (shading) of closed objects (specifically, @c[closed
curves], @c[closed polygons], and certain @c[templates]) is possible.

A @c[group] is a collection of existings objects lumped together and treated
as a single unit.  Groups are useful for replicating completed symbols and
figures in several places.

A variety of standard shapes are provided, and are referred to as
@c[templates].  Templates for Arrowheads (open and closed, wide and narrow)
exist, as well as templates for rectangles, circles, and ovals.  Each object
on the screen has a type, so while it is quite possible to create a
rectangular closed polygon which appears identical to a rectangular
template, they are of distinct type.  This is important to bear in mind
because whenever you are asked to select an object on the screen, the
program will only examine objects of a certain type, and so some confusion
might arise when the program doesn't find the thing you are right on top of.


@section[Screen Layout]

When the program is first invoked, it will create two new windows on the
screen.  The large empty one is the main drawing area (known as "drawing
area" to the Vgtsexec), and the smaller one is the commands window (known as
"draw menu" to the Vgtsexec).  The drawing area is zoomable (for
instructions on how to use the Vgtsexec, see the V Commands
Manual@cite[VCommands]), and the grid spacing available at normal
magnification is the same as that used by the program.  Since the program
has no way of knowing what magnification you are using, it aligns to the
unzoomed grid values.  The VGTS will place grid points at a constant
separation, regardless of magnification.  You may create additional views,
move existing views, etc., to your satisfaction.  The default drawing area
is in the proportion of 8.5 by 11, and centered.  A frame is put around the
actual size of a drawing page to provide some reference points if you zoom
the view or change its centering.  The frame is normally not visible, as it
lies entirely outside the default view.  It will not appear in any output.

The Menu window is divided into three separate menus.  One consists of
action commands (@b[Rotate], @b[Scale], @b[Move], @b[Copy], @b[Draw],
@b[Alter], @b[Erase], @b[Push to Back], and @b[Bring to Front]), which
place the program into a state where it is waiting for you to specify
certain actions.  Typically, you will need to specify an object type (@c[All
Objects], @c[Text], @c[Open Curve], @c[Closed Curve], @c[Current Object],
@c[Open Polygon], @c[Closed Polygon], @c[Group], or @c[Template]) and then
some data points.  A second series of menu options runs along the bottom of
the menu window.  These are the commands which control various defaults
within the program.  For example, if you wish to change the default font
which new text is displayed in, select the @b[Text] default option in the
lower left corner of the menu (not the object type @c[Text] under the
'Objects' column), and make the desired selection in the popup menus which
will appear.  The third section of the Menu is the list of permanent menu
selections (@t[Exit], @t[Help], @t[Misc], @t[Undo], @t[Abort], and
@t[Done]).  These commands are valid most of the time.  In particular, you
can always hit @t[Help].

The original window which you used to run the draw program will serve as a
combination history log and prompt file.  The program will print many
prompts in this window, telling you what it expects you to do next, and what
it didn't understand of your last action.  When you ask for Help, it will
appear in this window.


@section[Command Input]

The program accepts all command input through the mouse.  Clicking the mouse
near a command in the Menu is sufficient to indicate to the program that you
wish to specify that command.  Clicking the mouse in the drawing area will
either specify a data point or a command, depending on which mouse buttons
are used.  More on that later.  Sometimes input is required from the
keyboard.  Due to limitations of the VGTS, when the program is requesting
input from the keyboard, clicking the mouse will have no immediate effect.
Once the program gets around to asking for mouse clicks again, all of the
saved clicks will be processed.

Occasionally the VGTS will have difficulties synchronizing communications.
This almost invariably occurs when you hit a character on the keyboard while
the program is expecting a mouse click.  When this happens, a message
similar to
@quotation[Sync error - Expected 037, got 040]
will appear.  After this happens, things usually get a little strange.  The
program will starting complaining about
@quotation[Internal Error:  Bad mouse buttons 170 at (5, 89)]
(maybe with other numbers) or more commonly
@quotation[Missed!  Please select a menu command.]
and refuse to recognize anything you do as intelligible.
Do Not Despair!!  The remedy for this is to deliberately force @i[more] sync
errors (by alternately typing a character on the keyboard and attempting
innocuous commands with the mouse, like @b[Help]) until a full cycle has
been completed.  This typically requires you to force three more
synchronization errors, and then everything will be completely functional
again.


@section[Control Points and Sticky Points]

When you create a curve, you will be asked to specify the Control Points of
the spline.  These points are the places which you wish the curve to pass
near.  The more control points you put in one place, the nearer
the curve will come to that place.  Also, placing multiple control
points at a single point will make the curve much 'sharper' at that point.
Except for the end points of open curves, and multiple control
points, the curve will not pass through any of the control points.

Sticky points (similar to Knots) are points which actually lie on the curve.
They are calculated by the program to help you with the alignment of
objects.  There will be the same number of control points and sticky points
on curves.  Polygons are a special case, in that since the control points of
a polygon actually lie on the 'curve', the program considers them to be
sticky points too.  This means that the sticky points on polygons lie at the
corners and in the middle of each edge.  Sticky points for bounding boxes
(e.g., for @c[Text] objects) are the same as those for polygons.


@section[Mouse Buttons]

When the mouse is clicked inside the Menu, it is unimportant which mouse
buttons you use.  Within a popup menu (a list of choice which 'pops up'
after you do something), you can abort by either clicking outside the menu
or by pressing all three mouse buttons down and releasing them.  In general,
you don't have to release (or press) the buttons all at once, but the mouse
position is based upon where the cursor is when you release the last button.

Clicking the mouse inside the drawing area can cause one of several
different commands (and mouse locations) to be used by the program.  The use
of mouse keys within the drawing area is as follows:

@begin(verbatim)
    Buttons            Effect
    -------            ------
     X - -             Specifies a data point right where you are pointing.
     - X -             Requests the program to find a sticky point.
     - - X             Requests the program to use the nearest grid point.
     X X -             The Almost Done command. (see below)
     X - X             Requests that a Checkpoint be made.
     - X X             Equivalent to the 'UNDO' command.
     X X X             Equivalent to the 'ABORT' command.
@end(verbatim)

Sticky points are points located on or near existing objects on the screen.
They are useful for connecting lines to objects, specifying points actually
on the object, etc.  @c[Groups] themselves do not have sticky points,
although the objects within a group may.  Curves have one sticky point per
control point.  These points are located midway between each pair of control
points.  When you request that the program select a sticky point, it will
choose the nearest such point which is within a given radius (about 1
inch).  If you are further trying to specify a point on a specific type of
object, the search for a suitable point is begun again from the previous
result.  Naturally, if the original mouse click relocated to a sticky point
on an object of the proper type, that will be the closest point for any
further searches.

Grid points are spaced every 16 pixels (at normal magnification).  If you
wish to see these grid points, use the @b[Toggle Grid] command within the
Vgtsexec.  For printed output, pixels are assumed to be distributed at 100
per inch.

The @b[Almost Done] command is quite similar to the @b[Done] command
described below, in that it tells the program you are satisfied with the
selections you have made, and that you wish the program to accept them.
Unlike the @b[Done] command, it does not tell the program that you are
completely finished with whatever you were doing.  Instead, it permits you
to, for example, erase several objects of the same type without having to
go to the Menu each time and specify the @b[Erase] command and the object
type.

It differs from a 'repeat' command in that it does not force the program to
create a checkpoint before beginning the next command.  As a special case,
when in conjunction with the @b[Draw] command, @b[Almost Done] and @b[Abort]
behave slightly differently.  @b[Abort] will cause the last item you drew to
be removed, and @b[Undo] will subsequently remove all of the others.
Normally, @b[Abort] would cause all changes since the command began to be
removed.

This command is also quite useful when drawing a series of objects of
similar type.  You can specify that you wish to draw a closed curve, place
the control points for the curve, and then confirm with the right two mouse
keys (@b[Almost Done]).  The program will complete the curve you have
outlined, and wait for you to specify another closed curve, just as if you
had confirmed with @b[Done], and then selected @b[Draw] @t[Closed Curve]
again.


@section[Selecting Objects]

The standard method of selecting an object is to first choose the object
type and then to point at the desired object on the screen, using some
combination of mouse buttons which specify a data point.  If you
select the wrong object type, simply point at and choose a different object
type before you select the object itself.  As a short cut, the program
maintains a notion of what it considers to be the 'Current Object'.  This
will be the last object you selected.  If you choose the object type
@c[Current Object], and it is unambiguous as to what the current object is,
this will suffice.  After you select an object, that object will be
'highlighted' on the screen.  This normally consists of frame or bounding
box appearing around the object.  If the program misinterprets your
pointing, use the @b[Undo] command (also available by pressing the right two
buttons on the mouse) and then point to a different location on the screen.

The most notable exception to this process is the method for selecting
groups.  Since individual objects can appear in several groups, a popup menu
appears when you select the @c[Group] object type, listing all of the
existing groups.  Either choose one of these groups from the menu, or click
outside the menu to abort.


@section[Action Commands]

There are nine action commands.  Each is useful for manipulating one or more
objects.  Typically, each action command will require the selection of an
object type.

@Begin(description)
@b[Rotate]@\
@begin(multiple)
This command will permit you to select an object, specify a fixed point about
which the rotation is to take place, and two points which will define the
angle of rotation.

Text is rotated about its positioning point.  Only the position of the text
is changed -- the orientation of individual letters is constant.
@end(multiple)

@b[Scale]@\
@begin(multiple)
This command will permit you to select an object, specify a fixed point for
the scaling, and two points which define the scaling vector.  This command
is useful for expanding and contracting objects.

Scaling text will not change its size or font.  It will change the
location of the string based upon its positioning point.
@end(multiple)

@b[Move]@\
This command will permit you to select an object, and then specify a pair of
points which define a displacement vector.  This vector tells the program
how far and in which direction to move the object.  By using this command,
you can move existing object about on the screen.

@b[Copy]@\
This command is similar to @b[Move], except that it leaves behind an image of
the object.  If you copy anything other than a group, the two resulting
items are completely independent.  Changing one will not affect the other.
Groups, on the other hand, work differently.  When you copy a group, it
simply creates a new image of the same group, appending "@t[, copy @i[n]]" to
the old group name, where @i[n] is a small number.

@b[Draw]@\
This command lets you create new objects.  Since it is anticipated that most
of the time spent in this program will be drawing new objects, this is (so to
speak) the default command.  If you ever select an object type without
giving a command first, the program will assume that you implicitly meant to
draw an object of that type.

@b[Alter]@\
This command is useful for changing the characteristics of an existing
object.  It will permit you to move the control points on splines, change
the filling and nib selections used to draw objects, etc.  @p[Currently
Unimplemented.]

@b[Erase]@\
This command allows you to delete (erase) objects from the screen.  If you
decide you just don't want to see an object any more, erase it.  If you
decide that the last command you did was a mistake, you probably want to use
the @t[Undo] command.

@b[Push to Back]@\
Also known as @b[Lower], this command will place the selected object behind
all of the other objects.  This is useful when you use opaque ink to fill
something, and it winds up obscuring an object you want to see.

@b[Bring to Front]@\
Also known as @b[Raise], this command functions much like the one above,
except that it will place the selected object on top of all of the other
objects.  Note that you can still point to objects you can't see -- the
program will find sticky points on completely obscured objects with no
difficulty.

@End(description)


@section[Object Types]

There are nine selections within the Object type menu.  Some of the
selections are obvious, some are not.  All are meaningful for selecting
existing objects, but the 'Draw All Objects' command is not.

@Begin(description)
@b[All Objects]@\
This will permit you to select all objects at once.  If you decide, for
example, to move everything on the page a bit to the left, then this is the
object type you want.  The @t[Clear Screen] command (available under
@t[Misc]) simply does an '@b[Erase] @t[All Objects]', and then sets the
dirty flag to false.

@b[Text]@\
As is obvious, this will select any text string.  It doesn't matter what
font the text is in -- it is all of object type text.

@b[Open Curve]@\
An open curve is a spline with open end conditions.  When you create one,
the first and last control point you specify will actually be on the curve,
and the curve will be tangent to its convex hull at these points.  (It gets
straight at the ends.)

@b[Closed Curve]@\
Closed curves are splines with closed end conditions.  To create one, you
specify all of the control points you desire (the program will build a frame
for the spline to help you visualize the resultant curve.  You do not need
to try to get the first and last control points in the same place -- the
program will close objects automatically.  Closed curves can be filled.

@b[Current Object]@\
This will select the current object, if one exists.  If you attempt to
'@b[Create] @t[Current Object]', the program will interpret this as a
request to create an object of the same type as the current object.

@b[Open Polygon]@\
A bunch of connected straight lines.  (Internally, these are just splines of
order 2, thus using linear interpolation.)

@b[Closed Polygon]@\
Also straightforward.  Closed polygons can be filled.  The program will
automatically add the last edge, closing the polygon.

@b[Group]@\
@begin(multiple)
Groups are a bit tricky.  A group consists of several existing objects,
lumped together and treated as a singled named object.  To create a group,
you select as many existing items as you like, and they are all placed into
the group.  Once items are inside a group you @i[cannot] select them by
normal means.  They are in effect hidden inside the group.

Groups are useful if you have a complicated, complete figure which you wish
to deal with as a whole.  Due to internal limitation, you can't have more
than some fixed number of groups active at one time.
@end(multiple)

@b[Template]@\
@begin(multiple)
Templates are standard shapes.  The broad classes of standard shapes are
arrowheads, circles, ovals, and rectangles.  Arrowheads can either be open
or closed.  Closed arrowheads are filled with black ink.  The nib used to
draw an arrowhead will be the same size as the the current nib, but will be
circular.

Rectangles and Ovals are both created by specifying two points on a long
diagonal of the bounding box.  You can give either the upper left and the
lower right or the lower left and the upper right.  The program doesn't know
the difference.

Circles are created by specifying the center of the circle and a point on the
circle.  Since circles are actually high order splines (5@+[th] order, using
quartic interpolation), they are not truely circular.  If you draw a really
large circle, it is possible that the point you specify for being on the
circle will be off by as much as a quarter of an inch or so.  For normal
sized circles, there will be no difficulties.
@end(multiple)

@End(description)


@section[Default-setting Commands]

There are a number of Menu selections which control various defaults within
the program.  They can be selected at any time.  They are:

@Begin(description)
@b[Text]@\
@begin(multiple)
When you select this command, a popup menu will appear.  You can use this
menu to specify either the method of positioning text, or the general class
of font you wish to use.

There are three different ways of positioning text -- you can specify (with
a data point entered via the mouse) either the bottom left-hand corner of
the bounding box for the text, the center of the bottom edge of the bounding
box for the text, or the bottom right-hand corner of the bounding box.
Initially, the program positions text based upon the center of the bottom
edge of the text.  You can only specify a point on the lower edge of the
text -- the program will automatically compute where the bounding box for
the particular piece of text lies.  If you are confused about where text
should appear, try positioning a few strings, using the exact positioning
(leftmost) mouse button.

If you wish to change the font in which new text is displayed, choose one of
the font menu selections.  A second popup menu will appear, listing all of
the available fonts.  The 'Standard Fonts' category contains the fonts which
can be considered to be mundane text fonts -- variations on Helvetica, Times
Roman, and a few randoms like Clarity 12 and Cream 12.  The 'Unusual Fonts'
selection contains everything else -- Old English 18, Hebrew, Cyrillic,
Greek, APL, Math, CMR, etc.  There are some fonts, like Gates 32 and
Template 64, which are very difficult to use unless you are quite familiar
with them.  They are included primarily for completeness sake.
@end(multiple)

@b[Fill on/off]@\
This toggle controls whether or not closed objects (Closed Arrowheads,
Rectangles, Circles, Ovals, Closed Curves, and Closed Polygons) are filled
by default.  If you wish to use created filled objects, set this switch to
@b[Fill on].  Toggle the switch by pointing at it and clicking the mouse.

@b[Nib]@\
If you wish to change the nib (paint brush?) used to draw lines, select this
command.  There are four nibs, each of which comes in four sizes.  The
program initially uses a Circular nib of size 1.  The four nib shapes are
Square, Circular, a horizontal Dash, and a vertical Bar.  The four sizes are
(unsurprisingly) 0, 1, 2, and 3.  Size 0 is a single pixel, so all of the
nibs look the same at that size.  An example of the current nib, at the
current size, is displayed in this area.

@b[Fill]@\
@begin(multiple)
This command allows you to change the fill pattern used to shade closed
objects.  A small square section of the current fill pattern appears in this
area.  When you select @b[Fill], a popup menu will appear, permitting you to
either toggle the use of opaque vs translucent ink or select a general class
of fill pattern.

The 'Striping Patterns' consist mostly of lines drawn at various angles.
The program initially uses the one pattern least like straight lines but
still considered a striping pattern:  Chain Link.

The 'Gray Tones/Area Patterns' selection consists more of patterns which are
either various shades of gray, or are regular and (to some) uninteresting.
These patterns are useful for highlighting objects.

The 'Textured Patterns' are supposed to be more representative of actual
textures.  The names for these patterns are supposed to be suggestive of
their appearance, but many of the names are nonetheless obscure.
@end(multiple)

@End(description)


@section[Permanent Menu Commands]

There are a few commands which are generally useful, and are thus considered
permanent.  Not all are meaningful at all times, but are still useful enough
to be given an entry on the Menu.

@Begin(description)
@b[Exit]@\
This command will exit the program.  It can be used at any time.  If you
have performed any command since either clearing the screen or writing a
file, the program will ask you to confirm that you actually wish to exit
even though there are unsaved changes.  Typing '@t[y]' will confirm.  Typing
anything else will abort the command.  Note that since the program is
reading input from the keyboard when asking you to confirm, any mouse clicks
you make will simply be queued, and when you do type at the keyboard they
will all be dealt with.  In particular, be careful about using the @t[Abort]
command here.

@b[Help]@\
This command will provide a brief description of any other command you like.
To get help on a specific command, just select that command after you select
help.  To get help with the mouse buttons, push any one button in the
drawing area.  To exit help, select @b[Help] again.  You can ask
for help at any time.

@b[Misc]@\
@begin(multiple)
This command is actually a front for a collection of less frequently used
commands.  The various commands are for clearing the screen (only valid if
no other command is in progress), reading and writing files, generating
press files, and toggling debug printouts.  The debug printouts are long and
plentiful -- they are also meaningless to the uninitiated.

Reading a SUN draw file does not clear the screen -- it adds the new objects
to the current display.

Draw can read its own (semi-human-readable) files as well as Alto draw files
and SIL files (created with Alto SIL or V Siledit) Note, however, that
neither of these two formats can be written out. Draw is also not as
optimized for reading the other file formats as for reading its own files 
drawing will be noticably slower, especially when using thick SIL lines.
Certain features of the ALTO draw program such as dashed lines,
the @i(Arrows) font, and color capability are lost in the translation.
Lastly, splines are defined differently in V draw from ALTO draw. In the
latter, the spline goes through the control points while this is not
generally true in the former. Streight lines will appear correct, however.

DRAW has the capability of creating a press file suitable for sending to
the Dover printer, or for inclusion inside a text document. (for example,
using the Scribe @@PressPicture command) Choose the "generate a press file"
option from the @i(Misc) menu. You will be prompted for a file name.
Pressing @I(RETURN) without any file name will send the file directly to
the Dover. Because of the limitations of the Dover, filled splines and
polygons cannot be printed. These objecst will appear unfilled and a warning
message will be displayed on the terminal. Some objects are also just too
complicated for the Dover to print. In this case, either garbage output
will be produced, or the "press file too complicated" message will be
printed on the header page with no other output. 

To insert a picture in as Scribe document, first place a PressEdit caption
symbol (a text item showing "<==<<") in the bottom center of your picture.
Then, issue the "generate a press file" command to save file file to disk.
Then insert line

@begin(programexample)
    @@libraryfile[picture]
@end(programexample)

near the beginning of your 
scribe input (.mss) file, and lines like the ones shown below
at the point where you want the picture to appear.

@begin(ProgramExample)
    @@Begin (Figure)
    @@PressPicture( file="bridge.press", height="3.5inches")
    @@Caption (An example figure)
    @@End (Figure)
@end(ProgramExample)

This will produce output like that shown below...
    @Begin (Figure)
    @PressPicture( file="bridge.press", height="3.5inches")
    @Caption (An example figure)
    @End (Figure)
@end(multiple)

@b[Undo]@\
@begin(multiple)
There are actually two forms of the @t[Undo] command.  If you select it
while at the top level (when there are no other commands in progress), the
effect will be to revert to the previous checkpoint, in effect undoing the
last command.  The program maintains a list of 10 checkpoints, so you can
undo up to 10 commands. You can undo the undo (i.e. redo) a command by
cycling through the 10 checkpoints.

Checkpoints are copies of the complete state of the drawing area.  The
program will make one before it starts any action command.  In this way, the
@b[Abort] command doesn't need to keep track of incremental changes during
the processing of a command.

If you give the undo command while in the process of specifying another
command, it will attempt to undo your last choice.  If you are specifying
data points, @t[Undo] will delete the last point you entered.  If you are
selecting an object, @t[Undo] will unselect the object and permit you to
choose again.
@end(multiple)

@b[Abort]@\
This command will abort any command in progress.  In general, @t[Abort] will
also revert to the last checkpoint, since action commands all make a
checkpoint before they begin processing.

@b[Done]@\
This command is used to tell the program that you are happy with all of your
choices, and are done specifying parameters.  After you hit @t[Done], the
program will attempt to perform whatever command you are executing, and will
display the results.  Note that by pressing down the left two mouse buttons
while in the drawing area, you can give the @t[Almost Done] command, which
will confirm all of you selections, but not stop the command.  In this way
you can, for example, create several objects at once.  Note, however, that
if you use the @t[Almost Done] command, you are not guaranteed that a
checkpoint will be made.  If you create several objects with @t[Almost
Done], and then hit @t[Abort], some (perhaps even all) of the new objects
may be aborted also.

@End(description)
