/*
 *  load.c
 *
 *  This file contains the code the deal with loading a file into
 *  memory. Alto draw, SIL, and native files are supported.
 *
 * Split off from Perm.c by Gus Fernandez 4/11/85
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern GetMisc();
extern char *GetString();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
extern CopyObject();
extern MoveObject();
extern NewObject();
extern NewGroup();
extern DrawPress();
 
 
/* Exports */
extern ReadFile();
 
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# define SILHEADER	034562	/* SIL format header (password) */
# ifdef VAX
# define File FILE		/* Make files work on both machines */
# endif

/*
 *  This internal routine is a helper process for ReadFile().
 */
 
ScanRead( dx, dy, count, filtrans, transcnt, fp )
	short dx, dy, count;
	ITEM_LIST_PTR *filtrans[];
	short *transcnt;
	File *fp;
  {
    enum ObjTypes type;
    short subtype, typedata, xmin, xmax, ymin, ymax, base;
    char *data, *name;
    unsigned short order, numvert, border, closed, filled, opaque;
    enum Nib nib;
    enum Pattern pat;
    short i,len;
    short cnt, newdx, newdy;
    ITEM_LIST_PTR *ptr, *gptr;
    SPLINE *sptr;
    POINT *pptr;
    
    
    /* Read in the basic data. */
    fscanf( fp, "%d %hd %hd %hd %hd %hd %hd %hd ",
	&type, &subtype, &typedata,
	&xmin, &xmax, &ymin, &ymax, &base );
    switch (type)
      {
	case TextObj:
	    /* Text.  Read the string. */
	    if ((data = (char *) malloc( MAXLEN+1 )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a text string.\n\r");
		return;
	      }
	    fscanf( fp, "%hd ", &len);
	    for (i = 0; i < len; i++)
	        data[i] = getc( fp );
	    data[i]=0;
	    NewObject( data, type, subtype, typedata, xmin, xmax,
		    ymin, ymax, base, NULL, Debug, dx, dy );
	    break;

	case GroupObj:
	    /* Groups.  Read the group name. */
	    if ((name = (char *) malloc( MAXLEN+1 )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a group name.\n\r");
		return;
	      }
	    fscanf( fp, "%1s", &(name[0]) );
	    for (i = 1; i <= MAXLEN; i++)
	        name[i] = getc( fp );
	    
	    /* Read all of the items, and then build the group. */
	    if ((gptr = (ITEM_LIST_PTR *)
		malloc( sizeof(ITEM_LIST_PTR) )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a group.\n\r");
		return;
	      }
	    gptr->prev = gptr->next = NULL;
	    fscanf( fp, "%hd %hd %hd ", &newdx, &newdy, &cnt );
	    while( cnt != -1 )
	      {
		ScanRead( newdx, newdy, cnt, filtrans, transcnt, fp );
		if ((ptr = (ITEM_LIST_PTR *)
		    malloc( sizeof(ITEM_LIST_PTR) )) == NULL)
		  {
		    printf("\n\rOut of memory.  Can't read a group.\n\r");
		    return;
		  }
		if (gptr->next)
		    gptr->next->next = ptr;
		else
		    gptr->prev = ptr;
		ptr->flag = 0;
		ptr->call = 0;
		ptr->next = NULL;
		ptr->prev = gptr->next;
		ptr->dx = newdx;
		ptr->dy = newdy;
		ptr->itemdesc = CurrentObject->itemdesc;
		gptr->next = ptr;
		fscanf( fp, "%hd %hd %hd ", &newdx, &newdy, &cnt );
	      }
	    RedrawActivelist( 0 );
	    NewObject( gptr->prev, type, subtype, typedata, xmin, xmax,
		    ymin, ymax, base, name, Debug, dx, dy );
	    NewGroup( CurrentObject, (typedata == 0), 0 );
	    break;
	
	default:
	    /* Splines.  Read the data points. */
	    fscanf( fp, "%hd %hd %d %hd %hd %hd %hd %d",
		&order, &numvert, &nib, &border,
		&closed, &filled, &opaque, &pat );
	    if ((sptr = (SPLINE *) malloc( sizeof(SPLINE) +
		(numvert - 1) * sizeof(POINT) )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a spline.\n\r");
		return;
	      }
	    sptr->order = order;
	    sptr->numvert = numvert;
	    sptr->nib = nib;
	    sptr->border = border;
	    sptr->closed = closed;
	    sptr->filled = filled;
	    sptr->opaque = opaque;
	    sptr->pat = pat;
	    pptr = &(sptr->head);
	    for (i = 0; i < numvert; i++)
		fscanf( fp, "    %hd %hd ", &(pptr[i].x), &(pptr[i].y) );
	    NewObject( sptr, type, subtype, typedata, xmin, xmax,
		ymin, ymax, base, NULL, Debug, dx, dy );
	    break;
      }
    
  }
/*----------------------------------BEGIN SIL-------------------------------*/


/*
 * This routine will read in a SIL format file 
 */

silread(fp)
    File *fp;

  {
    SPLINE *sptr;
    POINT *pptr;
    char *data;
    int xmin,xmax,ymin,ymax;
    unsigned short aword;
    short font;
    unsigned short getword();
    int getfloat();
    int i,j;
    short shape,thickness,numvert,decent;
    enum Nib nib;

    if ((aword=getword(fp)) != SILHEADER) { 
	printf("\r\nERROR:It looked like a SIL file but it wasn't %o\n\r",aword);
        return;
    }
    while (!feof(fp)) {
        aword=getword(fp); /*ignore link*/
	if (feof(fp)) break;
	xmin=getword(fp)&1023;
	ymax=getword(fp)&1023;
	xmax=getword(fp)&1023;
	ymin=getword(fp);
	font=ymin>>12;
	ymin &= 1023;
	ymax=800-ymax;
	ymin=801-ymin;
	xmax--;
	if (font>=14) {
	    if ((sptr=(SPLINE*)malloc(sizeof(SPLINE)+4*sizeof(POINT))) == NULL)
		  {
		    printf("\n\rOut of memory.  Can't read a spline.\n\r");
		    return;
		  }
	    sptr->order = 2;
	    sptr->numvert = 4;
	    sptr->nib = (enum Nib) 0;
	    sptr->border = 1;
	    sptr->closed = 1;
	    sptr->filled = 1;
	    sptr->opaque = 1;
	    sptr->pat = PatBlack;
	    pptr = &(sptr->head);
	    pptr[0].x=xmin; pptr[0].y=ymin;
	    pptr[1].x=xmax; pptr[1].y=ymin;
	    pptr[2].x=xmax; pptr[2].y=ymax;
	    pptr[3].x=xmin; pptr[3].y=ymax;
		NewObject( sptr,ClosedPolygonObj,0,0,0,0,0,0,0,NULL,1,0,0);
	    }
	else { /*text*/
	    if ((data = (char *) malloc( MAXLEN+1 )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a text string.\n\r");
		return;
	      }
	    switch(font) {
		case 0: /*Helvetica10*/
		    font=2;
		    decent=5;
		    break;
		case 1: /*Helvetica10B*/
		    font=3;
		    decent=5;
		    break;
		case 2: /*Helvetica7*/
		    font=5;
		    decent=7;
		    break;
		case 3: /*Helvetica7b*/
		    font=6;
		    decent=7;
		    break;
		case 4:
		case 5:
		case 6:
		case 7:
		case 12:
		case 13: /*Template64*/
		    font=24;
		    decent=0;
		    break;
		case 8: /*Helvetica10I*/
		case 9: /*Helvetica10BI*/
		    font= -1;
		    printf("Helvetica 10 italic fonts not supported.\n\r");
		    break;
		case 10: /*Helvetica7I*/
		    font=8;
		    decent=7;
		    break;
		case 11: /*Helvetica7BI*/
		    font=7;
		    decent=7;
		    break;	
		default:
		    printf("Invalid SIL font number :%d",font);
		    font= -1;
		    break;
	    }
	    getstring(fp,0,data);
	    NewObject( data, TextObj, font, 2, xmin,xmax,ymin,ymax,
		decent,NULL,Debug,0,0);

	}
    }
}	


/*~~~~~~~~~~~~~~~~~~~~~~~~END SIL~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/


/*
 * This routine will read in an Alto format file 
 */

#define ALTO_BOTTOM_MARGIN 160
#define ALTO_LEFT_MARGIN 80

altoread(fp)
    File *fp;

  {
    SPLINE *sptr;
    POINT *pptr;
    char *data;
    int dx,dy;
    unsigned short aword;
    short nsplines,nknots,nstrings,font;
    unsigned short getword();
    int getfloat();
    int i,j;
    short shape,thickness,numvert,decent;
    enum Nib nib;

    if ((i=(getword(fp)<<16)+getword(fp))!=0xffffffff) { 
	printf("ERROR:It looked like an Alto Draw file but it wasn't");
        return;
    }
    nsplines=getword(fp);
    for (j=1;j<=nsplines;j++) {
	aword=getword(fp);
	if ((aword&0x1000)!=0)
	    printf("Can't do Alto dashed lines yet.\n\r");
	shape=(aword&0x0c00)>>10;
        if (shape<2) shape ^= 1;
	thickness=(aword&0x0300)>>8;
	nib=(enum Nib)(thickness+(shape<<2));
	if ((aword&0x0007)!=7)
	     printf("Colors are being ignored.\n\r");
	aword=getword(fp);
	numvert=aword&0x7fff;
	if ((sptr = (SPLINE *) malloc( sizeof(SPLINE) +
	    (numvert - 1) * sizeof(POINT) )) == NULL)
	      {
		printf("\n\rOut of memory.  Can't read a spline.\n\r");
		return;
	      }
	sptr->order = 3;
	if (numvert < 3)
	    sptr->order = numvert;
	sptr->numvert = numvert;
	sptr->nib = nib;
	sptr->border = 1;
	sptr->closed = (aword&0x8000!=0);
	sptr->filled = 0;
	sptr->opaque = 0;
	sptr->pat = PatWhite;
	pptr = &(sptr->head);
	    for (i = 0; i < numvert; i++)
		pptr[i].x=getfloat(fp)+ALTO_LEFT_MARGIN;
	    for (i = 0; i < numvert; i++)
		pptr[i].y=getfloat(fp)+ALTO_BOTTOM_MARGIN;
	    NewObject( sptr, numvert>2?
		(sptr->closed?ClosedSplineObj:OpenSplineObj):
		(sptr->closed?ClosedPolygonObj:OpenPolygonObj),
		0,0,0,0,0,0,0,NULL,1,0,0);
	}
    nstrings=getword(fp);
    for (i=1;i<=nstrings;i++) {
	if ((data = (char *) malloc( MAXLEN+1 )) == NULL)
	  {
	    printf("\n\rOut of memory.  Can't read a text string.\n\r");
	    return;
	  }
	dx=getword(fp)+ALTO_LEFT_MARGIN;
	dy=getword(fp)+ALTO_BOTTOM_MARGIN;
        font=getword(fp);
	switch(font) {
	    case 0:
		font=9;
		decent=5;
		break;
	    case 1:
		font=10;
		decent=5;
		break;
	    case 2:
		font=5;
		decent=7;
		printf("Helvetica 7 being substituted for Helvetica 8\n\r");
		break;
	    case 3:
		font= -1;
		printf("Alto arrows font not supported.\n\r");
		break;
	    default:
		printf("Invalid Alto font number :%d",font);
		font= -1;
		break;
	}
	aword=getword(fp);	
	if ((aword&0x0007)!=7) printf("Color is bing ignored in text\n\r");
	aword=getword(fp);
	getstring(fp,aword,data);
	NewObject( data, TextObj, font, 2, dx, dx+strlen(data)*5,dy-16,dy,
	    decent,NULL,Debug,0,0);
    }
}

/* 
 * get a BCPL word from the standard input and return as a short
 */

unsigned short getword(fp)

File *fp;
{
    int i;
    i=getc(fp)<<8;
    return(i+getc(fp));
    }
    
/* 
 * get a BCPL packed floating point number from standard input and return
 * integer portion
 */

int getfloat(fp)
File *fp;

{
    int num;
    int mantisa;
    short exponent;
    short sign;
    short aword;
    
    aword=getword(fp);
    sign=aword&0x8000;
    exponent=((aword&0x7f80)>>7)-128;
    mantisa=getword(fp)+((aword&0x007f)<<16);
    if (exponent<0) return(0);
    else {
	num=mantisa>>(23-exponent);
	if (sign!=0) num= -num;
	return(num);
    }
}

/* 
 * get a BCPL string, but read at least (word) words.
 */

getstring(fp,words,str)
File *fp;
int words;
char *str;


{
   int numbytes,strlen,junk,i;
   strlen=getc(fp);
   numbytes=2*words-1-strlen;
   if (numbytes<0) numbytes=0;
   if (((numbytes+strlen)&1)==0) numbytes++;
   for (i=1;i<=strlen;i++) 
       *(str++)=(char) getc(fp);
   *(str++)='\0';
   for (i=1;i<=numbytes;i++)
	junk=getc(fp);
}

	


/*
 *  This internal routine will read a file, appending it to the activelist.
 *  It will first check to see if it has a valid Alto draw file header. If
 *  so, call the Alto read routine.
 */

ReadFile()
  {
    char *fname;
    File *fp, *fopen();
    ITEM_LIST_PTR **filtrans;
    short count, transcnt;
    short dx, dy;
    short aword,alto,sil;
    
    /* Get the file pointer */
    printf("Input file name?  ");
    if ((fname = GetString()) == NULL)
      {
	printf("Read File Aborted.\n\r");
	return;
      }
    if ((fp = fopen( fname, "r" )) == NULL)
      {
	printf("Error:  Couldn't open file '%s'.\n\r", fname);
	printf("Read File Aborted.\n\r");
	free( fname );
	return;
      }
    printf("Reading file '%s', please wait .", fname);
    
    /* Check the file header. */
    aword=getword(fp);
    fseek(fp,0,0);
    alto=0; sil=0;
    if (aword==0xffff) 
        alto=1;
    else if (aword==SILHEADER)
	sil=1;
    else { 
	fgets( fname, MAXLEN, fp );
	if (strcmp( fname, FILEHEADER ))
	  {
	    printf("\n\rFile not in current SUN or Alto Draw format.\n\r");
	    free( fname );
	    fclose( fp );
	    return;
	  }
    }
    if (alto)
	/* Read the Alto draw format file */
	altoread(fp);
    else if (sil)
	/* Read the SIL format file */
	silread(fp);
    else {
        /* Allocate the filnum to pointer translation buffer. */
        printf(".");
        transcnt = 100;
        if ((filtrans = (ITEM_LIST_PTR **)
	    calloc( transcnt, sizeof(ITEM_LIST_PTR *) )) == NULL)
        {
	    printf("\n\rOut of memory.  Can't read a file.\n\r");
	    free( fname );
	    fclose( fp );
	    return;
        }
        /* Read and load all of the referenced items in SUN format*/
	printf(".");
	fscanf( fp, "%hd %hd %hd ", &dx, &dy, &count );
	while( count != -1 )
	  {
	    ScanRead( dx, dy, count, filtrans, &transcnt, fp );
	    fscanf( fp, "%hd %hd %hd ", &dx, &dy, &count );
	  }
    }
    /* Update the display */
    RedrawActivelist( 0 );
    DisplayItem( sdf, mainSymbol, mainVgt );
    free( fname );
    fclose( fp );
    printf(". done.\n\r");
  }
