/*
 *  erase.c
 *
 *  This file contains the routines necessary to perform the erase
 *  (delete) command found on the Action Menu.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern EraseObject();
extern Checkpoint();
extern short SelectObject();
 
 
/* Exports */
extern ActErase();
 
 
/* Local Definitions */

/*
 *  This routine is the main driver for the erase command.  It will
 *  call SelectObject() to get the user to pick an object to be erased.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  erased.
 */
 
ActErase( cmd )
	enum MenuOptions cmd;
  {
    short selected, p1, p2, erasing;
    ITEM_LIST_PTR *victim;
    register ITEM_LIST_PTR *p, *q;
    
    /* Make ready */
    Checkpoint();
    erasing = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (erasing)
      {
	erasing = SelectObject( &victim, cmd, &p1, &p2,
		"ERASE:  Select an object type.", &selected, 0,
		0, NULL );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    erasing = 0;
	    break;
	  }
	
	/* Something was selected. */
	cmd = CNull;
	if (selected)
	  {
	    /* Everything was selected.  Delete Everything */
	    p = activelist->prev;
	    while (p)
	      {
	        q = p->next;
		EraseObject( p, 0 );
		p = q;
	      }
	    DisplayItem( sdf, mainSymbol, mainVgt );
	  }
	else if (victim)
	  {
	    /* Delete one object */
	    EraseObject( victim, 1 );
	  }
      }
  }
