/*
 *  drawpress.c
 *
 * This file contains one exported routine, DrawPress(), which generates
 * a press file from the current drawing and sends it to the dover.
 *
 * Gustavo Fernandez, October 23, 1984
 *
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
# include "vec.h"
# include "press.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern GetMisc();
extern char *GetString();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
extern CopyObject();
extern MoveObject();
extern NewObject();
extern NewGroup();
extern DrawPress();
 
 
/* Exports */
extern DrawPress();

/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# ifdef VAX
# define File FILE		/* Make files work on both machines */
# endif

/*
 *  This internal routine is a helper process for DrawPress().  This
 *  routine will scan the activelist, and draw each object.
 */
 
ScanDraw( ptr, xoff,yoff )
	ITEM_DESCRIPTOR *ptr;
	int xoff,yoff;
  {
    short i;
    ITEM_LIST_PTR *p;
    SPLINE *sptr;
    POINT *pptr;
    
    /* Stop when we run out of data. */
    if (ptr == NULL)
	return;	
	switch (ptr->type)
	  {
	    case TextObj:
	        /* Text.  Draw the text string. */
		{ /*decompose the font name into family, size and face*/
		    char rawname[50], *rawptr;
		    char *packname;
		    int size,face;
		    packname=FontData[ptr->subtype].fontname;
		    for (rawptr=rawname;*packname<'0'||*packname>'9';
			    rawptr++,packname++) *rawptr=(*packname);
		    *rawptr='\0';
		    for (size=0;*packname>='0'&&*packname<='9';packname++)
			size=size*10+*packname-'0';
		    face=ROMAN;
		    for (;*packname!='\0';packname++) {
		        if (*packname=='I') face+=ITALIC;
		        if (*packname=='B') face+=BOLD;	
		    };
		    VecFont(rawname,size,face);
		} 
		VecPosn(DrawToPix(ptr->xmin+xoff),DrawToPix(ptr->ymin+yoff));
		VecText(ptr->data); 
		break;
	    
	    case GroupObj:
	        /* Groups.  Print the group name, and its items. */
		p = (ITEM_LIST_PTR *) ptr->data;
		while (p)
		  {
		    ScanDraw( p->itemdesc, p->dx+xoff,p->dy+yoff );
		    p = p->next;
		  }
		break;
	    
	    default:
	        /* Splines.  Print the spline data. */
		sptr = (SPLINE *) ptr->data;
		if (sptr->filled)
		    printf("Sorry, Can't do filled objects.\n\r");
		pptr = &(sptr->head);
		VecNib(sptr->nib);
		VecSpline(sptr->numvert,pptr,sptr->order,sptr->closed,
				xoff,yoff);
		break;
	  }
  }

/*
 *  This routine will draw the activelist on a press file
 */
 
DrawPress()
  {
    short count;		/* Reachable item count */
    char *fname; 
    ITEM_DESCRIPTOR *id;
    ITEM_LIST_PTR *p;
    
    /* Discard ridiculous cases */
    if ((activelist->prev == NULL) || (itemlist == NULL))
      {
	printf("There is no point to printing an empty file.\n\r");
	return;
      }
    
    /* Get the file */
    printf("Press file name or <return> to send directly to the Dover\n\r");
    fname = GetString();
    VecInit(fname);
    printf("Generating press file, please wait...\n\r");
    for ( p = activelist->prev; p; p = p->next )
      {
	ScanDraw( p->itemdesc,p->dx,p->dy );
      }
    VecFinish("Press file generated by Sun draw program",0,0);
    printf("\rDone.\n\r");
  }
