/*
 *  verbs.c
 *
 * This file contains the user interface front ends for the object manipulation
 * verbs. The back-ends are in misc.c
 *
 * Gus Fernandez 4/14/85
 */
 
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern CopyObject();
extern MoveObject();
extern RotateObject();
extern ScaleObject();
extern EraseObject();
extern RaiseObject();
extern LowerObject();
extern Checkpoint();
extern short DefPoint();
extern double atan2();
extern double sqrt();
   
 
/* Exports */
extern CommandMove();
extern CommandCopy();
extern CommandErase();
extern CommandAlter();
extern CommandRotate();
extern CommandScale();
extern CommandStretch();
extern CommandGroup();
extern CommandRaise();
extern CommandLower();
extern CommandOpaque(); 
 
/* Local Definitions */
# define PI 3.1415926535


/*
 * The Copy user interface driver
 */

static POINT_DATA CopyPrompts[] =
  {
    { "Enter the starting point of the copy.", 0, 0, 0, },
    { "Enter the destination of the copy.", 0, 0, 0, },
  };
 
CommandCopy(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    register short deltax, deltay;
    
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to copy.\n\r");
	return;
      }

    if (DefPoint(CCopy,cmd,x,y,but,2,CopyPrompts,0)) {
	deltax = CopyPrompts[1].x - CopyPrompts[0].x;
	deltay = CopyPrompts[1].y - CopyPrompts[0].y;
	RaiseObject(CurrentObject,0);
        CopyObject( CurrentObject, deltax, deltay, 1 );
      }
  }

/*
 * The Move user interface driver - Very similar to CommandCopy
 */

static POINT_DATA MovePrompts[] =
  {
    { "Enter the starting point of the move.", 0, 0, 0, },
    { "Enter the destination of the move.", 0, 0, 0, },
  };
 
CommandMove(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    register short deltax, deltay;
    
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to move.\n\r");
	return;
      }

    if (DefPoint(CMove,cmd,x,y,but,2,MovePrompts,0)) {
	deltax = MovePrompts[1].x - MovePrompts[0].x;
	deltay = MovePrompts[1].y - MovePrompts[0].y;
	RaiseObject(CurrentObject,0);
        MoveObject( CurrentObject, deltax, deltay, 1 );
      }
  }

/*
 * The Rotate user interface driver
 */

static POINT_DATA RotatePrompts[] =
  {
    { "Enter the fixed point of the rotation.", 0, 0, 0, },
    { "Enter the starting point of the rotation.", 0, 0, 0, },
    { "Enter the ending point of the rotation.", 0, 0, 0, },
  };

CommandRotate(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    double theta;
    
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to rotate.\n\r");
	return;
      }

    if (DefPoint(CRotate,cmd,x,y,but,3,RotatePrompts,1)) {
	theta = atan2( (double) (RotatePrompts[2].x - RotatePrompts[0].x),
			(double) (RotatePrompts[2].y - RotatePrompts[0].y) ) -
		atan2( (double) (RotatePrompts[1].x - RotatePrompts[0].x),
			(double) (RotatePrompts[1].y - RotatePrompts[0].y) ) +
		(2 * PI); 
	while (theta > PI)
	    theta -= (2 * PI);
	RaiseObject(CurrentObject,0);
	RotateObject( CurrentObject, theta, 
		RotatePrompts[0].x, RotatePrompts[0].y, 1, 1 );
      }
  }

/*
 * The Scale user interface driver
 */

static POINT_DATA ScalePrompts[] =
  {
    { "Enter the fixed point of the scaling.", 0,0,0, },
    { "Enter a point at the initial distance from the fixed point.", 0,0,0, },
    { "Enter a point at the scaled distance from the fixed point.", 0,0,0, },
  };
 
CommandScale(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    double factor;
    int dx1, dx2, dy1, dy2;
    
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to scale.\n\r");
	return;
      }

    if (DefPoint(CScale,cmd,x,y,but,3,ScalePrompts,1)) {
	dx1 = ScalePrompts[1].x - ScalePrompts[0].x;
	dy1 = ScalePrompts[1].y - ScalePrompts[0].y;
	dx2 = ScalePrompts[2].x - ScalePrompts[0].x;
	dy2 = ScalePrompts[2].y - ScalePrompts[0].y;
	if ((dx1 == 0) && (dy1 == 0))
	  {
	    mprintf(2,"Scale factor is undefined with those points.\n\r");
	    return;
	  }
	else
	  {
	    factor = sqrt( (double) ((dx2 * dx2) + (dy2 * dy2)) ) /
		     sqrt( (double) ((dx1 * dx1) + (dy1 * dy1)) );
	  }
	RaiseObject(CurrentObject,0);
	ScaleObject(CurrentObject, factor, factor,
		ScalePrompts[0].x, ScalePrompts[0].y, 1, 1 );
      }
  }

/*
 * The Stretch user interface driver
 */

static POINT_DATA StretchPrompts[] =
  {
    { "Enter the fixed point of the stretch.", 0,0,0, },
    { "Enter the point to stretch FROM.", 0,0,0, },
    { "Enter the point to stretch TO.", 0,0,0, },
  };
 
CommandStretch(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    double factorx,factory;
    int dx1, dx2, dy1, dy2;
    
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to stretch.\n\r");
	return;
      }

    if (DefPoint(CStretch,cmd,x,y,but,3,StretchPrompts,1)) {
	dx1 = StretchPrompts[1].x - StretchPrompts[0].x;
	dy1 = StretchPrompts[1].y - StretchPrompts[0].y;
	dx2 = StretchPrompts[2].x - StretchPrompts[0].x;
	dy2 = StretchPrompts[2].y - StretchPrompts[0].y;
	if ((dx1 == 0) && (dy1 == 0))
	  {
	    mprintf(2,"Scale factor is undefined with those points.\n\r");
	    return;
	  }
	else
	  {
	    factorx = dx1<8 && dx1 > -8 ?1.:((double) dx2)/((double) dx1);
	    factory = dy1<8 && dy1 > -8 ?1.:((double) dy2)/((double) dy1);
	  }
	RaiseObject(CurrentObject,0);
	ScaleObject(CurrentObject, factorx, factory,
		StretchPrompts[0].x, StretchPrompts[0].y, 1, 1 );
      }
  }

/*
 * The Erase user interface driver - No prompts. Undo will bail us out.
 */
 
CommandErase(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to erase.\n\r");
	return;
      }
    Checkpoint();
    EraseObject(CurrentObject,1);
  }

/*
 * The Raise user interface driver
 */
 
CommandRaise(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to bring to the front.\n\r");
	return;
      }
    Checkpoint();
    RaiseObject(CurrentObject,1);
  }

/*
 * The Lower user interface driver 
 */
 
CommandLower(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
  {
    if (!CurrentObject) 
      {
        mprintf(2,"You haven't selected anything to push to the back.\n\r");
	return;
      }
    Checkpoint();
    LowerObject(CurrentObject,1);
  }

/*
 * Alter command user interface driver
 */

CommandAlter(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;

{
  mprintf(2,"Alter is still under construction\n\r");
}

/*
 * Group command user interface driver
 */

CommandGroup(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;

{
  mprintf(2,"Group is still under construction\n\r");
}

/*
 * Opaque command user interface driver
 */

CommandOpaque(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;

{
    if (!CurrentObject) {
        mprintf(2,"You haven't selected anything to change opaqueness of.\n\r");
	return;
    }
    Checkpoint();
    AttribObject(CurrentObject,1,-1,-2,-1,-1);
}
