/*
 *  nouns.c
 *
 *  This routine contains the dispatch handlers for all of the nouns
 *  (curves, polygons, text, etc.) Most of these routines only handle
 *  the special cases, and call IndefPoint or DefPoint to receive a
 *  definite or indefinite number of points.
 *
 *  Gus Fernandez 4/26/85
 */

/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */

    extern double sin();
    extern double cos();
    extern double atan2();
    extern double sqrt(); 
    extern char *GetString();
    extern Checkpoint();
    extern RevertToCKP();
    extern NewObject();
    extern IndefPoint();
    extern DefPoint();
    extern SetCurrentCommand();
    extern short GetINum();		/* Get an item number */
    extern short GetSeqINum();	/* Get a sequential set of item numbers */
    extern short LastINum();	/* Return the last item number gotten
    extern short FreeINum();	/* Return an item number to the freelist */

/* exports */

    extern CommandOpenPolygon();
    extern CommandOpenCurve();
    extern CommandWideOpenArrow();
    extern CommandWideClosedArrow();
    extern CommandNarrowOpenArrow();
    extern CommandNarrowClosedArrow();
    extern CommandClosedPolygon();
    extern CommandClosedCurve();
    extern CommandClosedCircle();
    extern CommandClosedElipse();
    extern CommandClosedRectangle();
    extern CommandPressEditSymbol();
    extern CommandFilledPolygon();
    extern CommandFilledCurve();
    extern CommandFilledCircle();
    extern CommandFilledElipse();
    extern CommandFilledRectangle();
    extern CommandText();

/* Local Definitions */
# define ARROWLEN	8	/* Length of the side of an arrowhead */

/*
 * The six spline objects are handled almost identically by IndefPoint 
 */

CommandOpenPolygon(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   IndefPoint(COpenPolygon,cmd,x,y,but,0,2,0,OpenPolygonObj);
}

CommandClosedPolygon(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   IndefPoint(CClosedPolygon,cmd,x,y,but,1,2,0,ClosedPolygonObj);
}

CommandFilledPolygon(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   IndefPoint(CFilledPolygon,cmd,x,y,but,1,2,1,ClosedPolygonObj);
}

CommandOpenCurve(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   IndefPoint(COpenCurve,cmd,x,y,but,0,3,0,OpenSplineObj);
}

CommandClosedCurve(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   IndefPoint(CClosedCurve,cmd,x,y,but,1,3,0,ClosedSplineObj);
}

CommandFilledCurve(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   IndefPoint(CFilledCurve,cmd,x,y,but,1,3,1,ClosedSplineObj);
}



/*
 * This is code common to all of the arrow routines.
 */

MakeArrow(ourtype,cmd,x,y,but,wide,closed,temptype)
enum TemplateTypes temptype;
enum MenuOptions ourtype,cmd;
short x,y,but,wide,closed;

{
    SPLINE *sptr;
    POINT *vert;
    double theta;
    short x1,x2,y1,y2;
    static POINT_DATA ArrowPrompts[] = {
        { "Click on the tip of the arrowhead.", 0, 0, 0, },
        { "Click on the root of the arrowhead.", 0, 0, 0, },
    };
    if (DefPoint(ourtype,cmd,x,y,but,2,ArrowPrompts,1)) {
	if ((sptr = (SPLINE *)malloc( sizeof(SPLINE) + 2*sizeof(POINT) ))
		    == NULL)
	    {
	        printf("Out of memory.  Can't allocate arrowhead.\n\r");
		return;
	    }
	x1=ArrowPrompts[0].x;
	x2=ArrowPrompts[1].x;
	y1=ArrowPrompts[0].y;
	y2=ArrowPrompts[1].y;
	sptr->order = 2;
	sptr->numvert = 3;
	sptr->nib = (enum Nib) ((int) DefaultNib % 4 + (int) NibCircle0);
	sptr->border = 1;
	sptr->closed = closed;
	sptr->filled = sptr->closed;
	sptr->opaque = 1;
	sptr->pat = PatBlack;
	vert = &(sptr->head);  

	/* Calculate the angles needed, using (groan) floating point */
	theta = atan2( (double) (x2 - x1), (double) (y2 - y1) );
		
	/* Place the real control points of the spline */
	if (!wide)
	    {
		vert[0].x = ARROWLEN * sin( theta - 0.3 ) + x1 + 0.5;
		vert[0].y = ARROWLEN * cos( theta - 0.3 ) + y1 + 0.5;
		vert[1].x = x1;
		vert[1].y = y1;
		vert[2].x = ARROWLEN * sin( theta + 0.3 ) + x1 + 0.5;
		vert[2].y = ARROWLEN * cos( theta + 0.3 ) + y1 + 0.5;
	     }
	else
	     {
		vert[0].x = ARROWLEN * sin( theta - 0.75 ) + x1 + 0.5;
		vert[0].y = ARROWLEN * cos( theta - 0.75 ) + y1 + 0.5;
		vert[1].x = x1;
		vert[1].y = y1;
		vert[2].x = ARROWLEN * sin( theta + 0.75 ) + x1 + 0.5;
		vert[2].y = ARROWLEN * cos( theta + 0.75 ) + y1 + 0.5;
	     }
	NewObject( sptr, TemplateObj, (short) temptype, 0,
		    0, 0, 0, 0, 0, NULL, 1, 0, 0 );
    }
}

/* The four arrow drawing routines */

CommandWideOpenArrow(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   MakeArrow(CWideOpenArrow,cmd,x,y,but,1,0,WideArrowO);
/*
   MakeThingamagig(CWideOpenArrow,cmd,x,y,but);
*/
}

CommandWideClosedArrow(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   MakeArrow(CWideClosedArrow,cmd,x,y,but,1,1,WideArrowC);
}

CommandNarrowOpenArrow(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   MakeArrow(CNarrowOpenArrow,cmd,x,y,but,0,0,NarArrowO);
}

CommandNarrowClosedArrow(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   MakeArrow(CNarrowClosedArrow,cmd,x,y,but,0,1,NarArrowC);
}

/*
 * This is the code common to rectangles, elipses, and circles
 */

Make4vert(ourtype,cmd,x,y,but,order,filled,prompts,temptype)
enum TemplateTypes temptype;
enum MenuOptions ourtype,cmd;
short x,y,but,order,filled;
POINT_DATA prompts[];

{
    SPLINE *sptr;
    POINT *vert;
    double radius;
    short x1,x2,y1,y2;
    SetCurrentObject(NULL,1);
    if (DefPoint(ourtype,cmd,x,y,but,2,prompts,1)) {
	if ((sptr = (SPLINE *) malloc( sizeof(SPLINE) + 4*sizeof(POINT) ))
		    == NULL)
	    {
	        printf("Out of memory. Can't allocate 4-vertex template.\n\r");
		return;
	    }
	x1=prompts[0].x;
	x2=prompts[1].x;
	y1=prompts[0].y;
	y2=prompts[1].y;
	sptr->order = order;
	sptr->numvert = 4;
	sptr->nib = DefaultNib;
	sptr->border = ((int)DefaultNib>0);
	sptr->closed = 1;
	sptr->filled = filled;
	sptr->opaque = 1;
	sptr->pat = DefaultPat;
	vert = &(sptr->head);  
	if (order <=3) { /* rectangles, elipses	 */
	    vert[0].x = min(x1, x2);
	    vert[0].y = min(y1, y2);
	    vert[1].x = min(x1, x2);
	    vert[1].y = max(y1, y2);
	    vert[2].x = max(x1, x2);
	    vert[2].y = max(y1, y2);
	    vert[3].x = max(x1, x2);
	    vert[3].y = min(y1, y2);
	}
	else { /* circles */
	    radius = 1.6970562 *
	    		sqrt( (double) ((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1)) );
	    vert[0].x = x1;
	    vert[0].y = y1 + radius;
	    vert[1].x = x1 + radius;
	    vert[1].y = y1;
	    vert[2].x = x1;
	    vert[2].y = y1 - radius;
	    vert[3].x = x1 - radius;
	    vert[3].y = y1;
	}
	NewObject( sptr, TemplateObj, (short) temptype, 0,
		    0, 0, 0, 0, 0, NULL, 1, 0, 0 );
    }
}

/*
 * the six four-vertex drivers 
 */

static POINT_DATA RectPrompts[] =
  {
    { "Click on one corner of the rectangle.", 0, 0, 0, },
    { "Click on the opposite corner of the rectangle.", 0, 0, 0, },
  };

CommandClosedRectangle(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   Make4vert(CClosedRectangle,cmd,x,y,but,2,0,RectPrompts,Rectangle);
}

CommandFilledRectangle(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   Make4vert(CFilledRectangle,cmd,x,y,but,2,1,RectPrompts,Rectangle);
}

static POINT_DATA ElipsePrompts[] =
  {
    { "Click on one corner of the rectangle inscribing the elipse.", 0, 0, 0, },
    { "Click on the opposite corner of the rectangle inscribing the elipse.", 0, 0, 0, },
  };

CommandClosedElipse(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   Make4vert(CClosedElipse,cmd,x,y,but,3,0,ElipsePrompts,Oval);
}

CommandFilledElipse(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   Make4vert(CFilledElipse,cmd,x,y,but,3,1,ElipsePrompts,Oval);
}

static POINT_DATA CirclePrompts[] =
  {
    { "Click on the center of the circle.", 0, 0, 0, },
    { "Click on any point along the edge of the circle.", 0, 0, 0, },
  };

CommandClosedCircle(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   Make4vert(CClosedCircle,cmd,x,y,but,5,0,CirclePrompts,Circle);
}

CommandFilledCircle(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   Make4vert(CFilledCircle,cmd,x,y,but,5,1,CirclePrompts,Circle);
}

/*
 * This is the common code for the text routines (Text and PressEditSymbol)
 */

MakeText(ourtype,cmd,x,y,but)
enum MenuOptions ourtype,cmd;
short x,y,but;
  {
    static char *pedit = "<==<<";
    char *string;
    short x1, x2, slength, bmin, bmax;
    static short centering;
    static POINT_DATA TextPrompts[] =
      {
        {"Click on the bottom right corner of the text line.", 0, 0, 0, },
	{"Click on the bottom center of the text line.", 0 ,0, 0, },
	{"Click on the bottom left corner of the text line.", 0, 0, 0, },
	{"Click on the bottom left of the PressEdit symbol.", 0, 0, 0, },
      };    

    if (ourtype==CPressEditSymbol)
	centering = 3;
    else if (cmd==ourtype) {
	centering=DefaultCentering;
	SetCurrentObject(NULL,1);
    }
    if (DefPoint(ourtype,cmd,x,y,but,1,&TextPrompts[centering],0)) {
	if (ourtype == CPressEditSymbol)
	    string = pedit;
	else
            string = GetString();
        if (string == NULL) return;

	if (!LoadFont(DefaultFont)) return;		
	/* Compute the true baseline reference point */
	OpenMainSymbol();
	AddItem( sdf, GetINum(), 0, 0, 0, 0,
		FontData[DefaultFont].refnumber, SDF_TEXT, string );
	if (InquireItem( sdf,LastINum(),0,&slength,&bmin,&bmax,0,0,0 ) == 0) {
	    printf("Internal Error: InquireItem failed (slength).\n\r");
	    free( string );
	    DeleteItem( sdf, LastINum() );
	    FreeINum(LastINum());
	    return;
	}
	DeleteItem( sdf, LastINum() );
	FreeINum(LastINum());
	x=TextPrompts[centering].x;
	y=TextPrompts[centering].y;
	switch (centering) {
	    case PositionRight:
		x1 = x - slength;
		x2 = x;
		break;
		    
	    case PositionCenter:
		x1 = x - (slength >> 1);
		x2 = x + (slength >> 1);
		break;
			
	    case PositionLeft:
	    case 3:  /* fudge for PressEditSymbol */
		x1 = x;
		x2 = x + slength;
		break;
	}
	NewObject( string, TextObj, DefaultFont, centering,
	    x1, x2, y, y+bmax-bmin, -bmin, NULL, 1, 0, 0 );
	SetCurrentCommand(CNull);
      }
  }

/*
 * The Text and PressEditSymbol drivers
 */

CommandText(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   MakeText(CText,cmd,x,y,but);
}

CommandPressEditSymbol(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
   MakeText(CPressEditSymbol,cmd,x,y,but);
}

#if 0
/*
 * This is code to make a thingamagig to test a line interesct routine.
 */

MakeThingamagig(ourtype,cmd,x,y,but)
enum MenuOptions ourtype,cmd;
short x,y,but;

{
    SPLINE *sptr;
    POINT *vert;
    double theta;
    int x1,x2,x3,x4,x5,y1,y2,y3,y4,y5;
    static POINT_DATA ThingPrompts[] = {
        { "Click on point 1, line 1 of the thingamagig.", 0, 0, 0, },
        { "Click on point 2, line 1 of the thingamagig.", 0, 0, 0, },
        { "Click on point 1, line 2 of the thingamagig.", 0, 0, 0, },
        { "Click on point 2, line 2 of the thingamagig.", 0, 0, 0, },
    };
    if (DefPoint(ourtype,cmd,x,y,but,4,ThingPrompts,1)) {
	if ((sptr = (SPLINE *)malloc( sizeof(SPLINE) + 7*sizeof(POINT) ))
		    == NULL)
	    {
	        printf("Out of memory.  Can't allocate thingamagig.\n\r");
		return;
	    }
	x1=ThingPrompts[0].x;
	x2=ThingPrompts[1].x;
	x3=ThingPrompts[2].x;
	x4=ThingPrompts[3].x;
	y1=ThingPrompts[0].y;
	y2=ThingPrompts[1].y;
	y3=ThingPrompts[2].y;
	y4=ThingPrompts[3].y;
	if (!intersect(x1,y1,x2,y2,x3,y3,x4,y4,&x5,&y5)) {
	    mprintf(2,"lines do not intersect\n\r");
	    return;
	}
	sptr->order = 2;
	sptr->numvert = 6;
	sptr->nib = (enum Nib) ((int) DefaultNib % 4 + (int) NibCircle0);
	sptr->border = 1;
	sptr->closed = 1;
	sptr->filled = sptr->closed;
	sptr->opaque = 1;
	sptr->pat = PatBlack;
	vert = &(sptr->head);  

	vert[0].x = vert[3].x = x5;
	vert[0].y = vert[3].y = y5;
	vert[1].x = x1; vert[1].y = y1;
	vert[2].x = x3; vert[2].y = y3;
	vert[4].x = x2; vert[4].y = y2;
	vert[5].x = x4; vert[5].y = y4;
	NewObject( sptr, TemplateObj, (short) 0, 0,
		    0, 0, 0, 0, 0, NULL, 1, 0, 0 );
    }
}
#endif
