/*
 * menu.c
 *
 * This file contains all of the routines to hilight and unhilight the
 * various parts of the main menu.
 *
 *   Gus Fernandez  May, 1985
 */

/* Includes */

# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
# include "icons.h"
# include "menu.h"

/* Imports */

extern ICON_DESCRIPTOR IconList[];
extern short DefaultNibItem,DefaultPatItem;
extern short FontItem,MesgItem,MesgAge,MesgLines;
extern short DrawSetup;
extern char *GetString();
extern short GetINum();		/* Get an item number */
extern short GetSeqINum();	/* Get a sequential set of item numbers */
extern short LastINum();	/* Return the last item number gotten
extern short FreeINum();	/* Return an item number to the freelist */
extern short WritePSM();	/* output a PSM file for Postscript */

/* Exports */
extern Highlight();		/* Highlight a menu selection. */
extern SetCurrentCommand();	/* Sets the current state. */


/*
 *  This routine is used to put a string into inverse video, and visa
 *  versa.  Text is inverted using the recognized convention of setting
 *  the higher order bit to 1 to indicate inverse video.
 */
 
InvertString( s,state )
	char *s;
	short state;
  {
    while (*s)
      {
	if (state==1)
	   *s++ |= 0200;
	else
	   *s++ &= 0177;
      }
  }

/*
 *  This routine will toggle the hilighting of a command menu option.
 *  state=1 to hilight inverted, 0 for normal, 2 for special
 */
 
HilightCommand(cmd,state)
	enum MenuOptions cmd;
	short state;
  {
    short x1, x2, y1, y2,slot,titem,j1,j2,oldstate;
    
    slot = (int) cmd - C_COMMANDS;
    titem = Commands[slot].itemno;
    oldstate = Commands[slot].state;
    if (state==oldstate) return;

    j1 = ComdXMin + (slot % CMDROW) * (65+GAP0);
    j2 = ComdYMin + (CMDCOL - 1 - (slot / CMDROW)) * (32+GAP0);

    InvertString( Commands[slot].string,state );
    
    /* Display the new string */
    CloseMainSymbol(1);
    EditSymbol( sdf, menuSymbol );
    InquireItem( sdf, titem, &x1, &x2, &y1, &y2, 0, 0, NULL );
    ChangeItem( sdf, titem, x1, x2, y1, y2,
	0, SDF_SIMPLE_TEXT, Commands[slot].string );
    if (oldstate != 0) {
	DeleteItem( sdf, titem + 1 );
	if (oldstate==1) {
	    DeleteItem( sdf, titem + 2 );
	    DeleteItem( sdf, titem + 3 );
	    DeleteItem( sdf, titem + 4 );
        }
    }
    if (state==1)
      {
	/* Insert some filler so that entire menu box is blacked out. 
	   There are fudge factors for the right and top sides which
	   might break if the VGTS ever does anything more reasonable!! 
	   these four lines fill in the left, right, bottom, and top borders
	   respectively. */
	AddItem( sdf, titem + 1, j1, x1 , j2, j2+31,
		BLACK, SDF_FILLED_RECTANGLE, (char *)NULL );
	AddItem( sdf, titem + 2, x2-2 ,j1+64, j2, j2+31,
		BLACK, SDF_FILLED_RECTANGLE, (char *)NULL );
	AddItem( sdf, titem + 3, j1, j1+64, j2, y1,
		BLACK, SDF_FILLED_RECTANGLE, (char *)NULL );
	AddItem( sdf, titem + 4, j1, j1+64 , y2-7, j2+31,
		BLACK, SDF_FILLED_RECTANGLE, (char *)NULL );
      }
    else if (state==2)
      {
	/* Create a heavier outline just inside the normal one for 'special'
	   hilghting */
	AddItem( sdf, titem + 1,j1+2,j1+62,j2+2,j2+29,AllEdges,
		SDF_OUTLINE,(char *)NULL);
      }
    EndSymbol( sdf, menuSymbol, menuVgt );
    Commands[slot].state = state;
  }

/*
 *  This routine will toggle the hilighting of an icon (noun or verb)
 *  menu option. State=TRUE to hilight, FALSE for regular
 */
 
HilightIcon(cmd,state)
	enum MenuOptions cmd;
	short state;
  {
    short slot,titem;
    short j;
    ICON_DESCRIPTOR *p;
    
    slot = (int) cmd - C_NOUNS;
    p = &IconList[slot];
    titem = p->itemnum;
    /* Display the new icon */
    CloseMainSymbol(1);
    EditSymbol( sdf, menuSymbol );
    j = MemoryRaster;
    if (state) j|= InverseRaster;
    DeleteItem( sdf, titem);
    AddItem( sdf, titem, p->xmin, p->xmax, p->ymin, p->ymax,
		j,SDF_RASTER,p->data);
    EndSymbol( sdf, menuSymbol, menuVgt );
  }

/*
 * This command calls the various hilight routines depending on what
 * command was called.
 */

Hilight (cmd,subcmd,state)
enum MenuOptions cmd;
short state,subcmd;

{
       if (cmd==CNull) return;
  else if ((int)cmd < C_COMMANDS) HilightIcon(cmd,state);
  else if ((int)cmd < (int)CNib)    HilightCommand(cmd,state);
}
/*
 * This is called by various routines that want to set the current command.
 */
SetCurrentCommand(cmd)
enum MenuOptions cmd;
{
   if (CurrentCommand!=CNull && cmd == CNull)
	Hilight(CurrentCommand,0,FALSE);
   CurrentCommand=cmd;
}

/* 
 * this routine will change the current selection in the nib menu
 */
SetCurrentNib(nib)
enum Nib nib;

{
    short j1,j2;
    if (DefaultNib==nib) return;
    CloseMainSymbol(1);
    EditSymbol( sdf, menuSymbol );
    if (DefaultNibItem >0) {
	DeleteItem(sdf,DefaultNibItem);
    }
    else
	DefaultNibItem = GetINum();
    j1 = NibXMin+8+(16+GAP0)*((int)nib % 4);
    j2 = NibYMax-8-(16+GAP0)*((int)nib / 4);
    AddItem(sdf,DefaultNibItem,j1-8,j1+8,j2-8,j2+8,AllEdges,SDF_OUTLINE,
	(char*)NULL);
    EndSymbol( sdf, menuSymbol, menuVgt );
    DefaultNib=nib;
}

/* 
 * this routine will change the current selection in the pattern menu
 */
SetCurrentPat(pat)
enum Pattern pat;

{
    short j1,j2;
    if ((int) pat>0 && DefaultPat!=(enum Pattern)((int)pat-1)) {
	CloseMainSymbol(1);
        EditSymbol( sdf, menuSymbol );
        if (DefaultPatItem >0) {
	    DeleteItem(sdf,DefaultPatItem);
	}
	else
	    DefaultPatItem = GetINum();
    	j1 = StipXMin + ((16+GAP0)*((int)pat % STIPROW));
    	j2 = StipYMAX - ((16+GAP0)*((int)pat / STIPROW));
    	AddItem(sdf,DefaultPatItem,j1-2,j1+17,j2-17,j2+2,
		AllEdges,SDF_OUTLINE,(char *)NULL);
    	EndSymbol( sdf, menuSymbol, menuVgt );
    	DefaultPat=(enum Pattern)((int)pat-1);
    }
}

/*
 * These are the pop-up items for the print menu
 * New printer names will be inserted in the extra spaces provided.
 */
static PopUpEntry PrintMenu[] =
  {
    "Press file",		0,
    "  Dover",			1,
    "  Rover",			2,
    "  Plover",			3,
    "Postscript file (print later)",4,
    "Postscript file (scribe)",	5,
    NULL,			6,
    NULL,			7,
    NULL,			8,
    NULL,			9,
    NULL,			10,
    NULL,			11,
    NULL,			12,
    NULL,			13,
    NULL,			14,
    NULL,			15,
    NULL,			16,
  };

/*
 *  This is the menu routine to call one of the various print drivers
 */
 
DoPrint()
{
    short i;
    char *fname,*pname; 
    float xsize,ysize;
    
    /* Discard ridiculous cases */
    if ((activelist->prev == NULL) || (itemlist == NULL))
      {
	mprintf(2,"There is no point to printing an empty file.\n\r");
	return;
      }
    SearchPrinters();
    i = GetPopup( PrintMenu );
    if (i < 0) return;

    switch(i) {
	case 0: /* Press file */
    	    mprintf(1,"Type Press file name or <return> to cancel");
    	    fname = GetString();
	    if (fname != NULL) {
		mprintf(1,"Writing PRESS file \"%s\"",fname);
		DrawPress(fname,NULL);
		mprintf(2,"Done!");
	    }
	    else mprintf(2,"Printing canceled!");
	    break;
	case 1:	/* Dover */
	    mprintf(1,"creating PRESS file for the Dover...");
	    DrawPress(NULL,"dover");
	    mprintf(2,"Done printing!");
	    break;
	case 2:	/* Rover */
	    mprintf(1,"creating PRESS file for the Rover...");
	    DrawPress(NULL,"rover");
	    mprintf(2,"Done printing!");
	    break;
	case 3:	/* Plover */
	    mprintf(1,"creating PRESS file for the Plover...");
	    DrawPress(NULL,"plover");
	    mprintf(2,"Done printing!");
	    break;
	case 4: /* PostScript file (print later) */
	case 5: /* PostScript file (include in document) no header */
    	    mprintf(1,"Type Postscript file name \n or <return> to cancel");
    	    fname = GetString();
	    if (fname != NULL) {
		mprintf(1,"Writing Postscript file \"%s\"",fname);
		if (WritePSM(i==4,i==4 ? PRINTER_DEST : DOCUMENT_DEST,
		    fname,&xsize,&ysize,(char *)NULL))
		    mprintf(6,"Document is %4.2f inches wide\nby %4.2f inches tall",xsize,ysize);
	    }
	    else mprintf(2,"Printing canceled!");
	    break;
	default: /* A random Postscript printer */
	    pname = PrintMenu[i].string+2;	/*skip two indenting spaces */
	    mprintf(1,"creating Postscript file for %s...",pname);
	    if (WritePSM(1,PRINTER_DEST,(char *)NULL,&xsize,&ysize,pname))
	        mprintf(2,"Done printing!");
	    break;
      }
}

/*
 * WARNING - Altoread accesses certain font numbers directly. Check load.c
 * and init.c as well - GAF
 */
static PopUpEntry Font1Menu[] =
  {
    "Clarity 12",		0,
    "Cream 12",			1,
    "Helvetica 10",		2,
    "Helvetica 10 Bold",	3,
    "Helvetica 18",		4,
    "Helvetica 7",		5,
    "Helvetica 7 Bold",		6,
    "Helvetica 7 Bold Italic",	7,
    "Helvetica 7 Italic",	8,
    "Helvetica 12",		9,
    "Helvetica 12 Bold",	10,
    "Helvetica 12 Italic",	11,
    "TimesRoman 12",		12,
    "TimesRoman 12 Bold",	13,
    "TimesRoman 12 Italic",	14,
    NULL,			0,
  };
    
static PopUpEntry Font2Menu[] =
  {
    "APL 14",			15,
    "Ascii 12",			16,
    "CMR 12",			17,
    "Cyrillic 12", 		18,
    "Gates 32",			19,
    "Greek 12",			20,
    "Hebrew 12",		21,
    "Math 12",			22,
    "Old English 18",		23,
    "Template 64",		24,
    NULL,			0,
  };

/*
 *  These routines will call up the pop-up menus to select a new font.
 *
 *  Future work:  Let the user name his own font.
 */
 
GetNewFont(menu,newcenter)
	short menu;
	short newcenter;
{
    short i;
    
    if (newcenter <0)
	newcenter=DefaultCentering;
    i= -1;
    if (menu == 1)
	i = GetPopup( Font1Menu );
    else if (menu == 2)
	i = GetPopup( Font2Menu );
    if (i < 0)
	i = DefaultFont;
    SetCurrentFont(i,newcenter);
    if (CurrentObject != NULL) {
	Checkpoint();
	AttribObject(CurrentObject,0,-1,-2,i,DefaultCentering);
  }
}



/* SetCurrentFont will set the default font and place its name (in its own
 * face) in the font window.
 */
SetCurrentFont(newfont,newcentering)
short newfont;

{
    short bmin,bmax,slength,x,y,index;
    char *s;
    if (DefaultFont==newfont && DefaultCentering==newcentering) 
	return;
    if (!LoadFont(newfont)) 
	return;
    CloseMainSymbol(1);
    EditSymbol( sdf, menuSymbol );
    if (FontItem >0) {
	DeleteItem(sdf,FontItem);
    }
    else
	FontItem = GetINum();
    if (newfont<(index=sizeof(Font1Menu)/sizeof(PopUpEntry)-1))
	s = Font1Menu[newfont].string;
    else
	s = Font2Menu[newfont-index].string;
    index=newfont;
    AddItem(sdf,FontItem,0,0,0,0,FontData[newfont].refnumber, SDF_TEXT,s);
    InquireItem(sdf,FontItem,(char *)0,&slength,&bmin,&bmax,0,0,0);
    DeleteItem(sdf,FontItem);
    DefaultCentering=newcentering;
    switch(DefaultCentering) {
	case PositionRight:
	    x = FontXMax - slength -5;
	    break;
	case PositionCenter:
    	    x = FontXMin + (FontXMax-FontXMin-slength)/2;
	    break;
	case PositionLeft:
	    x = FontXMin + 5;
	    break;
    }
    y = FontYMin + (FontYMax-FontYMin-bmax+bmin)/2;
    AddItem(sdf,FontItem,x,0,y,0,FontData[newfont].refnumber, SDF_TEXT,s);
    EndSymbol( sdf, menuSymbol, menuVgt );
    DefaultFont=newfont;
}

/* This routine flashes a message in the message box of the menu window 
   Uses standard printf parameters. control characters are ignored, but
   James Bond does beep. Age is the number of GetInputs before the message
   goes away (0 = permanent) */

/*VARARGS2*/
#define MESGFONT 3 /* Helvetica 10 bold*/
mprintf(age,pattern,p0,p1,p2,p3,p4,p5,p6,p7,p8,p9)
char *pattern;
short age;

{
    char temp1[100],temp2[100],temp3[100];
    char *p,*q,ch;
    short bmin,bmax,slength,x,y;
    short JamesBond = 0;
    short twolines = 0;

    if (DrawSetup) return;   
    sprintf(temp1,pattern,p0,p1,p2,p3,p4,p5,p6,p7,p8,p9);
    p = temp1;
    q = temp2;
    if (Debug&DebugMessages) {
	printf(temp1);
	if ((ch =temp1[strlen(temp1)-1])!='\r' && ch !='\n')
	    printf("\n\r");
    }
    while (ch = *p++) {
	if (ch >= 32) *q++ = ch;
	else if (ch == 7) JamesBond = 1;
	else if (ch == 10 && !twolines && strlen(temp2) > 1) {
	    twolines = 1;
	    *q++ = '\0';
	    q = temp3;
	}
    }
    *q++ = '\0';
    if (twolines && strlen(temp3) <2)
	twolines = 0;
    if (!LoadFont(MESGFONT))
	return;
    CloseMainSymbol(1);
    EditSymbol( sdf, menuSymbol );
    if (MesgLines >0) {
	DeleteItem(sdf,MesgItem);
	if (MesgLines>1)
	    DeleteItem(sdf,MesgItem+1);
    }
    if (MesgItem <= 0) {
	MesgItem = GetSeqINum(2);
    }
    AddItem(sdf,MesgItem,0,0,0,0,FontData[MESGFONT].refnumber, SDF_TEXT,temp2);
    InquireItem(sdf,MesgItem,0,&slength,&bmin,&bmax,0,0,0);
    DeleteItem(sdf,MesgItem);
    x = MesgXMin + 5;
    if (twolines) {
        y = MesgYMin + (MesgYMax-MesgYMin-bmax+bmin)/5;
        AddItem(sdf,MesgItem,x,0,y,0,FontData[MESGFONT].refnumber,
		 SDF_TEXT,temp3);
        y = MesgYMin + (4*(MesgYMax-MesgYMin-bmax+bmin))/5;
        AddItem(sdf,MesgItem+1,x,0,y,0,FontData[MESGFONT].refnumber,
		 SDF_TEXT,temp2);
    }
    else {
        y = MesgYMin + (MesgYMax-MesgYMin-bmax+bmin)/2;
        AddItem(sdf,MesgItem,x,0,y,0,FontData[MESGFONT].refnumber,
		 SDF_TEXT,temp2);
    }
    MesgLines = (twolines ? 2 : 1);
    EndSymbol( sdf, menuSymbol, menuVgt );
    if (JamesBond) printf("\007");
    MesgAge = age;
}

/* This routine ages and deletes messages. if ageflag = 1, then aging
 * takes place and the message will not be deleted until MesgAge reaches 0.
 * ageflag = 0 is an unconditional delete.
 */

DeleteMessage(ageflag)

{
    if (ageflag && --MesgAge != 0) return;
    if (MesgLines >0) {
	CloseMainSymbol(1);
        EditSymbol( sdf, menuSymbol );
	DeleteItem(sdf,MesgItem);
	if (MesgLines > 1)
	    DeleteItem(sdf,MesgItem+1);
        EndSymbol( sdf, menuSymbol, menuVgt );
	MesgLines = 0;
    }
}

/*
 * This routine will look for valid Postscript printers which the current
 * UNIX host knows about. All Draw printing goes through UNIX anyway so this
 * is semi-legit, even in a V environment. Eventually, it would be nice to
 * have a V print spooling mechanism, at which time, this might need to be 
 * changed. The current scheme reads /etc/printcap looking for printers with
 * the words "Postscript" or "LaserWriter" on the first line of the entry.
 * It then puts the first name on the line in the pop-up menu. This is also
 * the parameter given to the -P option in lpr.
 */

#define PRINTER_CONFIG_FILE 	"/etc/printcap"
#define FIRST_PRINTER_SLOT 	6
#define NUM_PRINTER_SLOTS	10
#define SEARCH_STRING_1		"laserwriter"
#define SEARCH_STRING_2		"postscript"
#define CONFIG_FILE_LINE_LENGTH 100
#define PRINTER_NAME_LENGTH     30

SearchPrinters()
  {
    short curslot = FIRST_PRINTER_SLOT;
    FILE *f;
    char *t,*tp,*sp;
    char s[CONFIG_FILE_LINE_LENGTH];

    if (PrintersSearched)
	return;
    PrintersSearched = TRUE;
    mprintf(1,"Searching for available printers...");
    if ((f=fopen(PRINTER_CONFIG_FILE,"r"))==NULL)
	return;
    while (!feof(f) && curslot < FIRST_PRINTER_SLOT + NUM_PRINTER_SLOTS) {
    fgets (s, CONFIG_FILE_LINE_LENGTH, f);
    if (*s == ' ' || *s == '\t' || *s == '#' || *s == '\n')
	continue;		/* not an entry header line */
    if (stringsearch (s, SEARCH_STRING_1) ||
	    stringsearch (s, SEARCH_STRING_2)) {
    /* We found a printer. Now enter it into the Popup menu */
	if ((t = (char *) malloc (PRINTER_NAME_LENGTH)) == NULL) {
	    printf ("Out of memory. Could not allocate a printer name.\n\r");
	    return;
	}
	t[0] = ' ';
	t[1] = ' ';
	tp = t + 2;
	sp = s;
	while (*sp != '|' && *sp != ':' && *sp != '\0' &&
		sp - s < PRINTER_NAME_LENGTH) {
	    *tp++ = *sp++;
	}
	*tp = '\0';
	PrintMenu[curslot++].string = t;
	}
    }
    fclose(f);
    mprintf(1," ");
}

/*
 *  This is just a dumb string search algorithm. The search string is assumed 
 *  to be all lower-case. The string to be searched is folded to lower case.
 */
#define tolower(c) ((c) >= 'A' && (c) <= 'Z' ? (c)+('a'-'A') : (c))
stringsearch(big,small)
char *big,*small;

{
    register char *b,*bp,*sp;
    b = big;
    while (*b != '\0') {
	if (tolower(*b) == *small) {
	    bp = b+1;
	    sp = small+1;
	    while (*sp != '\0' && *bp != '\0') {
		if (tolower(*bp) != *sp)
		    break;
		bp++;
		sp++;
	    }
	    if (*sp == '\0')
		return(1);
	}
	b++;
    }
    return(0);
}
