/*
 *  init.c
 *
 *  This file contains the routines used to initialize the screen, windows,
 *  and internal data structures.  The only external entry point is
 *  Initialize().
 *
 *  David Kaelbling, April 1983
 *  Gustavo Fernandez - Decreased drawing size for font compat. 10/26/84.
 *  GAF - Added Helvetica 12 fonts.  11/11/84
 *  GAF - New menu. 4/20/85
 *  
 */
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
# include "icons.h"
# include "menu.h"

    
/* Imports */
extern Highlight();
extern ICON_DESCRIPTOR IconList[];
extern InitINum();		/* Initialize the item number package */
extern short GetINum();		/* Get an item number */
extern short GetSeqINum();	/* Get a sequential set of item numbers */
extern short LastINum();	/* Return the last item number gotten
extern short FreeINum();	/* Return an item number to the freelist */
    
    
/* Exports */
extern Initialize();
extern InitFrame();
short Debug;
short sdf;
short mainSymbol;
short menuSymbol;
short mainVgt;
short menuVgt;
short modified;
enum Nib DefaultNib;
short DefaultNibItem;
enum Pattern DefaultPat;
short DefaultPatItem;
short DefaultOpaque;
short DefaultFilling;
short DefaultCentering;
short DefaultFont;
enum MenuOptions CurrentCommand,PrevCommand;
SPLINE *CurrentSpline;
short PointState;
ITEM_LIST_PTR *CurrentObject;
ITEM_LIST_PTR *activelist, *backuplists[NUMBACKUP], *backcobject[NUMBACKUP];
ITEM_DESCRIPTOR *itemlist;
short NumBackup, CurrentBackup;
extern FONTDATA FontData[];    
ITEM_LIST_PTR *Groups[MAXGROUP];
short Patterns[MAXPAT]; 		/* Itemnums for fill patterns*/
short Nibs[MAXNIB];		/* 4 sizes x 4 shapes */ 
short FontItem;			/* sdf item for current font symbol */
short MesgItem;			/* sdf item for current message symbol */
short MesgAge; 			/* Age of message for automatic erase */
short MesgLines;		/* Number of message lines */
short DrawSetup;		/* Initialization in progress */
short Monkey,MonkeySteps;	/* The monkey variables */
short DoneFlag;			/* Flag to favor Done button for Monkey */
short MainSymbolOpen;		/* True if the main VGTS symbol is open */
enum JournalMode Journal,OldJournal; /* Curr and prev journaling mode */
FILE *JournalFIn,*JournalFOut;	/* Journaling I/O files */
int JournalSteps,OldJournalSteps;  /* Journaling steps */
BOOLEAN SaveJournal;		/* Delete journal on Quit unless TRUE */
BOOLEAN PrintersSearched;     /* True if the printer names have been searched*/
    
/* Local Definitions */

/*
 *  This routine creates or edits the main drawing area symbol and puts up
 *  page frame which is just outside the default window. This is called by
 *  InitScreen and RedrawActivelist
 */
InitFrame(new)
BOOLEAN new;
{
    if (new)
        mainSymbol = DefineSymbol( sdf, GetINum(), "main draw symbol" );
    else
        mainSymbol = EditSymbol( sdf, mainSymbol, "Draw main symbol" );
    AddItem( sdf, 0, -2, PAGE_WIDTH+2, -2, PAGE_HEIGHT+2, 
		AllEdges, SDF_OUTLINE, NULL );
    EndSymbol( sdf, mainSymbol, 0 );
}
    

/*
 *  This internal routine will create the main drawing window, and do
 *  whatever initialization is necessary to start up the window system.
 */
  
InitScreen()
  {
    /* Initialize the Vgts and create the main view */
    if ((sdf = CreateSDF()) == -1)
      {
        printf("Couldn't create the sdf!\n\r\r");
	Exit(-1);
      }
    InitFrame(TRUE);
    if ((mainVgt = CreateVGT( sdf, GRAPHICS+ZOOMABLE,
	    mainSymbol, "drawing area")) == -1)
      {
	printf("Couldn't create the main Vgt!\n\r\r");
	Quit(1);
      }
    CreateView( mainVgt, 
		MVxmin, MVymin, 
		MVxmax, MVymax,
		16,16, 0, 0);
  }

/*
 *  This routine will create the menu, which consists of three sub-menus:
 *  the Action (Command/Object) Menu, the Static Menu (Exit, Help, .. Done),
 *  and the Defaults Menu, which specifies the default nib and fill pattern.
 */
 
InitMenu()
  {
    register ICON i;
    register int j1,j2;
    register ICON_DESCRIPTOR *p;
    SPLINE *sptr;
    
    menuSymbol = DefineSymbol( sdf,GetINum(), "Action Menu");
    
    /* Display all of the nouns */
    for (i = FIRST_NOUN;  i <= LAST_NOUN; (int) i++)
      {
	p = &IconList[i];
	j1 = (i-FIRST_NOUN) % NOUNROW;
	j2 = (i-FIRST_NOUN) / NOUNROW;
	p->xmin = NounXMin+j1*(32+GAP0);
	p->xmax = p->xmin+31;
	p->ymax = NounYMax-j2*(32+GAP0);
        p->ymin = p->ymax-31;
	
        IconList[i].itemnum = AddItem( sdf, GetINum(),
				      p->xmin, p->xmax, p->ymin, p->ymax,
				      MemoryRaster,SDF_RASTER,
				      IconList[i].data);
      }
    /* Display all of the verbs */
    for (i = FIRST_VERB;  i <= LAST_VERB;  i++)
      {
	p = &IconList[i];
	j2 = i-FIRST_VERB;
	p->xmin = VerbXMin;
	p->xmax = p->xmin+63;
	p->ymax = VerbYMax-j2*(32+GAP0);
        p->ymin = p->ymax-31;
	
        IconList[i].itemnum = AddItem( sdf, GetINum(),
				      p->xmin, p->xmax, p->ymin, p->ymax,
				      MemoryRaster,SDF_RASTER,p->data);
      }
    
    /* Display the Commands Menu */
    for (i = 0;  i < NumCommands;  i++)
      {
	j1 = ComdXMin + (i % CMDROW) * (65+GAP0);
	j2 = ComdYMin + (CMDCOL - 1 - (i / CMDROW)) * (32+GAP0);
        Commands[i].itemno = AddItem( sdf, GetSeqINum(5), j1+5, j1+55,
			j2+6, j2+29, 0, SDF_SIMPLE_TEXT, Commands[i].string);
	AddItem( sdf, 0, j1, j1+64, j2, j2+31, AllEdges, SDF_OUTLINE, 0 );
      }
    
    /* Display the Nibs Menu */
    if ((sptr = (SPLINE *) malloc( sizeof(SPLINE) )) == NULL)
      {
	printf("Couldn't allocate nib structure pointer.\n\r\r");
	Quit(1);
      }
    sptr->order = 1;
    sptr->numvert = 1;
    sptr->border = 1;
    sptr->closed = 0;
    sptr->filled = 0;
    sptr->opaque = 0;
    sptr->pat = DefaultPat;
    sptr->head.x = 0;
    sptr->head.y = 0;
    for (i = 0; i<MAXNIB; i++) {
      sptr->nib = (enum Nib) i;
      j1 = NibXMin+8+(16+GAP0)*(i % 4);
      j2 = NibYMax-8-(16+GAP0)*(i / 4);
      if (i!=0) 
      	Nibs[i]=AddItem( sdf, GetINum(), j1, j1, j2, j2, 0, SDF_SPLINE, sptr );
      else
	Nibs[0]=AddItem( sdf, GetINum(), j1-3,j1+12,j2-8,j2+7,
	     0, SDF_SIMPLE_TEXT, "N");
    }

    /* display the patterns menu */

    Patterns[0]  = AddItem( sdf, GetINum(), StipXMin+3,StipXMin+18,
	StipYMAX-15, StipYMAX, 0, SDF_SIMPLE_TEXT, "N");
    for (i = 1; i< MAXPAT; i++) {
      j1 = StipXMin + ((16+GAP0)*(i % STIPROW));
      j2 = StipYMAX - ((16+GAP0)*(i / STIPROW));
      Patterns[i] = AddItem(sdf, GetINum(), j1,j1+15,j2-15,j2,
	i-1+STIPPLE_OFFSET,SDF_FILLED_RECTANGLE,0);
    }

    /* Display the font and message rectangles */

    AddItem( sdf, 0, FontXMin,FontXMax,FontYMin,FontYMax,
		AllEdges, SDF_OUTLINE, 0 );
    AddItem( sdf, 0, FontTick1,FontTick1+1,FontYMin,FontYMin+3,
		BLACK, SDF_FILLED_RECTANGLE, 0 );
    AddItem( sdf, 0, FontTick2,FontTick2+1,FontYMin,FontYMin+3,
		BLACK, SDF_FILLED_RECTANGLE, 0 );
    AddItem( sdf, 0, FontTick1,FontTick1+1,FontYMax-3,FontYMax,
		BLACK, SDF_FILLED_RECTANGLE, 0 );
    AddItem( sdf, 0, FontTick2,FontTick2+1,FontYMax-3,FontYMax,
		BLACK, SDF_FILLED_RECTANGLE, 0 );

    AddItem( sdf, 0, MesgXMin,MesgXMax,MesgYMin,MesgYMax,
		AllEdges, SDF_OUTLINE, 0 );
    
    
    /* Close the menu symbol */
    EndSymbol( sdf, menuSymbol, 0 );

    /* set default hilighting for nibs, patterns and fonts. */
    SetCurrentNib(NibCircle1);
    SetCurrentPat(PatChainLink);
    SetCurrentFont(10,PositionCenter);		/* Helvetica12B, centered */
    
    /* Now that the action menu symbol exists, create a VGT and view of it */
    if ((menuVgt = CreateVGT( sdf, GRAPHICS, menuSymbol, "draw menu"))
	    <= 0)
      {
	printf("Couldn't create menu VGT!\n\r\r");
	Quit(1);
      }
    
    CreateView( menuVgt, Mxmin, Mymin, Mxmax, Mymax, 0, 0, 0, 0 );
  }

/*
 *  This is the externally callable initialization routine.
 */
 
Initialize()
  {
    short i;
    
    /* Put the TTY into raw mode. */
    GetTTY();

    DrawSetup = 1;	/* Disable mprintf */
    Debug = 0;
    sdf = 0;
    InitINum();
    menuSymbol = 0;
    mainSymbol = 0;
    menuVgt = 0;
    mainVgt = 0;
    modified = 0;
    DefaultNibItem = -1;
    DefaultPatItem = -1;
    DefaultOpaque = 0;
    DefaultFilling = 0;
    DefaultCentering = -1;
    FontItem = -1;
    MesgItem = -1;
    MesgLines = 0;
    MesgAge = -1;
    CurrentCommand = CNull;
    PrevCommand = CNull;
    CurrentObject = NULL;
    CurrentSpline = NULL;
    PointState = -1;
    activelist = (ITEM_LIST_PTR *) malloc( sizeof(ITEM_LIST_PTR) );
    activelist->prev = NULL;
    activelist->next = NULL;
    NumBackup = NUMBACKUP;
    CurrentBackup = 0;
    for (i = NumBackup;  i--; )
      {
	backcobject[i] = NULL;
	backuplists[i] = (ITEM_LIST_PTR *) malloc( sizeof(ITEM_LIST_PTR) );
	backuplists[i]->prev = NULL;
	backuplists[i]->next = NULL;
      };
    itemlist = NULL;
    for (i = 0;  i < MAXGROUP;  i ++)
      {
	Groups[i] = NULL;
      }
    LoadFont(3);    /*Message font must be loaded before we print messages*/
    InitScreen();
    InitMenu();
    DoneFlag = 0;
    Monkey = 0;
    MainSymbolOpen = 0;
    PrintersSearched = FALSE;
    DrawSetup=0;    /* This enables mprintf */

    /* Init journaling mechanism */

    JournalFIn = NULL;
    JournalSteps = 0;
    OldJournalSteps = 0;
    SaveJournal = FALSE;
    if ((JournalFOut=fopen(JOURNALNAME,"w"))!=NULL) {
	fprintf(JournalFOut,JOURNALHEADER);
	Journal = JournalRecord;
	OldJournal = JournalOff;
    }
    else {
	Journal = JournalOff;
	OldJournal = JournalOff;
	mprintf(2,"WARNING: Could not create Draw Journal file");
    }
  }
 
/*  Define the storage for the menu data  */
MenuData Commands[] =
  {
    " Done ",	0, 0,
    " Undo ",   0, 0,
    " Abort",   0, 0,
    " Load ",   0, 0,
    " Save ",   0, 0,
    " Print",   0, 0,
    " Debug",   0, 0,
    " Clear",   0, 0,
    " Quit ",   0, 0,
    " Font1",   0, 0,
    " Font2",   0, 0,
    " Help ",   0, 0,
  }; 
int NumCommands = sizeof(Commands) / sizeof(MenuData);
    
/* 
 * WARNING: Altoread uses certain font numbers directly. Check perm.c and
 * menu.c - GAF
 */

FONTDATA FontData[] =
  {
    "Clarity12",	0, 0, 0, 12,
    "Cream12",		0, 0, 0, 12,
    "Helvetica10",	0, 0, 1, 10,
    "Helvetica10B",	0, 0, 2, 10,
    "Helvetica18",	0, 0, 1, 18,
    "Helvetica7",	0, 0, 1, 7,
    "Helvetica7B",	0, 0, 2, 7,
    "Helvetica7BI",	0, 0, 4, 7,
    "Helvetica7I",	0, 0, 3, 7,
    "Helvetica12",	0, 0, 1, 12,
    "Helvetica12B",	0, 0, 2, 12,
    "Helvetica12I",	0, 0, 3, 12,
    "TimesRoman12",	0, 0, 5, 12,
    "TimesRoman12B",	0, 0, 6, 12,
    "TimesRoman12I",	0, 0, 7, 12,
    "APL14",		0, 0, 0, 14,
    "Ascii12",		0, 0, 0, 12,
    "cmr",		0, 0, 0, 12,
    "Cyrillic12",	0, 0, 0, 12,
    "Gates32",		0, 0, 0, 12,
    "Greek12",		0, 0, 13, 12,
    "Hebrew12",		0, 0, 0, 12,
    "Math12",		0, 0, 13, 12,
    "OldEnglish18",	0, 0, 0, 18,
    "Template64",	0, 0, 0, 12,
  };
 
