/*
 *  help.c
 *
 * The draw help command.
 *
 * Split off from perm.c by Gus Fernandez 4/11/85
 */ 
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern GetMisc();
extern char *GetString();
 
 
/* Exports */
extern Help();


/*
 *  This routine will provide all of the help facilities.
 */
 
Help()
  {
    short helping;
    short x, y, but;
    enum MenuOptions cmd;
    
    /* Determine topic */
    cmd = CNull;
    helping = 1;
    mprintf(2,"HELP is still under construction.");
#if 0
    while (helping)
      {
	printf("\fHELP:  Select a specific command, or Help to exit.\n\r\n\r");
	switch (cmd)
	  {
	    case CNull:
		printf("You are inside the help facility.\n\r");
		printf("To return to the regular program, hit Help again.\n\r");
		printf("For help on a specific command, hit that command.\n\r");
		printf("For help with the mouse buttons, push the right\n\r");
		printf("button while inside the drawing area.\n\r");
		printf("For even more help, see the User's manual.\n\r");
		break;
	    
	    case CRotate:
	        printf("The rotate command lets you rotate objects about\n\r");
		printf("a specific point.  You need to select the object,\n\r");
		printf("the point to rotate about, and two points which\n\r");
		printf("define the angle of rotation.  Rotating Text only\n\r");
		printf("moves it.  It doesn't rotate individual letters.\n\r");
		break;
		
	    case CScale:
		printf("Expand or contract objects about a point.\n\r");
		printf("Select the object, the fixed point, and a pair of\n\r");
		printf("points which define the stretch factor.\n\r");
		break;
	    
	    case CMove:
	        printf("Move an object about.  Select the object, and two\n\r");
		printf("points which define the distance to move it.\n\r");
		break;
	    
	    case CCopy:
		printf("Copy an object. Select the object, and two points\n\r");
		printf("which move the copy off of the original.\n\r");
		break;
	    
	    case CDraw:
		printf("The draw command is used to create new objects.\n\r");
		printf("If you ever select an object type without first\n\r");
		printf("selecting a command, the program assumes you wish\n\r");
		printf("to draw an object of that type.\n\r");
		break;
		
	    case CAlter:
	        printf("Modify an existing object.  This lets you change\n\r");
		printf("the fill pattern of filled object, the shape of\n\r");
		printf("objects, the nib used to draw them, etc.\n\r");
		break;
		
	    case CErase:
	        printf("Erase (delete) an existing object.  By using\n\r");
		printf("undo, you can get back a recently deleted object.\n\r");
		break;
		
	    case CLower:
	        printf("Lower puts an object behind all of the others.\n\r");
		printf("If you are using opaque ink, this is useful.\n\r");
		break;
		
	    case CRaise:
	        printf("Raise puts an object in front of all the others.\n\r");
		printf("If you are using opaque ink, this is useful.\n\r");
		break;
	    
	    case CAllObj:
	        printf("When possible, this means select all of the\n\r");
		printf("objects at once. Useful for moving, copying, etc.\n\r");
		break;
	    
	    case CText:
	        printf("Text objects are strings of characters.  The font\n\r");
		printf("used to display the text does not change this.\n\r");
		break;
		
	    case COpenCurve:
		printf("A curve which does not close automatically.\n\r");
		break;
		
	    case CClosedCurve:
	        printf("A curve which automatically closes itself.\n\r");
		break;
	
	    case CxCurrentObj:
   		printf("This command is scheduled to be demolished next\n\r");
		printf("Tuesday. In the meantime, buy bonds and have a\n\r");
		printf("nice day.\n\r");
		break;
	
	    case COpenPolygon:
		printf("A bunch of connected straight lines.\n\r");
		break;
	
	    case CClosedPolygon:
		printf("A closed polygon.  When drawing one, you need\n\r");
		printf("only give the corners of the object.\n\r");
		break;
	
	    case CGroup:
		printf("A group of objects is several objects taken\n\r");
		printf("together as a unit.  All groups have names,\n\r");
		printf("which are used to identify them.\n\r");
		break;
	
	    case CTemplate:
		printf("Templates are standard shapes.  Arrowheads (both\n\r");
		printf("open and closed, wide and narrow), Rectangles,\n\r");
		printf("Ovals, and Circles are supported.\n\r");
		break;
	
	    case CDone:
		printf("Done is used to confirm your choices.  It will\n\r");
		printf("cause the current command to be executed, and\n\r");
		printf("finished.  If you wish to execute the current\n\r");
		printf("command, then keep executing it, use the left\n\r");
		printf("two mouse keys to signal 'Almost Done'.\n\r");
		break;
	    
	    case CAbort:
		printf("Abort will stop the current command, making\n\r");
		printf("things look like they did before you started it.\n\r");
		break;
	
	    case CUndo:
		printf("Undo will attempt to reverse the effects of the\n\r");
		printf("last selection you made.  If you hit 'Undo' when\n\r");
		printf("no command is in progress, the last command you\n\r");
		printf("did will be reveresed.  If you undo a command by\n\r");
		printf("mistake, hit undo %d more times.\n\r", NUMBACKUP - 1);
		printf("If you use undo during the middle of a command,\n\r");
		printf("it will undo your previous selection.\n\r");
		break;
	
	    case CMisc:
		printf("This contains all of the miscellaneous commands:\n\r");
		printf("for reading and writing files, for clearing the\n\r");
		printf("screen, etc.\n\r");
		break;
	
	    case CHelp:
		helping = 0;
		break;
	
	    case CExit:
		printf("The exit command will exit the program.\n\r");
		printf("It does not automatically save your work, but it\n\r");
		printf("will ask you if you really want to exit with\n\r");
		printf("unsaved changes.\n\r");
		break;
	
	    case CNib:
		printf("The nib command lets you change the default nib,\n\r");
		printf("which is used when creating new objects.  Nibs\n\r");
		printf("come in four shapes and sizes.  The shapes are\n\r");
		printf("circular, square, a horizontal dash, and a\n\r");
		printf("vertical bar.  Size 0 is a single dot.\n\r");
		break;
		
	    case CPattern:
		printf("That command lets you change the fill defaults.\n\r");
		printf("You can select opaque or transparent ink, or one\n\r");
		printf("of a number of fill patterns.  The 'Fill on/off'\n\r");
		printf("command controls whether new closed objects\n\r");
		printf("are filled or not.\n\r");
		break;
	
	    case CFilling:
		printf("That command toggles whether or not new closed\n\r");
		printf("objects are filled.\n\r");
		break;
		
	    case CTextDefault:
		printf("That command controls how new text is positioned\n\r");
		printf("(by the bottom left, center, or right), and which\n\r");
		printf("font it is in.\n\r");
		break;
	
	    case CDataPoint:
		printf("Pressing mouse buttons in the drawing area can\n\r");
		printf("have many effects, depending on the buttons used.\n\r");
		printf("The buttons work as follows:\n\r");
		printf("  x - -: Data point right here.\n\r");
		printf("  - x -: Find the nearest sticky point.\n\r");
		printf("  - - x: Data point at nearest grid intersection.\n\r");
		printf("  x x -: Almost Done.  (Try it for more info.)\n\r");
		printf("  x - x: Checkpoint.  (Try it for more info.)\n\r");
		printf("  - x x: Undo.  (Try it for more info.)\n\r");
		printf("  x x x: Abort.  (Try it for more info.)\n\r");
		printf("The mouse is currently pointing at (%d, %d)\n\r",
			x, y);
		break;
	
	    case CCheckPoint:
		printf("Create a checkpoint.  Normally, a checkpoint is\n\r");
		printf("made before each command, but if you are using\n\r");
		printf("'Almost Done' to run several commands together,\n\r");
		printf("you may want to use this command for safety.\n\r");
		break;
	
	    case CAlmostDone:
		printf("The Almost Done command is similar to the Done\n\r");
		printf("command, except that you are still executing the\n\r");
		printf("same command after you use it.  Done will finish\n\r");
		printf("the command entirely.\n\r");
		break;
		
	    default:
		printf("Internal Error:  Bad command to Help (%d).\n\r", cmd);
		break;
	  }
	
	/* Update state. */
	if (helping)
	  {
	    printf("\n\r\n\r");
	    GetInput( &cmd, &x, &y, &but );
	  }
	else
	    printf("Exiting the Help Facility.\n\r\n\r");
      }
#endif
  }
