/*
 *  commands.c
 *
 *  This file contains the code the deal with the named draw commands
 *  such as load, save, etc. 
 *
 *  This was originally perm.c
 *
 *  Original perm.c by David Kaelbling, May 1983
 *  Reorganized commands.c by Gus Fernandez, May 1985
 *
 */
 
 
/* Includes */
# ifdef UNIX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern char *GetString();
extern char *GetStr2();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
extern CopyObject();
extern MoveObject();
extern SetCurrentObject();
extern DrawPress();
extern WriteFile();
extern ReadFile();
extern SetCurrentCommand();
extern WritePSM();
extern short GetINum();		/* Get an item number */
extern short GetSeqINum();	/* Get a sequential set of item numbers */
extern short LastINum();	/* Return the last item number gotten
extern short FreeINum();	/* Return an item number to the freelist */
 
 
/* Exports */
extern CommandHelp();
extern CommandLoad();
extern CommandSave();
extern CommandPrint();
extern CommandAll();
extern CommandClear();
extern CommandQuit();
extern CommandFont1();
extern CommandFont2();
 
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# define SILHEADER	034562	/* SIL format header (password) */



/*
 *  The help front end
 */
CommandHelp(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  Help();
}

/*
 *  The clear front end
 */
CommandClear(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    ITEM_LIST_PTR *p,*q;
    if (cmd != CClear) {
	mprintf(2,"Clear aborted!\n'\r");
	SetCurrentCommand(CNull);
    }
    else if (CurrentCommand!=CClear) {
	mprintf(0,"Are you sure you want to clear?\n\rClick clear again to confirm.\n\r\007");
	SetCurrentCommand(CClear);
    }
    else {
	Checkpoint();
	SetCurrentObject(NULL,0);
	p = activelist->prev;
	while (p)
	      {
	        q = p->next;
		EraseObject( p, 0 );
		p = q;
	      }
	DisplayItem( sdf, mainSymbol, mainVgt );
	modified = 0;
	SetCurrentCommand(CNull);
	DeleteMessage(0);
    }
}

/*
 *  The Load front end
 */
CommandLoad(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  if (Monkey) return;
  ReadFile();
}

/*
 *  The Save front end
 */
CommandSave(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  if (Monkey) return;
  WriteFile();
}

/*
 *  The Print front end
 */
CommandPrint(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
  if (Monkey) return;
    DoPrint();
}
/*
 * These are the pop-up items for the debug menu
 */
static PopUpEntry DebugMenu[] =
  {
    "Debug flags...",		0,
    "All flags off",		1,
    "Monkey",			2,
    "Active list",		3,
    "Item numbers",		4,
    "Vitals",			5,
    "Debugger",			6,
    "Keep journal file",	7,
    NULL,			0,
  };

static PopUpEntry DebugFlagsMenu[] =
  {
    "  Back end     ",	1,
    "  Find         ",	2,
    "  Input        ",	4,
    "  Events       ",	8,
    "  Item numbers ",	16,
    "  I/O          ",	32,
    "  Point        ",	64,
    "  Messages     ", 128,
    NULL,			0,
  };



/*
 *  The Debug front end
 */
CommandDebug(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    short i,temp;
    int *crowbar;
    if (Monkey && but != 7) return;
    i = GetPopup( DebugMenu );
    if (i < 0) return;

    switch(i) {
	case 0: /* Debug on */
	    for (i = 0,temp=1;i<DEBUG_ITEMS;i++,temp *= 2)
		if (Debug&temp) {
		    DebugFlagsMenu[i].string[0]='+';
		}
		else {
		    DebugFlagsMenu[i].string[0]='-';
		}
    	    i = GetPopup( DebugFlagsMenu );
    	    if (i < 0) return;
	    Debug ^= i;
	    printf("Debug mode (%d).\n\r",Debug);
	    break;
	case 1:	/* Debug off */
	    Debug = 0;
	    printf("Exit Debug mode.\n\r");
	    break;
	case 2: /* Monkey */
	    printf("The monkey is a debugging tool which generates random\n\r");
	    printf("events until a step count is reached or the program crashes.\n\r");
/*	    printf("hold down all three mouse buttons in the debug box to regain control.\n\r"); */
	    printf("Enter the number of steps to run, -1 for infinite, 0 to cancel:"); 
	    Monkey = 0;
	    MonkeySteps = atoi(GetStr2("        ",8));
	    temp = MonkeySteps == 0 ? 0 : 1;
	    if (!temp) break;
	    printf("Enter a random number seed:");
	    i = atoi(GetStr2("        ",8));
	    srand(i);
	    Monkey = 1;
	    printf("Monkey turned on.\n\r");
	    break;
	case 3:	/* Active List */
	    DebugObjectList( "active list", activelist, 4 );
	    break;
	case 4:	/* Item numbers */
	    DebugINum();
	    break;
	case 5:	/* Vitals */
	    printf("    sdf = %d, menuVgt = %d, mainVgt = %d,\n\r",
		sdf, menuVgt, mainVgt );
	    printf("    menuSymbol = %d, mainSymbol = %d.\n\r",
		menuSymbol, mainSymbol );
	    printf("\n\r");
	    break;
	case 6: /* Abort to debugger */
	    printf("Down we go...\n\r");
	    ResetTTY();
	    crowbar = (int *)1;
	    *crowbar = 0xfade;
	    GetTTY();
	    printf("Welcome back!\n\r");
	    break;
	case 7: /* Keep journal */
	    if (Journal != JournalPlay)
	        SaveJournal = TRUE;
	    if (JournalFOut != NULL)
		fflush(JournalFOut);
	    break;
      }
}

/*
 *  This function will perform the 'quit' command.
 */
CommandQuit(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    
  if (Monkey) return;
    /* Don't exit in the middle of things. */
    if (Journal==JournalPlay) {
	mprintf(2,"Quit disabled during Journal playback");
	SetCurrentCommand(CNull);
	return;
    }
    else if (cmd != CQuit) {
	mprintf(2,"I guess we'll stay around a bit longer.\n\r");
	SetCurrentCommand(CNull);
    }
    else if (CurrentCommand!=CQuit) {
	/* If unsaved changes exist, confirm exit. */
	if (modified)
	    mprintf(0,"**WARNING** There are unsaved changes.\n\r\007Click Quit again to exit draw.\n\r");
	else
	    mprintf(0,"Click Quit again to exit draw.\n\r");
	SetCurrentCommand(CQuit);    
    }
    else {
	/* 
	 * This is the "Normal" quit exit. Delete the journal file unless the
	 * user explicitly asked to keep it. Non-fatal errors will also set
	 * the SaveJournal flag.
 	 */
	if (!SaveJournal && JournalFOut != NULL) {
	    fclose(JournalFOut);
#ifdef UNIX
	    unlink(JOURNALNAME);
#else  UNIX
	    RemoveFile(JOURNALNAME);
#endif
	    JournalFOut = NULL;
	}
    	Quit(0);
    }
}


/*
 *  This is the Select all command. 
 */
CommandAll(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
CommandDebug(cmd,x,y,but);
}
/*
 *  This is the default nib command. 
 */
CommandNib(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    SetCurrentNib(x);
    if (CurrentObject != NULL) {
	Checkpoint();
	AttribObject(CurrentObject,0,x,-2,-1,-1);
    }
}
/*
 *  This is the default pattern command. 
 */
CommandPattern(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    SetCurrentPat(x);
    if (CurrentObject != NULL) {
	Checkpoint();
	AttribObject(CurrentObject,0,-1,x,-1,-1);
    }
}
/*
 *  This is the Fonts 1 command. 
 */
CommandFont1(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    GetNewFont(1,-1);
}
/*
 *  This is the Font 2 command. 
 */
CommandFont2(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    GetNewFont(2,-1);
}
/*
 *  This is the centering command. 
 */
CommandCenter(cmd,x,y,but)
enum MenuOptions cmd;
short x,y,but;
{
    GetNewFont(-1,x);
}
