@device(Vpostscript)
@part( draw, root "manual" )
@chapter(Draw: A Drawing Editor)@label(draw)

The @i(Draw) program is a document illustrator that can be used to add
figures to documents created with programs such as Scribe. This program is
loosely based on the Alto DRAW program, and the Apple MacDraw program.
Many of the same primitive objects
are common to all three programs, but there are many features unique to V
draw.

@section[Conceptual Model]

Draw is an "object" oriented graphics editor as opposed to a "bitmap"
oriented editor. This means that draw allows you to freely manipulate the
figures that you create after they have been placed on the screen at the
expense of being able to do fine freehand sketching and other functions such
as seed filling.

The graphics model offered by Draw is very close to that provided by the
underlying Virtual Graphics Terminal System (VGTS). All graphic objects
manipulated by draw are variations on three general types: splines, text,
and groups. 

@b(Splines) are b-splines of order 2, 3, or 5. Order 2 splines have
straight edges and are thus referred to as @i(polygons). Order 3 splines use
quadratic interpolation, and are thus referred to as @i(curves). @b(Circles) 
use order 5 splines which use quartic interpolation. Other shapes such as 
@b(ovals), @b(rectangles), and @b(arrowheads) are special cases of the more
general order 2 and 3 splines.

Splines can either be @b(open) or @b(closed). Open splines have two ends.
Closed splines do not have any endpoints. Any spline can have a border drawn
with one of 15 pens or @b(nibs). A spline may also be filled with any of 27
@b(patterns). All splines have either a border, a fill pattern, or both. Fill
patterns can either be @b(opaque) or @b(transparent). Any parts of objects 
lying behind an opaque object will not be visible. On the other hand, if the
object is transparent, then it will act as a screen where the objects
underneath will show through in the areas where the upper object is not
black.

@b(Text) objects allow you to place any type of written message on the page.
Text can be in one of various @b(fonts). It can also be either left, center,
or right @b(justified.)

@b(Groups) do not have any graphic shape of their own, but are used to keep 
various objects together. Any operation performed on a group is performed
on all of its members. Groups can be nested; that is, one group may be a
member of another group. This nested relationship is strictly hierarchial. No
recursive nesting is allowed.

@section[Screen Layout]

When the program is first invoked, it will create two new windows on the
screen.  The large empty one is the main drawing area (known as ``drawing
area'' to the VGTS), and the smaller one is the commands window (known as
``draw menu'' to the VGTS).  The drawing area is zoomable,
and the grid spacing available at normal
magnification is the same as that used by the program.  Since the program
has no way of knowing what magnification you are using, it aligns to the
unzoomed grid values.  The VGTS will place grid points at a constant
separation, regardless of magnification.  You may create additional views,
move existing views, etc., to your satisfaction.  The default drawing area
is in the proportion of 8.5 by 11, and centered.  A frame is put around the
actual size of a drawing page to provide some reference points if you zoom
the view or change its centering.  The frame is normally not visible, as it
lies entirely outside the default view.  It will not appear in any output.

The menu window is shown i figure @ref(draw-menu-figure).
    @Begin (Figure)
    @Case(GenericDevice,
	PRESS "@PressPicture(File=drawmenu.press, height=6.2inches)",
        Postscript "@Picture(Postscript=drawmenu.psf, size=5.96inches)")
    @Caption (The Draw menu)
    @tag (draw-menu-figure)
    @End (Figure)
The Menu window is divided into several sections. Near the top, there is a
set of square icons known as @b(nouns). These define the various primitive
objects which can be created with Draw. Along the left hand side are the 
elongated @b(verb) icons. These define the types of transformations which can
be performed on already existing objects. Below the nouns are the @b(nib) and
@b(pattern) sections, collectively known as the @b(attribute) section. 
These can be used to modify the appearance of all
non-textual objects. Below these are various Draw @b(commands) which are used
to perform various functions. Below the commands is a rectangle which
displays the currently selected @b(font). This window displays the name of
the font in its own typeface and is also used to set text justification.
The Font1 and Font2 "commands" as well as the font rectangle also fall
under the heading of "Attributes" as these are used to set text attributes
like the nib and pattern sections are used to set attributes of other objects.
At the very bottom of the menu is another
rectangle where various Draw @b(messages) are displayed.

The original window which you used to run the draw program will serve 
as an area where text will be input. In the future, Draw will have text
editing in menu and drawing area windows, and thus the original window will
only be used for printing unexpected error messages such as memory full
errors.

@section[General style of interaction]

Almost all Draw interaction (except for text and filename input) is done
with the mouse. To create an object, click on one of the noun icons in the
menu and then click one or more times in the drawing area to set control
points for that object. There are three types of objects: indefinite point
objects, definite point objects, and text objects. Indefinite point objects,
such as curves and polygons will accept input for an arbitrary
number of points. To terminate one of these objects, click the @b(Done)
command in the menu. Definite point objects, such as circles, rectangles,
and arrowheads require a fixed number of control points. Each point displays
a prompt in the message box which indicates what this point will be used for.
For example, a circle first asks for a center point, and then for a point 
along the edge. Text objects ask for a single control point to position the
text, and then prompt for the text string from the keyboard.

Draw maintains a @b(current object). This object is indicated by framing it
with a rectangle. A newly created object becomes the current one. To change
the current object, simply click on another one. Draw will find the object
that is closest to the point that you click on and select that object. No
object need always be current. To un-select all objects, click in a blank
section of the drawing area window.

To manipulate an object, first select it, thus making it the current object,
and then click on one of the verb or attribute icons. Depending on the 
operation involved, Draw will request zero or more data points required to
perform the given operation. These will
be prompted for in the message rectangle.
At any time, you can halt an operation with the 'Abort' command.

@section[Control Points and Sticky Points]

When you create a curve, you will be asked to specify the Control Points of
the spline.  These points are the places which you wish the curve to pass
near.  The more control points you put in one place, the nearer
the curve will come to that place.  Also, placing multiple control
points at a single point will make the curve much 'sharper' at that point.
Except for the end points of open curves, and multiple control
points, the curve will not, in general, 
pass through any of the control points.

Sticky points (similar to Knots) are points which actually lie on the curve.
They are calculated by the program to help you with the alignment of
objects.  There will be the same number of control points and sticky points
on curves.  Polygons are a special case, in that since the control points of
a polygon actually lie on the 'curve', the program considers them to be
sticky points too.  This means that the sticky points on polygons lie at the
corners and in the middle of each edge.  Sticky points for bounding boxes
(e.g., for @c[Text] objects) are the same as those for polygons.


@section[Mouse Buttons]

When the mouse is clicked inside the Menu, it is unimportant which mouse
buttons you use.  Within a popup menu (a list of choice which 'pops up'
after you do something), you can abort by either clicking outside the menu
or by pressing all three mouse buttons down and releasing them.  In general,
you don't have to release (or press) the buttons all at once, but the mouse
position is based upon where the cursor is when you release the last button.

Clicking the mouse inside the drawing area can cause one of several
different commands (and mouse locations) to be used by the program.  The use
of mouse buttons within the drawing area is as follows:

@begin(group)
@begin(verbatim)
    Buttons  Effect
    -------  ------
     X - -   Specifies a data point right where you are pointing.
     - X -   Requests the program to find a sticky point.
     - - X   Requests the program to use the nearest grid point.
     X X -   The 'Again' command. (see below)
     X - X   The 'ToggleSelect' command. (see groups below)
     - X X   Equivalent to the 'Undo' command.
     X X X   Equivalent to the 'Abort' command.
@end(verbatim)
@end(group)

Sticky points are points located on or near existing objects on the screen.
They are useful for connecting lines to objects, specifying points actually
on the object, etc.  Groups themselves do not have sticky points,
although the objects within a group may.  Curves have one sticky point per
control point.  These points are located midway between each pair of control
points.  When you request that the program select a sticky point, it will
choose the nearest such point which is within a given radius (about 1
inch).  

Grid points are spaced every 16 pixels (at normal magnification).  If you
wish to see these grid points, use the @b[Toggle Grid] command within the
VGTS.  For printed output, pixels are assumed to be distributed at 72
per inch.

The @b[Again] command allows the previous operation to be repeated. It is
equivalent to issuing the @b[Done] command (if necessary) and then clicking
in the icon for the previous operation. For example, the easiest way to make
fine adjustments to the position of an object is to first click on the
@b[Move] verb icon, and then click on a source and destination data point.
If you are not satisfied with the move, click @b(Again) and repeat the
operation without having to go all the way over to the menu.

This command is also quite useful when drawing a series of objects of
similar type.  You can specify that you wish to draw a closed curve, place
the control points for the curve, and then confirm with 
@b[Again].  The program will complete the curve you have
outlined, and wait for you to specify another closed curve, just as if you
had confirmed with @b[Done], and then selected @b[Closed Curve]
again.

The @b(Abort) command is used to cancel the current operation without
creating or manipulating any objects. Abort will never throw you completely
out of Draw. Use @b(Quit) for that. Some commands, such as @b(Raise) and 
@b(Lower),
are executed immediately and thus cannot be aborted. Use the @b(Undo) to
back out of these.

The @b(Undo) and @b(ToggleSelect) functions are described more fully in the 
sections on Undo and Groups below.

@section[Verbs]

There are eleven @b(verbs) in Draw. They are indicated by the set of
elongated icons along the left-hand side of the menu.
Each is useful for manipulating one or more
objects.  All verbs require that an object be selected before they are
executed. Here they are described as they appear from top to bottom.

@Begin(description)
@b[Move]
@\This verb will permit you to specify a pair of
points which define a displacement vector.  This vector tells the program
how far and in which direction to move the object.  By using this command,
you can move existing object about on the screen.

@b[Copy]
@\This verb is similar to @b[Move], except that it leaves behind an image of
the object.  

@b[Erase]
@\This command allows you to delete (erase) the selected object. This requires
no extra data points. If you make a mistake, you can always issue 
the @t[Undo] command.

@b[Alter]
@\This verb is useful for changing the characteristics of an existing
object.  It will permit you to move the control points on splines, change
aspects of text objects, etc.  @b[(Not yet implemented)]

@b[Rotate]
@\@begin(multiple)
This verb will permit you to specify a fixed point about
which the rotation is to take place, and two points which will define the
angle of rotation.

Text is rotated about its positioning point.  Only the position of the text
is changed; the orientation of individual letters is constant.
@end(multiple)

@b[Scale]
@\@begin(multiple)
This verb will permit you to select an object, specify a fixed point for
the scaling, and two points which define the scaling factor.  This command
is useful for expanding and contracting objects. X and Y dimensions are
scaled equally.

Scaling text will not change its size or font.  It will change the
location of the string based upon its positioning point.
@end(multiple)

@b[Stretch]
@\This verb is similar to the @b(Scale) command except that X and Y scaling
is independent. THus an object may be made taller but not wider and vice
versa.

@b[Group]
@\This verb binds a collection of objects into a group. If a single group
is selected, it will un-bind that group back into a collection. Collections
are created with the @b(ToggleSelect) mouse sequence to essentially allow
more than one object to be selected at one time. This, in a sense, creates
a temporary group. The @b(Group) verb makes this permanent, or makes a
permanent group temporary. @b<(Not yet implemented.)>

@b[Raise]
@\This verb 
will place the selected object on top of all of the other
objects.  Note that you can still point to objects you can't see; the
program will find sticky points on completely obscured objects with no
difficulty.

@b[Lower]
@\This verb will place the selected object behind
all of the other objects.  This is useful when you use opaque ink to fill
something, and it winds up obscuring an object you want to see.

@b[Opaque]
@\This verb will toggle between opaque and transparent filled objects. Opaque
objects completely obscure anything they overlap. Transparent objects act
like a screen in that they allow what is under them to show through white
areas.

@End(description)


@section[Nouns]

There are eighteen icons in the noun section. These are indicated by square
icons near the top of the menu.

@Begin(description)
@b[Polygons and Curves]
@\There are three polygon icons and three curve icons. The three icons in each
class correspond to open-unfilled, closed-unfilled, and closed-filled
respectively. (It does not make sense to have an open filled shape.) To
create one of these types of objects, first select the icon, and then click
on as many control points as desired, and then click on the @b(Done) command.
You can also abort the object by clicking the @b(Abort) command either from
the menu, or by the (all three buttons down) mouse sequence. Closed unfilled
polygons look just like open polygons except that no line is drawn from the
last point back to the first. Closed curves are continuous and need not cross 
any control points. Open curves, however will begin and end at the first and
last control point.

@b[Arrowheads]
@\There are four types of arrowheads: wide-open, wide-closed, narrow-open, and
narrow-closed. All are entered in the same way. First the tip of the
arrowhead is requested, and then its root. Arrowheads are separate objects
from the main stem of the arrow and are generally placed after the stems
have been drawn.

@b[Circles]
@\Circles come in two types - filled and unfilled. The two required data
points are the center point and any point along the edge. Circles are the
only shapes drawn as order 5 b-splines. Ovals and curves use order 3
b-splines.

@b[Ovals]
@\Ovals also come in filled and unfilled varieties. The data points are two
opposite corners of the inscribing rectangle. The shape of an oval is exactly
the same shape as would be produced by creating a curve, specifying the four
corners of the inscribing rectangle as control points.

@b[rectangles]
@\These work exactly like ovals but with (Amazingly) straight edges!

@b[Text]
@\Creating a text object will first prompt for a single control point. This
will specify the left, center, or right side of the text at the baseline.
(the bottom line which most characters touch. Letters such as p's and q's
descend below the baseline.) Draw will then prompt for the text itself
to be entered from the keyboard.

@b[PressEdit symbol (<==<<)]
@\This is a special text object which is used to match a Draw illustration
with a Scribe generated document when printing to a Press printer. (see the
section below on including Draw-generated illustration in documents.)
@End(description)

@section[Attributes]

All objects have certain attributes. Text objects have font and
justifications attributes. Other types of objects have filling and border
attributes. 
No attribute currently applies to
both text and non-text objects.
Various functions in Draw can be used to change these attributes.
These same functions set the default attributes for newly created attributes.
To change the attribute of an existing object, select it, and then click in
one of the attribute functions in the menu. To set attributes for a new
object, first un-select any selected object by clicking in white space in the
drawing area, set the desired attributes, and create the object. Attributes
can also be changed while an object is being created. The attributes that are
indicated when the last data point is entered are the ones that stick.

he following attributes are available
@Begin(description)
@b[Fonts]
@\@begin(multiple)
Fonts are changed using the @b(Font1) and @b(Font2) commands. Even though
these are technically "commands" in that they appear in the commands section,
they actually work more like attributes and are thus described here.

Both bring up a pop-up menu with a list of available fonts. Font1 provides
some fairly standard fonts while Font2 provides some more exotic ones. Once
a font is selected, it is loaded from disk if necessary, and then its name
is displayed in the font rectangle in the menu in its own typeface. (Non-
Ascii fonts such as Template64 may look weird.)
@end(multiple)

@b[Text Justification]
@\There are three different ways of positioning text; you can specify (with
a data point entered via the mouse) either the left-hand corner,
the center, or the right-hand corner of the baseline of the text. This
provides for left, center, or right justification. Note that the baseline is
the bottom line that @c(most) letters just touch. Small letters with
descenders may actually go below the baseline. The current justification is
indicated by the position of the name of the current font in the font
rectangle. You will notice six small tick marks just inside the font
rectangle which divide it into three parts. Clicking in 
either the left, center, or right area will set the respective justification
and move the font name accordingly. Note that the observed action if there is
a text object selected in the drawing area is not intuitively obvious.
Selecting @b(left) justification will cause an object to be shifted
@b(right) if it was not already left justified. This is because the object's
control point is kept stationary. (Think about it.)
If you are still confused about where text
should appear, try positioning a few strings, using the exact positioning
(leftmost) mouse button.

@b[Nib]
@\Nibs select the "brush" that the borders of non-text objects are drawn with.
There are 15 different types of nibs arranged in a four-by-four square of
four shapes (square, circle, dash, and bar) by four sizes. The sixteenth nib,
corresponding to the smallest square is replaced by the letter "N" meaning
(N)o border. The square shapes provide sharp corners while the circular
shapes provide rounded corners. The largest of these also make nice dots if
a polygon or curve is created with just one point. The dashes and bars
create interesting calligraphic effects, especially for curves. The no border
feature only applies to filled objects. Draw prevents you from accidentally
making an object invisible by deleting both its boder and its fill pattern.

@b[Fill Pattern]
@\@begin(multiple)
Next to the nibs are a set of 27 fill patterns arranged in a 4 x 7 rectangle.
The 28th, at the top-left corner is marked with a letter "N" which stands for
(N)o fill pattern. This is different to the one just to its right which looks
blank. This is actually a white pattern which can be used to erase parts of
objects that the white object overlaps.

By default, all fill patterns are @b(opaque). This means that any objects
underneath them do not show through. A fill pattern may be made
@b(transparent) by clicking on the @b(opaque) verb which toggles the opacity
of an object. White areas of transparent objects allow objects below them
to show through. This feature can be used to create interesting effects such
as Venn diagrams. The white pattern when transparent is equivalent to no
fill pattern at all.
@end(multiple)
@End(description)

@section[Commands]

Below the nib and pattern attribute section and above the font rectangle is
the @b(command) section of the Draw menu.

@Begin(description)
@b[Done]
@\This command is used to terminate a curve or polygon which can have an
arbitrary number of points. You will notice that the command is outlined in
heavy black lines when it is appropriate. At other times, this command is
equivalent to the @b(Abort) command.

@b[Undo]
@\This allows you to back-out of the previous operation. There are two levels
of Undo in Draw. If you are in the middle of an operation that requires
multiple mouse clicks, then Undo will back out of the last mouse-click.
Pressing Undo several times will cause more of the command to be undone until
you back out completely from the command. There is also a global Undo which
works by taking a snapshot of the currently visible objects on the screen
after each command is executed. Ten of these snapshots are saved. Undo will
bring back the previous snapshot. The last ten operations can be backed out
of in this way. Pressing Undo 10 times is effectively a redo because you
return to the top of the circular Undo stack. This is handy in case that you
pressed Undo too many times. Note that @b(ALL) operations can be undone -
even @b(Clear)! Undo can also be executed by pressing the center and right
mouse buttons simultaneously.

@b[Abort]
@\This command is used to back out of an operation which requires several mouse
clicks completely. The state of Draw will be left as if the operation had
never been started. Abort can also be executed by pressing all three mouse
buttons simultaneously.

@b[Load]
@\This command is used to load files from disk. Anything loaded from disk is
actually appended onto what may already be on the screen. To load only what
is in the file, use the @b(Clear) command first.
Draw understands how to read
several different file formats: its own V draw files, Alto draw files,
Alto/V SIL files, and journal files. Obviously, V draw files are the
preferred format as they describe all of the information that V draw is
capable of editing. Alto Draw and SIL file support is provided so that users
who previously used one of these two drawing editors can port their files
over. Unfortunately, the translation is not perfect. For example, Alto
Draw dashed lines and the "Arrows" font are not supported. Journal files are
discussed below in the section about journalling.

@b[Save]
@\Although Draw can @b(read) files in the various formats discussed above, it
will only @b(write) its own V draw files. Journal files are created by a
completely different mechanism as discussed in "@b(Jounalling)" below.

@b[Print]
@\@begin(multiple)
Draw supports two different types of printers: @b(Press) and @b(Postscript). 

Press
printers are somewhat old, but rather fast workhorses which can print a page
every second. The Press document
format does not allow the full generality available in Draw. In particular,
filled spline objects are not supported and hence patterns, opaque, and even
raise and lower operations do not affect the final output to Press printers.
All of the fonts available in Draw, however, are printable on Press printers.
There are three Press printers at Stanford: Dover (Margaret Jacks Hall
second floor), Rover (Margaret Jacks Hall fourth floor), and Plover (Durand
building basement). The current page can be output to any of these printers
directly from the Draw menu. 

Postscript printers are more modern, but somewhat slower printers. A typical 
example is the Apple LaserWriter. Postscript printers are capable of
displaying any graphic objects created with Draw. Only the printer's internal
fonts are available,though. 
This includes the Helvetica and Times fonts. Also the
Ascii font is mapped onto the Courier font, and the Greek typeface becomes 
Symbol. These translations are not perfect but they do work most of the time.
Postscript printers tend
to be owned by specific groups and are not generally publicly available. For
this reason, Draw checks to see which printers are available to the local
UNIX V server and only displays those printers (if any).

The @b(Print) menu, besides letting you send files directly to various
printers, also allows you to save print files to disk for later printing or
for inclusion inside other text documents. This latter operation is
described in a section below.
@end(multiple)

@b(Debug)
@\This brings up a menu which provides several internal Draw debugging
features which are generally not of interest to the user. One function,
"Keep journal," is documented below in the section on journalling.

@b(Clear)
@\This provides a method of completely wiping Draw's "slate" and starting from
a fresh page. Because this operation is dangerous, Draw requires that you
click on the command @b(TWICE) before it is actually executed. Even then,
however, it can still be backed out of using the @b(Undo) command.

@b(Quit)
@\This is the best way to get out of the Draw program. Like the Clear command,
above, it must be clicked on twice to actually be executed.

@b(Font1 and Font2)
@\These two commands bring up menus which provide a selection of fonts. Font1
provides some more common fonts while Font2 provides more exotic ones.
Selecting one of these will make it the current font. If a text object is
already selected, it will change to the newly selected font. Otherwise, any
newly created objects will use this font.

@b[Help]
@\This command will provide a brief description of any other operation you like.
To get help on a specific operation, just select that operation after you 
select help.  To get help with the mouse buttons, push any one button in the
drawing area.  To exit help, select @b[Help] again.
@end(Description)

@section(Inserting Draw pictures in text documents)
DRAW has the capability of creating a file suitable for sending to
a Press or Postscript printer, 
or for inclusion inside a Scribe document. The method for doing this is
slightly different for Press than for Postscript.

@subsection(Press)

To insert a picture in a Scribe document, first place a PressEdit 
symbol (a text item showing ``<==<<'') in the bottom center of your picture.
Note that this symbol is already provided as one of the available pre-made
objects in the Draw menu. This actually has some special significance to
Draw as it will not allow you to change the font or the justification of
this object. It will also be automatically skipped when creating Postscript
output.

Choose the "Press file"
option from the @i(Print) menu. You will be prompted for a file name.
Because of the limitations of the Dover, filled splines and
polygons cannot be printed. These objects will appear unfilled and a warning
message will be displayed on the terminal. Some objects are also just too
complicated for the Dover to print. In this case, either garbage output
will be produced, or the ``press file too complicated'' message will be
printed on the header page with no other output. 

Once the Press file has been created, you can now edit your Scribe file to
automatically imbed the picture in your document. insert the line

@begin(programexample)
    @@libraryfile[picture]
@end(programexample)

near the beginning of your 
scribe input (.mss) file, and lines like the ones shown below
at the point where you want the picture to appear.

@begin(ProgramExample)
    ...like that shown in figure @@ref(press-example).

    @@Begin (Figure)
    @@PressPicture(file="example.press", height="3.4inches")
    @@Caption (An example figure)
    @@tag (press-example)
    @@End (Figure)
@end(ProgramExample)

This will produce output like that shown in figure @ref(press-example-figure).
    @Begin (Figure)
    @Case(GenericDevice,
	PRESS "@PressPicture(File=example.press, height=3.4inches)",
        Postscript "@Picture(Postscript=example.psf, size=3.4inches)")
    @Caption (An example figure)
    @tag (press-example-figure)
    @End (Figure)

@subsection(Postscript)
Postscript file inclusion is quite a bit different from Press printing. For
starters, the PressEdit symbol is not used. Instead, Draw automatically
figures out the extremes of the drawing and centers the picture accordingly.
There are two menu items in the @b(Print) menu which generate Postscipt
files. The "(print later)" option create a file which is exactly like the
one sent directly to the printers. The "(scribe)" version is suitable for
inclusion in Scribe generated documents.

Scribe requires a special variation on the normal Postscript device driver
file in order to correctly print documents with Draw illustrations. This
file, "vposts.dev" must be either in your local directory or in the Scribe
database directory. This file differs from the normal Postscript driver in
that it contains special header information which defines macros used by
Draw pictures. To used this driver, place the line

@begin(programexample)
    @@device[Vpostscript]
@end(programexample)

at the beginning of your 
scribe input (.mss) file, and lines like the ones shown below
at the point where you want the picture to appear.

@begin(ProgramExample)
    ...like that shown in figure @@ref(postscript-example).

    @@Begin (Figure)
    @@Picture(Postscript="example.psf", size=3.4inches)
    @@Caption (An example figure)
    @@tag (postscript-example)
    @@End (Figure)
@end(ProgramExample)

This will produce output like that shown in figure @ref(press-example-figure).

@subsection(Both)

Often you will want to have a Scribe document which is printable on both
types of printers. You would like to be able to have Draw generated
illustrations in both Press and Postscript format, and have the Scribe file
choose the correct illustration by just changing the @b(@@Device) command. To
do this, add the @b(@@LibraryFile) command at the top of your document as you
would for a Press file, and
add the following lines at the position where you want the illustration to
appear.

@begin(ProgramExample)
    @@Begin (Figure)
    @@Case(GenericDevice,
	PRESS "@@PressPicture(File=example.press, height=3.4inches)",
        Postscript "@@Picture(Postscript=example.psf, size=3.4inches)")
    @@Caption (An example figure)
    @@tag (example-figure)
    @@End (Figure)
@end(ProgramExample)

@Section(Journalling)
Whenever Draw starts up, it creates a file called "Draw.journal" in the
local directory. In this file, Draw will keep a record of all user input
events. If the program should crash in any way, the journal file will be
left so that the entire Draw session can be re-constructed. Under normal
circumstances, this file will be automatically deleted when you quit Draw
using the @b(Quit) command. You can explicitly ask that the journal file be
kept around by choosing the "keep journal file" from the @b(Debug) menu.

A journal file can be played back by first renaming it so that it does not
get clobbered the next time that Draw runs and then using the @b(Load)
command to read it in like any other file. You will then see your entire
previous Draw session performed very quickly before your eyes.

Note that journal files are @i(extremely) context sensitive. They depend on
everything being exactly as it was when the journal was recorded. For
example, if during the session, you loaded a regular file, edited it and
saved it, the journal will probably fail because the file being loaded will
be the new copy and not the old one.
