/*
 *  defaults.c
 *
 *  This file contains the routines to manipulate the defaults menu,
 *  which currently consists of all of two things:  default nib for
 *  line drawing, and default fill pattern for filling.
 *  It also contain the code to handle the CMisc command.
 *
 *  David Kaelbling, April 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern GetNewNib();
extern GetNewFill();
extern GetNewText();
 
 
/* Exports */
extern DefNib();
extern DefPattern();
extern DefFilling();
extern DefText();
    
    
/* Local Definitions (Should be the same as those in init.c) */
# define DMX		   0
# define DMY		 -31
# define MLL		 160

/*
 *  This routine will change the default nib.
 */
DefNib()
  {
    SPLINE *sptr;
    enum Nib oldnib;
    
    /* Don't do more work than necessary. */
    oldnib = DefaultNib;
    GetNewNib( &DefaultNib );
    if (DefaultNib == oldnib)
	return;
    
    /* Okay, its changed.  Display the new nib. */
    sptr = (SPLINE *) DefaultsMenu[0].ptr;
    sptr->nib = DefaultNib;
    EditSymbol( sdf, menuSymbol );
    ChangeItem( sdf, DefaultsMenu[0].splineno, 0, 0,
    		0, 0, 0, SDF_SPLINE, sptr );
    EndSymbol( sdf, menuSymbol, menuVgt );
    
    /* Work around the cursor redisplay bug */
    DisplayItem( sdf, menuSymbol, menuVgt );
  }

/*
 *  This routine will change the default fill pattern.
 */
DefPattern()
  {
    SPLINE *sptr;
    enum Pattern oldpat;
    
    /* Don't do more work than we need to. */
    oldpat = DefaultPat;
    GetNewFill( &DefaultPat, &DefaultOpaque );
    if (DefaultPat == oldpat)
        return;
	
    /* Update the sample pattern, since it has changed. */
    sptr = (SPLINE *) DefaultsMenu[1].ptr;
    sptr->pat = DefaultPat;
    EditSymbol( sdf, menuSymbol );
    ChangeItem( sdf, DefaultsMenu[1].splineno, 0, 0,
		0, 0, 0, SDF_SPLINE, sptr );
    EndSymbol( sdf, menuSymbol, menuVgt );
    
    /* Work around cursor redisplay bug */
    DisplayItem( sdf, menuSymbol, menuVgt );
  }

/*
 *  This routine will change the default filling of closed objects.
 */
 
DefFilling()
  {
    char *tmp;
    
    DefaultFilling ^= 1;
    tmp = DefaultsMenu[2].string;
    DefaultsMenu[2].string = DefaultsMenu[2].ptr;
    DefaultsMenu[2].ptr = tmp;
    EditSymbol( sdf, menuSymbol );
    ChangeItem( sdf, DefaultsMenu[2].itemno, DMX+72, MLL+DMX-12,
		DMY+3, DMY+20, 0, SDF_SIMPLE_TEXT, DefaultsMenu[2].string );
    EndSymbol( sdf, menuSymbol, menuVgt );
  }

/* 
 *  This routine will change the text defaults.
 */
 
DefText()
  {
    GetNewText( &DefaultCentering, &DefaultFont );
  };
